/* iod-telemetry Session.sql version 2019.06.12.1 stkolev */
with
    v$metricname as (
        /* version 3 */
        select
            ''              as project
            ,'oracle_db'    as fleet
            ,host_name      as host
            ,'"lifecycle":"'||
                case
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name not like '%.r1') or
                        regexp_like(host_name,'(dev|sandbox)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(dev|sand)')
                        then 'DEV'
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name like '%.r1%') or
                        regexp_like(host_name,'(test|tst)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(test|tst)')
                        then 'TEST'
                    else 'PROD'
                end || '"' ||
            ',"hostclass":"'|| nvl(regexp_substr(host_name,'^([^.]*)-',1,1,NULL,1),'N/A') || '"' ||
            ',"instance_name":"'     || instance_name    || '"' ||
            ',"db_name":"'           || nvl(name,'N/A')             || '"' ||
            ',"db_domain":"'         || nvl(sys_context('USERENV','DB_DOMAIN'),'N/A') || '"' ||
            ',"db_unique_name":"'    || db_unique_name   || '"' ||
            ',"database_role":"'     || database_role    || '"' ||
            ',"fsfo_role":"'||
                case
                    when database_role = 'PRIMARY' then 'PRIMARY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name)  = lower(fs_failover_current_target) then 'STANDBY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name) != lower(fs_failover_current_target) then 'BYSTANDER'
                    else 'NONE'
                end || '"' as metric_dimensions
        from v$database, v$instance
    ),
    v$metric_history as (
        select /*+ INLINE */ --avoids ORA-02145: missing STORAGE option when database is mounted
             nvl(c.name,'0') as name
            ,nvl(s.machine,'null') as machine
            ,nvl(s.username,'null') as username
            ,decode(bitand(k.ksuseflg,19),17,'BACKGROUND',1,'USER',2,'RECURSIVE','UNKNOWN') as type
            ,to_number(nvl(sp.value,first_value(sp.value) ignore nulls over (order by s.con_id))) limit
        from
             v$containers c
            ,v$session s
            ,x$ksuse k
            ,(select con_id, name, value from v$system_parameter where name ='sessions') sp
        where
            k.con_id = c.con_id (+) and /* driver is k instead of s */
            k.con_id = sp.con_id (+) and /* driver is k instead of s */
            BITAND(k.KSUSEFLG,19) IN (17,1,2) and /* BACKGROUND(17), USER(1) and RECURSIVE(2) */
            k.indx = s.sid(+) and
            k.ksuseser = s.serial#(+)
    ),
    v$metric as (
        select
             'Session.Count' as metric_name
            ,',"con_name":"'        || nvl(to_char(name     ),'null') || '"' ||
             ',"type":"'            || nvl(to_char(type     ),'null') || '"' ||
             ',"machine":"'         || nvl(to_char(machine  ),'null') || '"' ||
             ',"username":"'        || nvl(to_char(username ),'null') || '"' as metric_dimensions
            ,count(*) as metric_value
        from
            v$metric_history
        group by
            name
            ,type
            ,machine
            ,username
        union
        select
             'Session.' || metric_name as metric_name
            ,',"con_name":"'        || nvl(to_char(name     ),'null') || '"' metric_dimensions
            ,metric_value as metric_value
        from (
            select
                name
                ,max(limit)                             as "Limit"
                ,round(count(*)/max(limit)*100,2)       as "PercentUsed"
            from
                v$metric_history
            group by
                name
        ) unpivot (
            metric_value FOR metric_name IN (
                 "Limit"
                 ,"PercentUsed"
            )
        )
    )
select
    v$metricname.project                        as project
    ,v$metricname.fleet                         as fleet
    ,v$metricname.host                          as host
    ,v$metric.metric_name                       as metric_name
    ,v$metric.metric_value                      as metric_value
    ,'{'||v$metricname.metric_dimensions||v$metric.metric_dimensions||'}' as metric_dimensions
from v$metricname,v$metric
