with
    v$metricname as (
        /* version 3 */
        select
            ''              as project
            ,'oracle_db'    as fleet
            ,host_name      as host
            ,'"lifecycle":"'||
                case
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name not like '%.r1') or
                        regexp_like(host_name,'(dev|sandbox)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(dev|sand)')
                        then 'DEV'
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name like '%.r1%') or
                        regexp_like(host_name,'(test|tst)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(test|tst)')
                        then 'TEST'
                    else 'PROD'
                end || '"' ||
            ',"hostclass":"'|| nvl(regexp_substr(host_name,'^([^.]*)-',1,1,NULL,1),'N/A') || '"' ||
            ',"instance_name":"'     || instance_name    || '"' ||
            ',"db_name":"'           || nvl(name,'N/A')             || '"' ||
            ',"db_domain":"'         || nvl(sys_context('USERENV','DB_DOMAIN'),'N/A') || '"' ||
            ',"db_unique_name":"'    || db_unique_name   || '"' ||
            ',"database_role":"'     || database_role    || '"' ||
            ',"fsfo_role":"'||
                case
                    when database_role = 'PRIMARY' then 'PRIMARY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name)  = lower(fs_failover_current_target) then 'STANDBY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name) != lower(fs_failover_current_target) then 'BYSTANDER'
                    else 'NONE'
                end || '"' as metric_dimensions
        from v$database, v$instance
    ),
    max_next AS
      (SELECT /*+ INLINE OPT_PARAM('_px_cdb_view_enabled' 'FALSE') */
        p.pdb_name,t.con_id,
        t.tablespace_name,
        64 Max_next_extent
      FROM cdb_tablespaces t, dba_pdbs p
      WHERE tablespace_name NOT LIKE 'SYS%'
      AND CONTENTS='PERMANENT' and p.con_id=t.con_id
      ),
      Extendable_space AS
      (SELECT
        /*+ OPT_PARAM('_px_cdb_view_enabled' 'FALSE') materialize */
        d.con_id,
        d.tablespace_name,
        SUM(
        CASE
          WHEN AUTOEXTENSIBLE='YES'
            /* Find exact number of next extents that fit by dividing extendable space by max_next */
          THEN TRUNC((maxbytes-bytes)/1024/1024/max_next_extent)*max_next_extent
          ELSE 0
        END) AS Extendable_Space_MB
      FROM cdb_data_files d,
        max_next n
      WHERE d.tablespace_name NOT LIKE 'SYS%'
      AND d.tablespace_name NOT LIKE 'UNDO%'
      AND d.tablespace_name=n.tablespace_name
      AND d.con_id         =n.con_id
      GROUP BY d.tablespace_name,
        d.con_id
      ) ,
      free_space AS
      (SELECT
        /*+ materialize */
        con_id,
        tablespace_name,
        MAX(MB) MAX_CONTIGUOUS_MB,
        SUM(MB) SUM_ELIGIBLE_MB,
        SUM(TRUNC(MB/Max_next_extent)) COUNT_ELIGIBLE_EXTENTS
      FROM
        (SELECT /*+ INLINE OPT_PARAM('_px_cdb_view_enabled' 'FALSE') */
          d.con_id,
          d.tablespace_name,
          BYTES    /1024/1024 MB,
          MAX(BYTES/1024/1024) over (partition BY d.tablespace_name) AS max_MB,
          e.Max_next_extent
        FROM cdb_free_space d,
          max_next e
        WHERE d.tablespace_name NOT LIKE 'SYS%'
        AND d.tablespace_name NOT LIKE 'UNDO%'
        AND d.tablespace_name=e.tablespace_name
        AND d.con_id=e.con_id
          --AND d.bytes/1024/1024>e.Max_next_extent
        )
      GROUP BY tablespace_name,
        con_id
      ),
    v$metric_history as (SELECT c.pdb_name,
      a.tablespace_name,
      NVL(a.Extendable_space_mb,0) AUTOEXTENDABLE_FREE_SPACE_MB ,
      NVL(b.max_contiguous_mb,0) MAX_CONTIGUOUS_FREE_SPACE_MB ,
      c.max_next_extent MAX_NEXT_MB,
      NVL(a.Extendable_space_mb,0) + NVL(SUM_ELIGIBLE_MB,0) AS SPACE_AVAILABLE_MB ,
      NVL(COUNT_ELIGIBLE_EXTENTS,0) CNT_ELGBL_EXTS_IN_ALLOC_SPACE,
      floor((NVL(Extendable_space_mb,0) / c.max_next_extent ) ) + NVL(COUNT_ELIGIBLE_EXTENTS,0) count_possible_64m_extents,
      CASE
        WHEN (floor((NVL(Extendable_space_mb,0) / c.max_next_extent ) ) + NVL(COUNT_ELIGIBLE_EXTENTS,0) )< 6
        AND database_role                                                                                ='PRIMARY'
        THEN 'CRITICAL'
        WHEN (floor((NVL(Extendable_space_mb,0) / c.max_next_extent ) ) + NVL(COUNT_ELIGIBLE_EXTENTS,0) )< 12
        AND database_role                                                                                ='PRIMARY'
        THEN 'WARNING'
        ELSE 'OK'
      END AS EXTENT_MONITOR_STATUS
    FROM Extendable_space a
    LEFT OUTER JOIN free_space b
    ON a.tablespace_name=b.tablespace_name
    AND a.con_id        =b.con_id
    JOIN max_next c
    ON a.tablespace_name=c.tablespace_name
    AND a.con_id        =c.con_id
    JOIN v$database
    ON 1        =1
  ),
    v$metric as (
        select
            'ExtentMonitor' as metric_name
            ,',"pdb_name":"'            || nvl(to_char(pdb_name           ),'null')  || '"' ||
             ',"tablespace_name":"'               || nvl(to_char(tablespace_name     ),'null')  || '"' ||
             ',"AUTOEXTENDABLE_FREE_SPACE_MB":"'               ||AUTOEXTENDABLE_FREE_SPACE_MB|| '"' ||
             ',"MAX_CONTIGUOUS_FREE_SPACE_MB":"'               ||MAX_CONTIGUOUS_FREE_SPACE_MB|| '"' ||
             ',"MAX_NEXT_MB":"'               ||MAX_NEXT_MB|| '"' ||
             ',"SPACE_AVAILABLE_MB":"'               ||SPACE_AVAILABLE_MB|| '"' ||
             ',"CNT_ELGBL_EXTS_IN_ALLOC_SPACE":"'               ||CNT_ELGBL_EXTS_IN_ALLOC_SPACE|| '"' ||
             ',"count_possible_64m_extents":"'               ||count_possible_64m_extents|| '"' ||
             ',"EXTENT_MONITOR_STATUS":"'      || nvl(to_char(EXTENT_MONITOR_STATUS     ),'null')  || '"' as metric_dimensions
            ,1 as metric_value
        from
            v$metric_history
    )
select
    v$metricname.project                        as project
    ,v$metricname.fleet                         as fleet
    ,v$metricname.host                          as host
    ,v$metric.metric_name                       as metric_name
    ,v$metric.metric_value                      as metric_value
    ,'{'||v$metricname.metric_dimensions||v$metric.metric_dimensions||'}' as metric_dimensions
from v$metricname,v$metric
