/* iod-telemetry Datafile.sql version 2022.04.11.1 jialzhan */
with
    v$metricname as (
        /* version 3 */
        select
            ''              as project
            ,'oracle_db'    as fleet
            ,host_name      as host
            ,'"lifecycle":"'||
                case
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name not like '%.r1') or
                        regexp_like(host_name,'(dev|sandbox)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(dev|sand)')
                        then 'DEV'
                    when
                        (regexp_like(instance_name,'(9[0-9])') and host_name like '%.r1%') or
                        regexp_like(host_name,'(test|tst)') or
                        regexp_like(lower(sys_context('USERENV','DB_DOMAIN')),'(test|tst)')
                        then 'TEST'
                    else 'PROD'
                end || '"' ||
            ',"hostclass":"'|| nvl(regexp_substr(host_name,'^([^.]*)-',1,1,NULL,1),'N/A') || '"' ||
            ',"instance_name":"'     || instance_name    || '"' ||
            ',"db_name":"'           || nvl(name,'N/A')             || '"' ||
            ',"db_domain":"'         || nvl(sys_context('USERENV','DB_DOMAIN'),'N/A') || '"' ||
            ',"db_unique_name":"'    || db_unique_name   || '"' ||
            ',"database_role":"'     || database_role    || '"' ||
            ',"fsfo_role":"'||
                case
                    when database_role = 'PRIMARY' then 'PRIMARY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name)  = lower(fs_failover_current_target) then 'STANDBY'
                    when database_role = 'PHYSICAL STANDBY' and lower(db_unique_name) != lower(fs_failover_current_target) then 'BYSTANDER'
                    else 'NONE'
                end || '"' as metric_dimensions
        from v$database, v$instance
    ),
    v$metric_history as (
        SELECT 
            dbf.datafile_cnt, 
            p.datafile_limit,
            round (dbf.datafile_cnt/p.datafile_limit * 100) datafile_used_pct, 
            dbf.max_datafile_gb
        FROM (select count(1) datafile_cnt, round(max(bytes/1024/1024/1024)) max_datafile_gb from v$datafile) dbf, (select to_number(value) datafile_limit from v$parameter where name = 'db_files') p
    ),
    v$metric as (
        select 
            'Datafile.' || metric_name as  metric_name
            ,', null' || '"' as metric_dimensions
            ,metric_value as metric_value
        from ( 
            select
                datafile_cnt        as "DatafileCount"
               ,datafile_limit      as "DatafileLimit"
               ,datafile_used_pct   as "DatafileUsedPct"
               ,max_datafile_gb     as "MaxDatafileGB"
            from v$metric_history
         ) unpivot (
            metric_value for metric_name in (
                "DatafileCount"
                ,"DatafileLimit"
                ,"DatafileUsedPct"
                ,"MaxDatafileGB"
            )
        )
   )
select 
    v$metricname.project                        as project
    ,v$metricname.fleet                         as fleet
    ,v$metricname.host                          as host
    ,v$metric.metric_name                       as metric_name
    ,v$metric.metric_value                      as metric_value
    ,'{'||v$metricname.metric_dimensions||'}' as metric_dimensions
from v$metricname,v$metric
