/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.stage;

import java.nio.file.Path;
import java.util.HashMap;
import oracle.dbtools.extension.project.commands.stage.utils.StageConstants;
import oracle.dbtools.extension.project.commands.stage.utils.StageUtils;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;

public class StageInRelease
implements VerifyServiceInterface {
    Path codeClog;
    Path stageClog;
    String releaseCl;

    @Override
    public String getName() {
        return "StageInRelease";
    }

    @Override
    public String getGroup() {
        return "Stage";
    }

    @Override
    public boolean doTest(HashMap<String, Object> params) {
        try {
            StageUtils tu = new StageUtils(ProjectConfig.getCurrentWorkingProjectRoot(), ProjectConfig.getCurrentContext());
            boolean ret = true;
            this.stageClog = tu.getStageChangeLog();
            if (StageConstants.isReleaseIsolation()) {
                this.codeClog = tu.getNextCodeChangeLog();
            }
            this.releaseCl = tu.getRelCLog();
            if (this.releaseCl.contains(this.stageClog.getFileName().toString())) {
                if (StageConstants.isReleaseIsolation() && !this.releaseCl.contains(this.codeClog.getFileName().toString())) {
                    this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, "The softObject changelog was not found in the release changelog.");
                    ret = false;
                }
            } else {
                this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, "The stage changelog was not found in the release changelog.");
                ret = false;
            }
            return ret;
        }
        catch (Exception e) {
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, e.getMessage(), "exception", e);
            return false;
        }
    }
}

