/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.verify.services.stage;

import java.io.File;
import java.util.Collection;
import java.util.regex.Pattern;
import oracle.dbtools.extension.project.core.verify.interfaces.VerifyServiceInterface;
import org.apache.commons.io.FileUtils;

abstract class CommonStageProcess
implements VerifyServiceInterface {
    Pattern apex_yaml_pattern = Pattern.compile(".*\\/apex_apps\\/.*\\/readable");
    String[] fileTypes = new String[]{"sql", "pks", "pkb", "pls"};
    String codeCl;
    String stageCl;

    CommonStageProcess() {
    }

    boolean processFiles(Collection<File> files) {
        boolean error = false;
        for (File file : files) {
            if (file.isDirectory()) {
                error = this.processFiles(FileUtils.listFiles((File)file, (String[])this.fileTypes, (boolean)true));
                continue;
            }
            if (this.apex_yaml_pattern.matcher(file.getParent()).find()) {
                this.addMessage(VerifyServiceInterface.MessageLevel.HIDDEN, "SKIPPING_FILE", "file", file);
                continue;
            }
            if (this.stageCl.contains(file.getName()) || this.codeCl.contains(file.getName())) continue;
            this.addMessage(VerifyServiceInterface.MessageLevel.ERROR, "File not found in any changelog", "file", file);
        }
        if (!error) {
            this.addMessage(VerifyServiceInterface.MessageLevel.INFO, "Stage Changelog validation found no issues.");
        }
        return error;
    }
}

