/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import lombok.NonNull;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.utils.ProjectUtils;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

public class FileCompressionUtils {
    public static void compressList(@NonNull List<Path> paths, @NonNull Path output) throws IOException {
        if (paths == null) {
            throw new NullPointerException("paths is marked non-null but is null");
        }
        if (output == null) {
            throw new NullPointerException("output is marked non-null but is null");
        }
        try (OutputStream fOut = Files.newOutputStream(output, new OpenOption[0]);
             BufferedOutputStream buffOut = new BufferedOutputStream(fOut);
             GzipCompressorOutputStream gzOut = new GzipCompressorOutputStream((OutputStream)buffOut);
             TarArchiveOutputStream tOut = new TarArchiveOutputStream((OutputStream)gzOut);){
            tOut.setLongFileMode(3);
            for (Path path : paths) {
                if (!Files.isRegularFile(path, new LinkOption[0])) {
                    throw new IOException("Support only file!");
                }
                TarArchiveEntry tarEntry = new TarArchiveEntry(path.toFile(), path.getFileName().toString());
                tOut.putArchiveEntry(tarEntry);
                Files.copy(path, (OutputStream)tOut);
                tOut.closeArchiveEntry();
            }
            tOut.finish();
        }
    }

    public static void compressFolder(@NonNull Path source, String outFileName, String format) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        FileCompressionUtils.compressFolder(source, null, outFileName, format);
    }

    public static void compressFolder(final Path source, Path outDestination, String outFileName, final String format) throws IOException {
        if (!Files.isDirectory(source, new LinkOption[0])) {
            throw new IOException("Please provide a directory.");
        }
        if (!Files.isDirectory(outDestination, new LinkOption[0])) {
            new File(outDestination.toString()).mkdir();
        }
        String ext = "";
        switch (format.toLowerCase()) {
            case "zip": {
                ext = ".zip";
                break;
            }
            default: {
                ext = ".tgz";
            }
        }
        String tarFileName = outFileName == null ? source.getFileName().toString() + ext : ProjectUtils.removeIllegalCharacters(outFileName, true, true) + ext;
        Path compressDest = outDestination == null || !Files.isDirectory(outDestination, new LinkOption[0]) ? Paths.get(source.toString(), tarFileName) : Paths.get(outDestination.toString(), tarFileName);
        try (OutputStream fOut = Files.newOutputStream(compressDest, new OpenOption[0]);
             BufferedOutputStream buffOut = new BufferedOutputStream(fOut);
             ZipArchiveOutputStream aOut = format.equalsIgnoreCase("zip") ? new ZipArchiveOutputStream((OutputStream)buffOut) : new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)buffOut));){
            if ("zip".equalsIgnoreCase(format)) {
                aOut.setMethod(8);
                aOut.setLevel(9);
            } else {
                ((TarArchiveOutputStream)aOut).setLongFileMode(3);
            }
            Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>((ArchiveOutputStream)aOut){
                final /* synthetic */ ArchiveOutputStream val$aOut;
                {
                    this.val$aOut = archiveOutputStream;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                    if (attributes.isSymbolicLink() || file.endsWith(".tar.gz") || file.endsWith(".zip")) {
                        return FileVisitResult.CONTINUE;
                    }
                    Path targetFile = source.relativize(file);
                    try {
                        ZipArchiveEntry entry = format.equalsIgnoreCase("zip") ? new ZipArchiveEntry(file.toFile(), targetFile.toString()) : new TarArchiveEntry(file.toFile(), targetFile.toString());
                        this.val$aOut.putArchiveEntry((ArchiveEntry)entry);
                        Files.copy(file, (OutputStream)this.val$aOut);
                        this.val$aOut.closeArchiveEntry();
                        GeneralMessages.verboseMessage("file : " + String.valueOf(file));
                    }
                    catch (IOException e) {
                        GeneralMessages.errorMessage("Unable to " + format + " " + String.valueOf(file) + "\n" + String.valueOf(e));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    GeneralMessages.errorMessage("Unable to " + format + " " + String.valueOf(file) + "\n" + String.valueOf(exc));
                    return FileVisitResult.CONTINUE;
                }
            });
            if ("zip".equalsIgnoreCase(format)) {
                aOut.finish();
            } else {
                ((TarArchiveOutputStream)aOut).finish();
            }
        }
    }

    public static void decompressFile(@NonNull Path source, @NonNull Path target) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (Files.notExists(source, new LinkOption[0])) {
            throw new IOException("File doesn't exists!");
        }
        try (InputStream fi = Files.newInputStream(source, new OpenOption[0]);
             BufferedInputStream bi = new BufferedInputStream(fi);
             ZipArchiveInputStream ai = FileCompressionUtils.nameExtensionEquals(source, "zip") ? new ZipArchiveInputStream((InputStream)bi) : new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)bi));){
            ArchiveEntry entry;
            while ((entry = ai.getNextEntry()) != null) {
                Path newPath = FileCompressionUtils.zipSlipCheck(entry, target);
                if (entry.isDirectory()) {
                    Files.createDirectories(newPath, new FileAttribute[0]);
                    continue;
                }
                Path parent = newPath.getParent();
                if (parent != null && !Files.exists(parent, new LinkOption[0])) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                Files.copy((InputStream)ai, newPath, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    public static boolean nameExtensionEquals(@NonNull Path path, String ... extensions) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        String fileName = path.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex > 0) {
            String extension = fileName.substring(dotIndex + 1);
            for (String ext : extensions) {
                if (!extension.equalsIgnoreCase(ext)) continue;
                return true;
            }
        }
        return false;
    }

    @NonNull
    private static Path zipSlipCheck(@NonNull ArchiveEntry entry, @NonNull Path targetDir) throws IOException {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        if (targetDir == null) {
            throw new NullPointerException("targetDir is marked non-null but is null");
        }
        Path targetDirResolved = targetDir.resolve(entry.getName());
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir)) {
            throw new IOException("Bad entry: " + entry.getName());
        }
        return normalizePath;
    }
}

