/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.core.diff;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.arbori.util.IO;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;

public class TableInfo {
    Parsed target;
    String tableName;
    List<String> pkColumns = new LinkedList<String>();
    String pkState = "";
    List<ParseNode> columnDefinitions = new LinkedList<ParseNode>();
    List<ParseNode> inlineNamedConstraints = new LinkedList<ParseNode>();
    List<ParseNode> outOfLineNamedConstraints = new LinkedList<ParseNode>();

    public TableInfo(Parsed parsed) throws Exception {
        this.target = parsed;
        String prg = IO.readFile(TableInfo.class, (String)"tableDiff.arbori");
        SqlProgram program = new SqlProgram(prg);
        program.eval(this.target, new Object(){

            public void columns(Parsed target, Map<String, ParseNode> tuple) {
                ParseNode def = tuple.get("def");
                TableInfo.this.columnDefinitions.add(def);
            }

            public void table(Parsed target, Map<String, ParseNode> tuple) {
                TableInfo.this.tableName = target.content(tuple.get("from"), tuple.get("to"));
            }

            public void notInlinedPkColumns(Parsed target, Map<String, ParseNode> tuple) {
                TableInfo.this.pkColumns.add(target.content(tuple.get("id")));
            }

            public void inlineNamedConstraints(Parsed target, Map<String, ParseNode> tuple) {
                ParseNode constraint = tuple.get("constraint");
                TableInfo.this.inlineNamedConstraints.add(constraint);
            }

            public void outOfLineNamedConstraints(Parsed target, Map<String, ParseNode> tuple) {
                ParseNode constraint = tuple.get("constraint");
                TableInfo.this.outOfLineNamedConstraints.add(constraint);
            }

            public void pkState(Parsed target, Map<String, ParseNode> tuple) {
                TableInfo.this.pkState = target.content(tuple.get("node"));
            }
        });
    }
}

