/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.stage.utils.interfaces;

import java.io.IOException;
import java.sql.Connection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import oracle.dbtools.extension.project.commands.export.DbObj;
import oracle.dbtools.extension.project.core.config.ProjectConfig;

public abstract class AbstractChangeLogSorter {
    private LinkedList<String> startLines = new LinkedList();
    private LinkedList<String> endLines = new LinkedList();
    private List<DbObj> includedLines = new LinkedList<DbObj>();

    protected AbstractChangeLogSorter() {
    }

    protected abstract void buildLists(String var1) throws IOException;

    public String sort(String log, Connection conn) throws Exception {
        this.buildLists(log);
        List<DbObj> sorted = DbObj.order(this.getIncludedLines(), conn);
        return this.buildResultString(sorted);
    }

    private String buildResultString(List<DbObj> sortedMap) {
        StringBuilder debug = new StringBuilder();
        StringBuilder result = new StringBuilder();
        this.appendLines(result, this.getStartLines());
        for (DbObj obj : sortedMap) {
            if (ProjectConfig.isDebug()) {
                debug.append(obj.toString()).append("\n");
            }
            result.append(obj.getLine()).append("\n");
        }
        if (ProjectConfig.isDebug()) {
            ProjectConfig.getCurrentContext().writeln("=============== SORTED OBJECTS =================");
            if (sortedMap.size() < 25) {
                ProjectConfig.getCurrentContext().writeln(debug.toString());
            } else {
                ProjectConfig.getCurrentContext().writeln(debug.toString());
                ProjectConfig.getCurrentContext().writeln("================================================");
            }
        }
        this.appendLines(result, this.getEndLines());
        return result.toString();
    }

    private void appendLines(StringBuilder builder, Iterable<String> lines) {
        for (String line : lines) {
            builder.append(line).append("\n");
        }
    }

    @Generated
    public void setStartLines(LinkedList<String> startLines) {
        this.startLines = startLines;
    }

    @Generated
    public void setEndLines(LinkedList<String> endLines) {
        this.endLines = endLines;
    }

    @Generated
    public void setIncludedLines(List<DbObj> includedLines) {
        this.includedLines = includedLines;
    }

    @Generated
    public LinkedList<String> getStartLines() {
        return this.startLines;
    }

    @Generated
    public LinkedList<String> getEndLines() {
        return this.endLines;
    }

    @Generated
    public List<DbObj> getIncludedLines() {
        return this.includedLines;
    }
}

