/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.stage.generators;

import oracle.dbtools.extension.project.commands.stage.StageMessages;
import oracle.dbtools.extension.project.commands.stage.objectclasses.DbDiffObject;
import oracle.dbtools.extension.project.core.exceptions.MaterializedViewLogException;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import org.apache.commons.lang3.StringUtils;

public class DropDdlGenerator {
    private DropDdlGenerator() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getDrop(DbDiffObject entry) throws MaterializedViewLogException {
        StringBuilder sql = new StringBuilder();
        if ("REF_CONSTRAINT".equalsIgnoreCase(entry.getObjectType())) {
            String dropsql = entry.getMasterFileContent().trim();
            dropsql = dropsql.substring(0, dropsql.indexOf("-- sqlcl_snapshot")).trim();
            dropsql = StringUtils.replaceIgnoreCase((String)dropsql, (String)"add", (String)"drop").trim();
            int loc = StringUtils.indexOfIgnoreCase((CharSequence)dropsql, (CharSequence)"FOREIGN KEY");
            sql.append(dropsql, 0, loc - 1);
        } else if (StringUtils.endsWithIgnoreCase((CharSequence)entry.getObjectType(), (CharSequence)"GRANT")) {
            String dropsql = entry.getMasterFileContent().trim();
            dropsql = dropsql.substring(0, dropsql.indexOf("-- sqlcl_snapshot")).trim();
            dropsql = StringUtils.replaceIgnoreCase((String)dropsql, (String)"grant", (String)"revoke").trim();
            dropsql = StringUtils.replaceIgnoreCase((String)dropsql, (String)"to", (String)"from").trim();
            sql.append(dropsql);
        } else {
            StringBuilder dropStmt = new StringBuilder();
            dropStmt.append("DROP ");
            dropStmt.append(SchemaGenerator.typeNameTransform.getOrDefault(entry.getObjectType(), entry.getObjectType()).trim()).append(" ");
            if ("MATERIALIZED_VIEW_LOG".equals(entry.getObjectType().trim())) {
                dropStmt.append("ON ");
            }
            if (ProjectSettings.getSettingAsBoolean("export.setTransform.emitSchema") != null && ProjectSettings.getSettingAsBoolean("export.setTransform.emitSchema").booleanValue()) {
                dropStmt.append("\"").append(entry.getSchema()).append("\".");
            }
            if ("MATERIALIZED_VIEW_LOG".equals(entry.getObjectType().trim())) {
                if (entry.getMvLogDependentObjects().size() > 1) throw new MaterializedViewLogException(StageMessages.format("MATERIALIZED_VIEWS_LOG_EXCEPTION", new Object[0]));
                String baseObj = entry.getMvLogDependentObjects().get(0);
                dropStmt.append("\"").append(baseObj.toUpperCase()).append("\"");
            } else {
                dropStmt.append("\"").append(entry.getObjectName()).append("\"");
            }
            if ("TABLE".equals(entry.getObjectType())) {
                dropStmt.append(" CASCADE CONSTRAINTS");
            }
            sql.append((CharSequence)dropStmt);
        }
        if (sql.toString().endsWith(";")) return sql.toString().trim();
        sql.append(";");
        return sql.toString().trim();
    }
}

