/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.handler;

import com.google.common.base.Throwables;
import java.sql.Connection;
import oracle.dbtools.extension.project.commands.handler.CommandHandler;
import oracle.dbtools.extension.project.commands.handler.Commands;
import oracle.dbtools.extension.project.commands.handler.ProjectOptions;
import oracle.dbtools.extension.project.commands.handler.ProjectType;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.utils.ProjectUtils;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.command.ParsedCommandListener;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public class ProjectCommand
extends ParsedCommandListener {
    protected boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd, ParsedCommand parsedCommand) {
        block17: {
            Id command = parsedCommand.getType().getId();
            if (parsedCommand.isFlagSet((Id)ProjectOptions.Options.DEBUG)) {
                ProjectUtils.displayArgs(ctx, parsedCommand);
            }
            try {
                ProjectSettings.loadSystemSettings();
                if (command == Commands.INIT) {
                    CommandHandler.InitCommand(conn, ctx, cmd, parsedCommand);
                    return true;
                }
                if (command != Commands.DEPLOY) {
                    ProjectUtils.getProjectRootFolder();
                    ProjectSettings.loadUserSettings();
                }
                ProjectConfig.checkVersion();
                if (command == Commands.EXPORT) {
                    CommandHandler.ExportCommand(conn, ctx, cmd, parsedCommand);
                    break block17;
                }
                if (command == Commands.CONFIG) {
                    CommandHandler.ConfigCommand(conn, ctx, cmd, parsedCommand);
                    break block17;
                }
                if (command == Commands.SET) {
                    CommandHandler.ConfigSetCommand(conn, ctx, cmd, parsedCommand);
                    break block17;
                }
                if (command == Commands.DELETE) {
                    CommandHandler.ConfigDeleteCommand(conn, ctx, cmd, parsedCommand);
                    break block17;
                }
                if (command == Commands.STAGE) {
                    CommandHandler.StageCommand(conn, ctx, cmd, parsedCommand);
                    break block17;
                }
                if (command == Commands.ADD_CUSTOM) {
                    CommandHandler.AddCustomCommand(conn, ctx, cmd, parsedCommand);
                    break block17;
                }
                if (command == Commands.SNAPSHOT) {
                    CommandHandler.VerifySnapShotCommand(conn, ctx, cmd, parsedCommand);
                    break block17;
                }
                if (command == Commands.VERIFY_STAGE) {
                    CommandHandler.VerifyStageCommand(conn, ctx, cmd, parsedCommand);
                    break block17;
                }
                if (command == Commands.VERIFY) {
                    CommandHandler.VerifyCommand(conn, ctx, cmd, parsedCommand);
                    break block17;
                }
                if (command == Commands.RELEASE) {
                    CommandHandler.ReleaseCommand(conn, ctx, cmd, parsedCommand);
                    break block17;
                }
                if (command == Commands.DEPLOY) {
                    CommandHandler.DeployCommand(conn, ctx, cmd, parsedCommand);
                    break block17;
                }
                if (command == Commands.GEN_ARTIFACT) {
                    CommandHandler.GenArtifactCommand(conn, ctx, cmd, parsedCommand);
                    break block17;
                }
                return false;
            }
            catch (Exception e) {
                ctx.writeln(e.getMessage());
                GeneralMessages.debugMessage(Throwables.getStackTraceAsString((Throwable)e));
            }
        }
        ctx.putProperty("STATUSBARSTATUS", (Object)"Idle");
        return true;
    }

    protected Type createType() {
        return ProjectType.commandType();
    }
}

