/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.export;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import oracle.arbori.util.Service;
import oracle.dbtools.extension.project.commands.export.DbObj;
import oracle.dbtools.extension.project.commands.export.DbmsMetadata;
import oracle.dbtools.extension.project.commands.export.Export;
import oracle.dbtools.extension.project.commands.export.ExportMessages;
import oracle.dbtools.extension.project.commands.export.TransitiveClosure;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.utils.ConsoleColors;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.util.SpinningWheel;
import oracle.jdbc.OracleDatabaseException;

public class Report {
    Map<String, Integer> typeCounts = new ConcurrentHashMap<String, Integer>();
    Map<DbObj, String> errors = new ConcurrentHashMap<DbObj, String>();
    long formatTiming = 0L;
    long startTime = System.currentTimeMillis();
    Export export;
    TransitiveClosure order;
    HashSet<String> files = new HashSet();
    Set<DbObj> invalid = new TreeSet<DbObj>();

    public Report(Export export) {
        this.export = export;
    }

    static void rewriteln(ScriptRunnerContext ctx, String msg) {
        if (ProjectConfig.isVerbose()) {
            Report.writeln(ctx, msg);
        } else {
            PrintWriter p = Report.cleanSpinningWheel(ctx);
            p.print("\r" + msg + "                 ");
            p.flush();
        }
    }

    static void writeln(ScriptRunnerContext ctx, String msg) {
        PrintWriter p = Report.cleanSpinningWheel(ctx);
        p.println(msg);
        p.flush();
    }

    static void write(ScriptRunnerContext ctx, String msg) {
        PrintWriter p = Report.cleanSpinningWheel(ctx);
        p.print(msg);
        p.flush();
    }

    static void warning(ScriptRunnerContext ctx, Throwable e) {
        Report.writeln(ctx, ConsoleColors.YELLOW.code + e.getMessage() + ConsoleColors.RESET.code);
        Report.debug(ctx, e);
    }

    static void error(ScriptRunnerContext ctx, String msg) {
        Report.writeln(ctx, ConsoleColors.RED.code + msg + ConsoleColors.RESET.code);
        if (ProjectConfig.isDebug()) {
            Report.writeln(ctx, ConsoleColors.BLUE.code);
            Thread.dumpStack();
            Report.writeln(ctx, ConsoleColors.RESET.code);
        }
    }

    static void error(ScriptRunnerContext ctx, Throwable t, String addendum) {
        Report.writeln(ctx, ConsoleColors.RED.code + t.getMessage() + " " + addendum + ConsoleColors.RESET.code);
        Report.debug(ctx, t);
    }

    static void error(ScriptRunnerContext ctx, String addendum, Throwable t) {
        Report.writeln(ctx, ConsoleColors.RED.code + addendum + " " + t.getMessage() + ConsoleColors.RESET.code);
        Report.debug(ctx, t);
    }

    static void error(ScriptRunnerContext ctx, String otype, String oname, Throwable e) {
        if (otype == null) {
            otype = "null";
        }
        if (oname == null) {
            oname = "null";
        }
        Report.writeln(ctx, ConsoleColors.RED.code + otype + ":" + oname + " " + e.getMessage() + ConsoleColors.RESET.code);
        Report.debug(ctx, e);
    }

    static void verbose(ScriptRunnerContext ctx, String msg) {
        if (ProjectConfig.isVerbose()) {
            Report.writeln(ctx, ConsoleColors.WHITE.code + msg + ConsoleColors.RESET.code);
        }
    }

    static void debug(ScriptRunnerContext ctx, String msg) {
        if (ProjectConfig.isDebug()) {
            Report.writeln(ctx, ConsoleColors.BLUE.code + msg + ConsoleColors.RESET.code);
        }
    }

    static void debug(ScriptRunnerContext ctx, Throwable e) {
        if (ProjectConfig.isDebug()) {
            Report.writeln(ctx, ConsoleColors.BLUE.code);
            e.printStackTrace();
            Report.writeln(ctx, ConsoleColors.RESET.code);
        }
    }

    static void noVerboseDebugSpinningWheel(ScriptRunnerContext ctx) {
        if (ProjectConfig.isDebug()) {
            return;
        }
        if (ProjectConfig.isVerbose()) {
            return;
        }
        SpinningWheel.start((ScriptRunnerContext)ctx);
    }

    private static PrintWriter cleanSpinningWheel(ScriptRunnerContext ctx) {
        WrapListenBufferOutputStream wrapBos = ctx.getOutputStream();
        SpinningWheel.stop();
        return new PrintWriter((OutputStream)wrapBos);
    }

    static void warning(ScriptRunnerContext ctx, String msg) {
        Report.writeln(ctx, ConsoleColors.YELLOW.code + msg + ConsoleColors.RESET.code);
    }

    static void processException(ScriptRunnerContext ctx, Throwable t, String otype, String oname) {
        Throwable cause;
        if (t instanceof SQLException && (cause = t.getCause()) instanceof OracleDatabaseException) {
            OracleDatabaseException ode = (OracleDatabaseException)cause;
            Report.error(ctx, "*** Failed to run " + ode.getSql());
            String msg = ode.getMessage();
            int nlPos = msg.indexOf("\n");
            if (0 < nlPos) {
                msg = msg.substring(0, nlPos);
            }
            Report.error(ctx, "*** " + msg);
            Report.error(ctx, msg);
            return;
        }
        Report.error(ctx, otype, oname, t);
    }

    void incrTypeCnt(String type) {
        Integer tmp = this.typeCounts.get(type);
        if (tmp == null) {
            tmp = 0;
        }
        this.typeCounts.put(type, tmp + 1);
    }

    void decrTypeCnt(String type) {
        Integer tmp = this.typeCounts.get(type);
        if (tmp == null) {
            tmp = 1;
        }
        this.typeCounts.put(type, tmp - 1);
    }

    void addFailedFormat(DbObj dbObj, String msg) {
        this.errors.put(dbObj, msg);
    }

    void summary() {
        int total = 0;
        ScriptRunnerContext ctx = this.export.ctx;
        int width = 60;
        if (0 < this.errors.size()) {
            String errorsHdr = "Errors:";
            if (!ProjectConfig.isDebug()) {
                errorsHdr = "Errors by the object type:\n(run with -debug to get the full list)";
            }
            Report.warning(ctx, errorsHdr);
            Report.warning(ctx, "=".repeat(60));
        }
        HashSet<DbObj> retry = new HashSet<DbObj>();
        HashSet<String> types = new HashSet<String>();
        for (DbObj o : this.errors.keySet()) {
            String msg = this.errors.get(o);
            if (msg.contains("ORA-31600")) {
                retry.add(o);
            }
            String type = o.type;
            String space = ": ";
            if (!types.contains(type) || ProjectConfig.isDebug()) {
                Object name = String.valueOf(o) + space;
                if (msg.contains(o.name) || msg.contains(o.type)) {
                    name = "";
                }
                Report.warning(ctx, Service.padln((String)name, (int)(60 - msg.length())) + (String)msg);
            }
            types.add(type);
        }
        if (0 < this.errors.size()) {
            Report.warning(ctx, "=".repeat(60));
        }
        int pad = 30;
        int max = 1;
        for (String type : this.typeCounts.keySet()) {
            int len = this.typeCounts.get(type).toString().length();
            if (max >= len) continue;
            max = len;
        }
        String dashPad = "-".repeat(pad + max);
        Report.writeln(ctx, ConsoleColors.GREEN.code + dashPad);
        TreeMap<String, Integer> orderedCounts = new TreeMap<String, Integer>(this.typeCounts);
        for (String type : orderedCounts.keySet()) {
            Integer cnt = (Integer)orderedCounts.get(type);
            int len = cnt.toString().length();
            if ("OBJECT_GRANT".equals(type)) continue;
            total += cnt.intValue();
            Report.writeln(ctx, Service.padln((String)type, (int)(pad + max - len)) + cnt);
        }
        Report.writeln(ctx, dashPad + ConsoleColors.RESET.code);
        String exportedMsg = ExportMessages.getString("EXPORTED_N_OBJECTS");
        if (this.export.listOnly) {
            exportedMsg = ExportMessages.getString("LISTED_N_OBJECTS");
        }
        Report.writeln(ctx, MessageFormat.format(exportedMsg, total));
        Report.writeln(ctx, MessageFormat.format(ExportMessages.getString("EXPORT_ELAPSED"), (System.currentTimeMillis() - this.startTime) / 1000L));
        Report.debug(ctx, "DBMS_METADATA = " + DbmsMetadata.dbmsMetadataTiming / 1000L + "s");
        Report.debug(ctx, "PL/SQL        = " + DbmsMetadata.plsTiming / 1000L + "s");
        Report.debug(ctx, "Format        = " + this.formatTiming / 1000L + "s");
        if (0 < retry.size()) {
            Report.writeln(ctx, ConsoleColors.GREEN_UNDERLINED.code + "Retry export of the failed objects:" + ConsoleColors.RESET.code);
            Object objects = "";
            for (DbObj o : retry) {
                objects = (String)objects + o.owner + "." + o.name + ",";
            }
            Report.writeln(ctx, ConsoleColors.GREEN_BOLD.code + "project export -o " + ((String)objects).substring(0, ((String)objects).length() - 1) + ConsoleColors.RESET.code);
        }
    }
}

