/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.export;

import java.util.List;
import oracle.arbori.util.CharOffsets;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;

public class Ords {
    private static final String P_SCHEMA = "p_schema              => '";

    private static String removeVolatileComments(String ords) {
        int p3;
        Object ret = ords;
        int[] lineMap = CharOffsets.lineMap((String)ords);
        int p1 = CharOffsets.lineNo2CharPos0((int[])lineMap, (int)1);
        int p2 = CharOffsets.lineNo2CharPos0((int[])lineMap, (int)2);
        if (ords.substring(p2, p3 = CharOffsets.lineNo2CharPos0((int[])lineMap, (int)3)).startsWith("-- Schema:")) {
            ret = ((String)ret).substring(0, p2) + ((String)ret).substring(p3);
        }
        if (ords.substring(p1, p2).startsWith("-- Generated by ORDS REST Data Services")) {
            ret = ((String)ret).substring(0, p1) + ((String)ret).substring(p2);
        }
        return ret;
    }

    static String postprocess(String ords) {
        String ret = Ords.removeVolatileComments(ords);
        List<String> configSchemas = ProjectSettings.getSettingAsList("schemas");
        if (configSchemas.size() < 2) {
            return ret;
        }
        ret = ret.replaceAll("ORDS\\.ENABLE_SCHEMA", "ORDS_ADMIN.ENABLE_SCHEMA");
        ret = ret.replaceAll("ORDS\\.DEFINE_MODULE", "ORDS_ADMIN.DEFINE_MODULE");
        ret = ret.replaceAll("ORDS\\.DEFINE_TEMPLATE", "ORDS_ADMIN.DEFINE_TEMPLATE");
        ret = ret.replaceAll("ORDS\\.DEFINE_HANDLER", "ORDS_ADMIN.DEFINE_HANDLER");
        ret = ret.replaceAll("ORDS\\.DEFINE_PARAMETER", "ORDS_ADMIN.DEFINE_PARAMETER");
        ret = ret.replaceAll("ORDS\\.DEFINE_PRIVILEGE", "ORDS_ADMIN.DEFINE_PRIVILEGE");
        ret = ret.replaceAll("ORDS\\.CREATE_ROLE", "ORDS_ADMIN.CREATE_ROLE");
        int begin = ret.indexOf(P_SCHEMA) + P_SCHEMA.length();
        int end = ret.indexOf("'", begin);
        String schema = ret.substring(begin, end);
        ret = ret.replaceAll("(ORDS_ADMIN\\.(DEFINE_MODULE|DEFINE_TEMPLATE|DEFINE_HANDLER|DEFINE_PARAMETER|DEFINE_PRIVILEGE|CREATE_ROLE))\\(", "$1(\n      p_schema         => '" + schema + "',");
        return ret;
    }
}

