/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.export;

import java.util.List;
import java.util.Map;

public class JSON {
    public static String serialize(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof String) {
            return "\"" + JSON.escapeString((String)obj) + "\"";
        }
        if (obj instanceof Number || obj instanceof Boolean) {
            return obj.toString();
        }
        if (obj instanceof Map) {
            return JSON.serializeMap((Map)obj);
        }
        if (obj instanceof List) {
            return JSON.serializeList((List)obj);
        }
        throw new IllegalArgumentException("Unsupported object type: " + obj.getClass().getName());
    }

    private static String serializeMap(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean first = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!first) {
                sb.append(",");
            }
            sb.append("\"").append(JSON.escapeString(entry.getKey())).append("\":");
            sb.append(JSON.serialize(entry.getValue()));
            first = false;
        }
        sb.append("}");
        return sb.toString();
    }

    private static String serializeList(List<Object> list) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (Object obj : list) {
            if (!first) {
                sb.append(",");
            }
            sb.append(JSON.serialize(obj));
            first = false;
        }
        sb.append("]");
        return sb.toString();
    }

    public static String escapeString(String s) {
        StringBuilder sb = new StringBuilder();
        block9: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c > '\u007f') {
                        sb.append("\\u").append(String.format("%04x", c));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

