/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.export;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.arbori.util.DictionaryViews;
import oracle.arbori.util.Pair;
import oracle.dbtools.arbori.ScriptException;
import oracle.dbtools.arbori.SqlProgram;
import oracle.dbtools.extension.apex.core.APEXExport;
import oracle.dbtools.extension.project.commands.export.ApexExportWrapper;
import oracle.dbtools.extension.project.commands.export.DbObj;
import oracle.dbtools.extension.project.commands.export.Export;
import oracle.dbtools.extension.project.commands.export.Report;
import oracle.dbtools.extension.project.commands.stage.transforms.ObjectTypes;
import oracle.dbtools.extension.project.core.messages.GeneralMessages;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.parser.Substitutions;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.ParsedSql;
import oracle.dbtools.parser.plsql.SyntaxError;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class DbmsMetadata {
    static final String EXPORT_SET_TRANSFORM_EMIT_SCHEMA = "export.setTransform.emitSchema";
    static final String SRC_DATABASE = "/src/database";
    static int cnt = 0;
    static long dbmsMetadataTiming = 0L;
    static long plsTiming = 0L;
    private final DictionaryViews dictViews;
    public boolean quit = false;
    public boolean finished = false;
    ScriptRunnerContext ctx;
    int instance;
    Thread metadataThread;
    Export export;
    private Connection conn;
    private String owner = null;
    private String type = null;
    private String name = null;
    private String fileName = null;

    public DbmsMetadata(Export export) throws SQLException {
        this.dictViews = export.dictViews;
        this.ctx = export.ctx;
        try {
            this.conn = this.ctx.cloneCLIConnection();
        }
        catch (SQLException e) {
            this.conn = this.ctx.getCurrentConnection();
        }
        this.export = export;
        HashMap<String, Object> dbmsMetadataParameters = new HashMap<String, Object>();
        Map<String, Object> configs = ProjectSettings.getConfigSubMap("export.setTransform");
        for (String string : configs.keySet()) {
            int dotPos = string.lastIndexOf(46);
            dbmsMetadataParameters.put(ProjectSettings.toKabobCase(string.substring(dotPos + 1)), configs.get(string));
        }
        dbmsMetadataParameters.put("ref_constraints", false);
        dbmsMetadataParameters.put("insert", false);
        Object transform = "begin\n";
        for (String param : dbmsMetadataParameters.keySet()) {
            Object object = dbmsMetadataParameters.get(param);
            if (object instanceof String) {
                object = "'" + String.valueOf(object) + "'";
            }
            transform = (String)transform + " DBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM,'" + param.toUpperCase() + "'," + String.valueOf(object) + "); \n     ";
        }
        transform = (String)transform + "end;";
        try (Statement statement = this.conn.createStatement();){
            statement.execute((String)transform);
        }
        this.init();
    }

    public static String generateHash(String ddl) throws NoSuchAlgorithmException {
        Object normalized = ddl;
        if (ddl.length() < 1000000) {
            normalized = "";
            List src = Lexer.parse((String)ddl, (boolean)true);
            for (LexerToken t : src) {
                if (t.type == Token.WS) continue;
                normalized = (String)normalized + " " + t.content;
            }
        }
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] hash = md.digest(((String)normalized).getBytes());
        Object hashString = "";
        for (int i = 0; i < hash.length; ++i) {
            hashString = (String)hashString + Integer.toString((hash[i] & 0xFF) + 256, 16).substring(1);
        }
        return hashString;
    }

    public static String appendSxmlAndHash(String owner, String objectType, String objectName, String ddl, String sxml) throws NoSuchAlgorithmException {
        if (sxml == null) {
            sxml = "";
        }
        String hashString = DbmsMetadata.generateHash((String)ddl);
        ddl = (String)ddl + "\n\n\n";
        ddl = (String)ddl + "-- sqlcl_snapshot {";
        ddl = (String)ddl + "\"hash\":\"" + hashString + "\",\"type\":\"" + objectType + "\",\"name\":\"" + objectName + "\",\"schemaName\":\"" + owner + "\"";
        if (sxml != null) {
            ddl = (String)ddl + ",\"sxml\":\"";
            ddl = (String)ddl + sxml;
            ddl = (String)ddl + "\"";
        }
        ddl = (String)ddl + "}";
        return ddl;
    }

    static void saveObjects(Map<String, String> object2ddl, String type, Export export) throws IOException {
        for (String qualifiedName : object2ddl.keySet()) {
            List src = Lexer.parse((String)qualifiedName);
            String owner = ((LexerToken)src.get((int)0)).content.toLowerCase();
            String name = ((LexerToken)src.get((int)2)).content.toLowerCase();
            String ddl = object2ddl.get(qualifiedName);
            try {
                long t11 = System.currentTimeMillis();
                ddl = Export.format(ddl);
                export.report.formatTiming += System.currentTimeMillis() - t11;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ddl = DbmsMetadata.appendSxmlAndHash(owner, type, name, ddl, null);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            DbmsMetadata.saveDbObject(export, owner, type, name, ddl);
        }
    }

    static void saveDbObject(Export export, String owner, String objectType, String fileName, String ddl) throws IOException {
        File f;
        if ("REF_CONSTRAINT".equals(objectType)) {
            String pattern = ",\"name\":\"";
            int begin = ((String)ddl).indexOf(",\"name\":\"") + ",\"name\":\"".length();
            int end = ((String)ddl).indexOf(34, begin);
            ddl = ((String)ddl).substring(0, begin) + fileName.toUpperCase() + ((String)ddl).substring(end);
        }
        Object path = DbmsMetadata.makeSrcDatabaseOwnerDir(export, owner);
        if (objectType != null && !(f = new File((String)(path = (String)path + File.separator + ObjectTypes.plural(objectType).toLowerCase()))).exists()) {
            f.mkdirs();
        }
        String ext = DbmsMetadata.fileExtension(objectType);
        f = DbmsMetadata.createFileWDir((String)path, fileName, ext);
        f.createNewFile();
        int pos = ((String)path).indexOf(SRC_DATABASE) + SRC_DATABASE.length();
        String relativeFileName = f.getAbsolutePath().substring(pos);
        if (relativeFileName.startsWith("/")) {
            relativeFileName.substring(1);
        }
        export.report.files.add(relativeFileName);
        FileWriter fw = new FileWriter(f.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write((String)ddl);
        bw.close();
        export.report.incrTypeCnt(objectType);
    }

    static String makeSrcDatabaseOwnerDir(Export export, String owner) {
        String path = export.projectPath + "/src";
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!(f = new File(path = export.projectPath + SRC_DATABASE)).exists()) {
            f.mkdirs();
        }
        if (!(f = new File(path = path + File.separator + owner.toLowerCase())).exists()) {
            f.mkdirs();
        }
        return path;
    }

    static File createFileWDir(String path, String objectName, String ext) {
        boolean isCaseSensitive = false;
        StringTokenizer st = new StringTokenizer(objectName, "/", false);
        File f = null;
        while (st.hasMoreElements()) {
            String token = st.nextToken();
            if (!isCaseSensitive) {
                token = token.toLowerCase();
            }
            path = (String)path + "/" + token;
            if (!st.hasMoreElements()) {
                path = (String)path + ext;
            }
            if (!(f = new File((String)path)).exists() && st.hasMoreElements()) {
                f.mkdirs();
            }
            if (!f.exists() || st.hasMoreElements()) continue;
            f.delete();
        }
        return f;
    }

    static String fileExtension(String objectType) {
        String ext = ".sql";
        return ext;
    }

    private static String editTemplate(String template, String pattern, ResultSet rs) {
        try {
            String tmp = rs.getString(pattern);
            if (tmp == null) {
                tmp = "";
            }
            template = template.replace("$" + pattern, tmp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return template;
    }

    public static String toMetadataTypeName(String typ) {
        String ret = typ;
        if ("DOMAIN".equals(ret)) {
            ret = "SQL_DOMAIN";
        }
        if ("PACKAGE".equals(ret)) {
            ret = "PACKAGE_SPEC";
        }
        if ("TYPE".equals(ret)) {
            ret = "TYPE_SPEC";
        }
        ret = ret.replace(' ', '_');
        return ret;
    }

    synchronized String getName() {
        return this.name;
    }

    private Pair<String, String> transformRefConstraint(Pair<String, String> ddlSxml) {
        return new Pair((Object)this.transformRefConstraint((String)ddlSxml.first()), (Object)((String)ddlSxml.second()));
    }

    String transformRefConstraint(String ddl) {
        if ("REF_CONSTRAINT".equals(this.type) && this.name.startsWith("SYS_C")) {
            ParsedSql target = new ParsedSql(ddl);
            String prg = "table: [node) table ->\nreferences: [node) identifier & [node^) references_clause ->\n";
            try {
                final LinkedList tmp = new LinkedList();
                SqlProgram program = new SqlProgram("table: [node) table ->\nreferences: [node) identifier & [node^) references_clause ->\n");
                program.eval((Parsed)target, new Object(){

                    public void table(Parsed target, Map<String, ParseNode> tuple) {
                        String content = tuple.get("node").content(target.getSrc());
                        if (content.indexOf(34) == 0) {
                            content = content.substring(1, content.length() - 1);
                        }
                        tmp.add(content);
                    }

                    public void references(Parsed target, Map<String, ParseNode> tuple) {
                        String content = tuple.get("node").content(target.getSrc());
                        if (content.indexOf(34) == 0) {
                            content = content.substring(1, content.length() - 1);
                        }
                        tmp.add(content);
                    }
                });
                Object newName = "";
                for (String t : tmp) {
                    newName = (String)newName + t + ".";
                }
                this.fileName = newName = ((String)newName).substring(0, ((String)newName).length() - 1);
            }
            catch (IOException | ScriptException throwable) {
                // empty catch block
            }
        }
        return ddl;
    }

    private Pair<String, String> transformMLE(Pair<String, String> ddlSxml) {
        return new Pair((Object)this.transformMLE((String)ddlSxml.first()), (Object)((String)ddlSxml.second()));
    }

    String transformMLE(String ddl) {
        if ("MLE_MODULE".equals(this.type)) {
            ParsedSql target = new ParsedSql(ddl);
            List src = target.getSrc();
            LexerToken last1 = (LexerToken)src.subList(src.size() - 2, src.size() - 1).get(0);
            if ("/".equals(last1.content)) {
                ddl = ddl.substring(0, last1.end);
            }
        }
        return ddl;
    }

    Pair<String, String> transformSequence(Pair<String, String> ddlSxml) {
        boolean oraMaintained = this.export.filters.containsKey("oracle_maintained = 'Y'");
        if ("SEQUENCE".equals(this.type) && oraMaintained) {
            Object ddl = (String)ddlSxml.first();
            List src = Lexer.parse((String)ddl);
            int begin = -1;
            int end = -1;
            int digits = -1;
            for (LexerToken t : src) {
                if (begin == -1 && "start".equalsIgnoreCase(t.content)) {
                    begin = t.begin;
                    continue;
                }
                if (0 >= begin || t.type != Token.DIGITS) continue;
                end = t.end;
                digits = Integer.parseInt(t.content);
                break;
            }
            Object replacement = "/*start with " + digits + "*/";
            if (oraMaintained) {
                replacement = "/* start with n */";
            }
            ddl = ((String)ddl).substring(0, begin) + (String)replacement + ((String)ddl).substring(end);
            Object sxml = (String)ddlSxml.second();
            begin = ((String)sxml).indexOf("<START_WITH>");
            end = ((String)sxml).indexOf("</START_WITH>") + "</START_WITH>".length();
            sxml = ((String)sxml).substring(0, begin) + ((String)sxml).substring(end);
            return new Pair(ddl, sxml);
        }
        return ddlSxml;
    }

    Pair<String, String> transformDirectory(Pair<String, String> ddlSxml) {
        if ("DIRECTORY".equals(this.type) && this.export.filters.containsKey("oracle_maintained = 'Y'")) {
            Object ddl = (String)ddlSxml.first();
            List src = Lexer.parse((String)ddl);
            int begin = -1;
            int end = -1;
            for (LexerToken t : src) {
                if (t.type != Token.QUOTED_STRING) continue;
                begin = t.begin;
                end = t.end;
                break;
            }
            ddl = ((String)ddl).substring(0, begin) + "'/ade/b/0123456789/oracle/rdbms/admin'" + ((String)ddl).substring(end);
            return new Pair(ddl, (Object)((String)ddlSxml.second()));
        }
        return ddlSxml;
    }

    private Pair<String, String> transformMV(Pair<String, String> ddlSxml) {
        return new Pair((Object)this.transformMV((String)ddlSxml.first()), (Object)((String)ddlSxml.second()));
    }

    private String transformMV(String ddl) {
        if (!"MATERIALIZED_VIEW".equals(this.type)) {
            return ddl;
        }
        ParsedSql target = new ParsedSql(ddl);
        final Substitutions replace = new Substitutions((Parsed)target);
        String prg = "physical_properties: [node) physical_properties \n       &  ![node^) physical_properties \n; \nphysical_attributes_clause: [node) physical_attributes_clause \n       &  ![node^) physical_attributes_clause \n; \nalter_trigger: [child) alter_trigger \n       &  child^= node \n; \nrollback_segment: [gchild) 'SEGMENT' & [gchild^-1) 'USING'\n                               &  gchild^^= node \n; \ntmp: physical_properties | alter_trigger | physical_attributes_clause | rollback_segment\n; \ndelete: [*[)) node(tmp)->";
        try {
            SqlProgram program = new SqlProgram(prg);
            program.eval((Parsed)target, new Object(){

                public void delete(Parsed target, Map<String, ParseNode> tuple) {
                    ParseNode node = tuple.get("node");
                    replace.replace(node, "");
                }
            });
        }
        catch (IOException | ScriptException e) {
            Report.warning(this.ctx, e);
        }
        ddl = replace.transformInput();
        return ddl;
    }

    private Pair<String, String> transformTrigger(Pair<String, String> ddlSxml, String schema) {
        return new Pair((Object)this.transformTrigger((String)ddlSxml.first(), schema, (String)ddlSxml.second()), (Object)((String)ddlSxml.second()));
    }

    private String transformTrigger(String ddl, String schema, String sxml) {
        if (!"TRIGGER".equals(this.type)) {
            return ddl;
        }
        ParsedSql target = new ParsedSql(ddl);
        Substitutions replace = new Substitutions((Parsed)target);
        boolean emit_schema = Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean(EXPORT_SET_TRANSFORM_EMIT_SCHEMA));
        String prg = "triggerOwner: [node) identifier & [node+1) '.'\n              & [node^) decl_id\n              & [node^^) trigger\n->\ntableOwner: [node^) dml_event_clause & \n            [node-1) 'ON' &  [node) identifier & [node+1) '.'\n->\ntrigger: [node) decl_id & [node) identifier & \n         [node^) trigger\n->\ntable: [node^) dml_event_clause & \n      (  [node-1) 'ON' &  [node) identifier & ![node+1) '.'\n      )\n->\n";
        try {
            int pos;
            final ParseNode[] table = new ParseNode[1];
            final ParseNode[] trigger = new ParseNode[1];
            final ParseNode[] tableOwner = new ParseNode[1];
            final ParseNode[] triggerOwner = new ParseNode[1];
            SqlProgram program = new SqlProgram(prg);
            program.eval((Parsed)target, new Object(){

                public void trigger(Parsed target, Map<String, ParseNode> tuple) {
                    trigger[0] = tuple.get("node");
                }

                public void table(Parsed target, Map<String, ParseNode> tuple) {
                    table[0] = tuple.get("node");
                }

                public void triggerOwner(Parsed target, Map<String, ParseNode> tuple) {
                    triggerOwner[0] = tuple.get("node");
                }

                public void tableOwner(Parsed target, Map<String, ParseNode> tuple) {
                    tableOwner[0] = tuple.get("node");
                }
            });
            String key = "<SCHEMA>";
            int start = sxml.indexOf(key) + key.length();
            int end = sxml.indexOf("</SCHEMA>", start);
            String schema1 = schema;
            start = sxml.indexOf(key, end) + key.length();
            end = sxml.indexOf("</SCHEMA>", start);
            String schema2 = schema;
            if (trigger[0] != null && emit_schema) {
                pos = ((LexerToken)target.getSrc().get((int)trigger[0].from)).begin;
                replace.put(pos, pos, schema1 + ".");
            }
            if (triggerOwner[0] != null && emit_schema && !schema1.equals(schema2)) {
                replace.replace(triggerOwner[0], schema1);
            }
            if (table[0] != null && emit_schema) {
                pos = ((LexerToken)target.getSrc().get((int)table[0].from)).begin;
                replace.put(pos, pos, schema2 + ".");
            }
            if (tableOwner[0] != null && emit_schema && !schema1.equals(schema2)) {
                replace.replace(tableOwner[0], schema2);
            }
            if (tableOwner[0] != null && !emit_schema && schema1.equals(schema2)) {
                replace.replace(((LexerToken)target.getSrc().get((int)tableOwner[0].from)).begin, ((LexerToken)target.getSrc().get((int)tableOwner[0].to)).end, "");
            }
        }
        catch (IOException | ScriptException e) {
            Report.warning(this.ctx, e);
        }
        catch (Throwable e) {
            Report.debug(this.ctx, ddl);
            Report.processException(this.ctx, e, this.type, this.name);
        }
        ddl = replace.transformInput();
        return ddl;
    }

    private Pair<String, String> transformTable(Pair<String, String> ddlSxml) {
        return new Pair((Object)this.transformTable((String)ddlSxml.first(), (String)ddlSxml.second()), (Object)((String)ddlSxml.second()));
    }

    private String transformTable(String ddl, String sxml) {
        if (!"TABLE".equals(this.type)) {
            return ddl;
        }
        final ParsedSql target = new ParsedSql(ddl);
        String prg = "usage_clauses: [node) usage_clause \n->\nconstraint_clause: [node) constraint_clauses \n->";
        final LinkedList constraintStatements = new LinkedList();
        final LinkedList orderedConstraints = new LinkedList();
        final boolean[] usageClauseFound = new boolean[]{false};
        try {
            SqlProgram program = new SqlProgram("usage_clauses: [node) usage_clause \n->\nconstraint_clause: [node) constraint_clauses \n->");
            program.eval((Parsed)target, new Object(){

                public void usage_clauses(Parsed target, Map<String, ParseNode> tuple) {
                    usageClauseFound[0] = true;
                }

                public void constraint_clause(Parsed target, Map<String, ParseNode> tuple) {
                    constraintStatements.add(tuple.get("node").parent().parent());
                    orderedConstraints.add(tuple.get("node").parent().parent());
                }
            });
        }
        catch (AssertionError e) {
            return null;
        }
        catch (IOException | ScriptException e) {
            Report.warning(this.ctx, e.getMessage());
        }
        if (usageClauseFound[0]) {
            return null;
        }
        Collections.sort(orderedConstraints, new Comparator<ParseNode>(){

            @Override
            public int compare(ParseNode p1, ParseNode p2) {
                String s1 = target.content(p1);
                String s2 = target.content(p2);
                return s1.compareTo(s2);
            }
        });
        Substitutions replace = new Substitutions((Parsed)target);
        for (int i = 0; i < orderedConstraints.size(); ++i) {
            replace.put((ParseNode)constraintStatements.get(i), target.content((ParseNode)orderedConstraints.get(i)));
        }
        ddl = replace.transformInput();
        return ddl;
    }

    public synchronized boolean setArgs(String owner, String type, String name) {
        if (this.name != null) {
            return false;
        }
        this.type = DbmsMetadata.toMetadataTypeName(type);
        this.name = name;
        this.owner = owner;
        return true;
    }

    protected void init() {
        try {
            this.instance = cnt++;
            this.metadataThread = new Thread("DbmsMetadata# " + this.instance){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DbmsMetadata.this.quit = false;
                    while (!DbmsMetadata.this.quit) {
                        try {
                            String ddl;
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (DbmsMetadata.this.getName() == null) continue;
                            DbmsMetadata.this.fileName = DbmsMetadata.this.getName();
                            DbObj dbObj = new DbObj(DbmsMetadata.this.owner, DbmsMetadata.this.name, DbmsMetadata.this.type);
                            Pair<String, String> ddlSxml = null;
                            if ("CONTEXT".equals(DbmsMetadata.this.type)) {
                                ddlSxml = new Pair<String, String>((Object)DbmsMetadata.this.getContext(), (Object)"");
                            } else if ("SCHEDULE".equals(DbmsMetadata.this.type)) {
                                ddlSxml = new Pair((Object)DbmsMetadata.this.getSchedule(), (Object)"");
                            } else if ("DIRECTORY".equals(DbmsMetadata.this.type)) {
                                ddlSxml = new Pair<String, String>((Object)DbmsMetadata.this.getDirectory(), (Object)"");
                            } else if ("EDITION".equals(DbmsMetadata.this.type)) {
                                ddlSxml = new Pair<String, String>((Object)DbmsMetadata.this.getEdition(), (Object)"");
                            } else {
                                if ("APEX".equals(DbmsMetadata.this.type)) {
                                    DbmsMetadata.this.exportApex();
                                    continue;
                                }
                                if ("PROCEDURE".equals(DbmsMetadata.this.type) || "FUNCTION".equals(DbmsMetadata.this.type) || "PACKAGE_SPEC".equals(DbmsMetadata.this.type) || "PACKAGE_BODY".equals(DbmsMetadata.this.type) || "TYPE_SPEC".equals(DbmsMetadata.this.type) || "TYPE_BODY".equals(DbmsMetadata.this.type) || "LIBRARY".equals(DbmsMetadata.this.type)) {
                                    ddl = DbmsMetadata.this.getPlsql();
                                    if (ddl == null) {
                                        String msg = "No ddl found in all_source";
                                        DbmsMetadata.this.export.report.errors.put(dbObj, "No ddl found in all_source");
                                        continue;
                                    }
                                    ddlSxml = new Pair<String, String>((Object)ddl, (Object)"");
                                } else {
                                    if (DbmsMetadata.this.type == null) {
                                        DbmsMetadata.this.export.report.errors.put(dbObj, "object_type == null --> ORA-31600");
                                        continue;
                                    }
                                    ddlSxml = DbmsMetadata.this.getMetadata();
                                    if (ddlSxml == null) {
                                        if (DbmsMetadata.this.export.report.errors.get(dbObj) != null) continue;
                                        DbmsMetadata.this.export.report.errors.put(dbObj, "ddlSxml == null");
                                        continue;
                                    }
                                }
                            }
                            ddlSxml = DbmsMetadata.this.transformMV(ddlSxml);
                            ddlSxml = DbmsMetadata.this.transformTrigger(ddlSxml, DbmsMetadata.this.owner);
                            ddlSxml = DbmsMetadata.this.transformTable(ddlSxml);
                            ddlSxml = DbmsMetadata.this.transformRefConstraint(ddlSxml);
                            ddlSxml = DbmsMetadata.this.transformMLE(ddlSxml);
                            ddlSxml = DbmsMetadata.this.transformSequence(ddlSxml);
                            ddlSxml = DbmsMetadata.this.transformDirectory(ddlSxml);
                            if (ddlSxml.first() == null) {
                                Report.verbose(DbmsMetadata.this.ctx, DbmsMetadata.this.owner + "." + DbmsMetadata.this.name + " -- ddl == null; skipped");
                                DbmsMetadata.this.export.report.errors.put(dbObj, "ddl == null");
                                continue;
                            }
                            ddl = (String)ddlSxml.first();
                            int cut = 200;
                            cut = Integer.min(cut, ddl.length());
                            String prefix = ddl.toLowerCase().substring(0, cut);
                            if (prefix.indexOf("wrapped") < 0) {
                                try {
                                    long t11 = System.currentTimeMillis();
                                    ddl = Export.format_(ddl);
                                    DbmsMetadata.this.export.report.formatTiming += System.currentTimeMillis() - t11;
                                }
                                catch (SyntaxError e) {
                                    DbmsMetadata.this.export.report.addFailedFormat(dbObj, "Failed to format, syntax error");
                                }
                                catch (Exception e) {
                                    DbmsMetadata.this.export.report.errors.put(dbObj, e.toString());
                                }
                            }
                            try {
                                String sxml = (String)ddlSxml.second();
                                if ("TRIGGER".equals(DbmsMetadata.this.type)) {
                                    sxml = "";
                                }
                                ddl = DbmsMetadata.appendSxmlAndHash(DbmsMetadata.this.owner, DbmsMetadata.this.type, DbmsMetadata.this.name, ddl, sxml);
                            }
                            catch (NoSuchAlgorithmException e) {
                                Report.warning(DbmsMetadata.this.ctx, e);
                                DbmsMetadata.this.export.report.errors.put(dbObj, e.getMessage());
                                ddl = (String)ddlSxml.first();
                            }
                            DbmsMetadata.saveDbObject(DbmsMetadata.this.export, DbmsMetadata.this.owner, DbmsMetadata.this.type, DbmsMetadata.this.fileName, ddl);
                        }
                        catch (IOException e) {
                            Report.error(DbmsMetadata.this.ctx, DbmsMetadata.this.type, DbmsMetadata.this.name, e);
                        }
                        finally {
                            DbmsMetadata.this.ready();
                        }
                    }
                    try {
                        if (DbmsMetadata.this.conn != DbmsMetadata.this.ctx.getCurrentConnection() && !DbmsMetadata.this.conn.isClosed()) {
                            DbmsMetadata.this.conn.close();
                        }
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() != 3113) {
                            Report.warning(DbmsMetadata.this.ctx, "Failed to close connection");
                            Report.debug(DbmsMetadata.this.ctx, e);
                        }
                    }
                    finally {
                        DbmsMetadata.this.finished = true;
                    }
                }
            };
            this.metadataThread.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    private synchronized void ready() {
        this.name = null;
        this.type = null;
        this.owner = null;
    }

    /*
     * Exception decompiling
     */
    private Pair<String, String> getMetadata() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    private Pair<String, String> getView() {
        ResultSet rs;
        Statement stmt;
        boolean emit_schema = Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean(EXPORT_SET_TRANSFORM_EMIT_SCHEMA));
        Object ret = "create or replace view " + this.name + "(\n";
        if (emit_schema) {
            ret = "create or replace view " + this.owner + "." + this.name + "(\n";
        }
        Object query = "select * from all_tab_columns \n where table_name = '" + this.name + "' \n and owner = '" + this.owner + "' \n\tORDER BY column_id";
        query = this.dictViews.translate((String)query);
        try {
            stmt = this.conn.createStatement();
            try {
                rs = stmt.executeQuery((String)query);
                try {
                    while (rs.next()) {
                        String col = rs.getString("column_name");
                        ret = (String)ret + col + ",";
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (Throwable e) {
            this.processException(e);
        }
        ret = ((String)ret).substring(0, ((String)ret).length() - 1);
        ret = (String)ret + ") as \n";
        query = "select * from all_views \n where view_name = '" + this.name + "' \n and owner = '" + this.owner + "' \n";
        query = this.dictViews.translate((String)query);
        if ("SYS".equals(this.owner)) {
            query = "   select\n        o.name,\n        v.textlength,\n        v.text\n     from\n        sys.\"_CURRENT_EDITION_OBJ\" o,\n        sys.view$                  v\n    where\n            o.obj# = v.obj#\n        and o.owner# = 0\n        and o.name ='" + this.name + "'\n";
        }
        try {
            stmt = this.conn.createStatement();
            try {
                rs = stmt.executeQuery((String)query);
                try {
                    rs.next();
                    int len = rs.getInt("textlength");
                    Reader select = rs.getCharacterStream("text");
                    if (select != null) {
                        Report.writeln(this.ctx, this.name + ": text_length=" + len);
                        char[] cbuf = new char[len];
                        ret = (String)ret + select.read(cbuf);
                        select.close();
                    } else {
                        ret = (String)ret + rs.getString("text_vc");
                        if (4000 < len) {
                            this.error(this.ctx, this.name + ": text_length=" + len);
                        }
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        catch (Throwable e) {
            this.processException(e);
        }
        if (!((String)ret).endsWith("\n")) {
            ret = (String)ret + "\n";
        }
        return new Pair(ret, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPlsql() {
        boolean emit_schema = Boolean.TRUE.equals(ProjectSettings.getSettingAsBoolean(EXPORT_SET_TRANSFORM_EMIT_SCHEMA));
        long t1 = System.currentTimeMillis();
        String objectType = this.type;
        if ("PACKAGE_SPEC".equals(objectType)) {
            objectType = "PACKAGE";
        }
        if ("TYPE_SPEC".equals(objectType)) {
            objectType = "TYPE";
        }
        objectType = objectType.replace('_', ' ');
        Object ret = "create or replace \n";
        Object query = "WITH src AS (SELECT ROWNUM,LINE,TEXT,origin_con_id FROM SYS.ALL_SOURCE \n\tWHERE TYPE = '" + objectType + "' \nAND OWNER = '" + this.owner + "' \nAND NAME = '" + this.name + "')\n\tSELECT line,text FROM src, (SELECT max(origin_con_id) max_orig FROM src)  \n\tWHERE origin_con_id = max_orig \n\tORDER BY LINE";
        query = this.dictViews.translate((String)query);
        int line = -1;
        try (Statement stmt = this.conn.createStatement();
             ResultSet rs = stmt.executeQuery((String)query);){
            while (rs.next()) {
                String text = rs.getString("text");
                line = rs.getInt("line");
                ret = (String)ret + text;
            }
        }
        catch (Throwable e) {
            this.processException(e);
        }
        finally {
            plsTiming += System.currentTimeMillis() - t1;
        }
        if (line < 0) {
            return null;
        }
        List src = Lexer.parse((String)ret);
        String prior = null;
        int i = -1;
        for (LexerToken t : src) {
            ++i;
            String current = t.content.toUpperCase();
            if (current.equals("BODY")) {
                prior = current;
                continue;
            }
            if (prior != null && (prior.equals("PACKAGE") || prior.equals("BODY") || prior.equals("TYPE") || prior.equals("FUNCTION") || prior.equals("PROCEDURE") || prior.equals("LIBRARY") || prior.equals("TRIGGER"))) break;
            prior = current;
        }
        if (emit_schema) {
            if (i < src.size() - 1 && !".".equals(((LexerToken)src.get((int)(i + 1))).content)) {
                try {
                    int pos = ((LexerToken)src.get((int)i)).begin;
                    ret = ((String)ret).substring(0, pos) + this.owner + "." + ((String)ret).substring(pos);
                }
                catch (StringIndexOutOfBoundsException e) {
                    System.out.println("StringIndexOutOfBoundsException: " + this.owner + "." + this.name);
                }
            }
        } else if (i < src.size() - 1 && ".".equals(((LexerToken)src.get((int)(i + 1))).content)) {
            try {
                int start = ((LexerToken)src.get((int)i)).begin;
                int finish = ((LexerToken)src.get((int)(i + 1))).end;
                ret = ((String)ret).substring(0, start) + ((String)ret).substring(finish);
            }
            catch (StringIndexOutOfBoundsException e) {
                System.out.println("StringIndexOutOfBoundsException: " + this.owner + "." + this.name);
            }
        }
        if (!((String)ret).endsWith("\n")) {
            ret = (String)ret + "\n";
        }
        return (String)ret + "/\n";
    }

    private String getSchedule() {
        String ret = "BEGIN\n      DBMS_SCHEDULER.create_schedule (\n         schedule_name => '" + this.name + "' \n ";
        Object query = "SELECT start_date,  \n end_date,  \n repeat_interval, \n comments \nFROM all_scheduler_schedules \n\tWHERE OWNER = '" + this.owner + "' \nAND SCHEDULE_NAME = '" + this.name + "'\n";
        query = this.dictViews.translate((String)query);
        try (Statement stmt = this.conn.createStatement();
             ResultSet rs = stmt.executeQuery((String)query);){
            while (rs.next()) {
                String column = "start_date";
                Timestamp tvalue = rs.getTimestamp(column);
                Object value = null;
                if (tvalue != null) {
                    value = "timestamp '" + String.valueOf(tvalue) + "'";
                }
                ret = ret + "," + column + "=>" + (String)value + "\n";
                column = "end_date";
                tvalue = rs.getTimestamp(column);
                if (tvalue != null) {
                    value = "timestamp '" + String.valueOf(tvalue) + "'";
                }
                ret = ret + "," + column + "=>" + (String)value + "\n";
                column = "repeat_interval";
                value = rs.getString(column);
                if (value != null) {
                    value = "'" + (String)value + "'";
                }
                ret = ret + "," + column + "=>" + (String)value + "\n";
                column = "comments";
                value = rs.getString(column);
                if (value != null) {
                    value = "'" + (String)value + "'";
                }
                ret = ret + "," + column + "=>" + (String)value + "\n";
            }
        }
        catch (Throwable e) {
            this.processException(e);
        }
        ret = ret + ");\n    END;\n/\n";
        return ret;
    }

    private void exportApex() {
        try {
            LinkedHashMap<String, APEXExport.RowDetails> exported = ApexExportWrapper.ExportApplication(this.name, this.ctx, this.conn);
            Object path = DbmsMetadata.makeSrcDatabaseOwnerDir(this.export, this.owner);
            path = (String)path + "/apex_apps";
            File f = new File((String)path);
            if (!f.exists()) {
                f.mkdirs();
            }
            boolean success = false;
            for (String key : exported.keySet()) {
                APEXExport.RowDetails row = exported.get(key);
                if (row == null) {
                    Report.error(this.ctx, "row == null for the key " + key);
                    continue;
                }
                String appPath = (String)path + "/f" + row.getAppId();
                f = new File(appPath);
                if (!f.exists()) {
                    f.mkdirs();
                }
                String content = !(f = DbmsMetadata.createFileWDir(appPath, row.getFileName(), "")).toString().contains("readable") ? DbmsMetadata.appendSxmlAndHash(this.conn.getSchema(), "APEX_APPLICATIONS", "f" + row.getAppId(), row.getContents(), null) : row.getContents();
                GeneralMessages.debugMessage("saving " + f.toString());
                f.createNewFile();
                FileWriter fw = new FileWriter(f.getAbsoluteFile());
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(content);
                bw.close();
                success = true;
            }
            if (success) {
                this.export.report.incrTypeCnt(ObjectTypes.singular("APEX_APPLICATIONS"));
            }
        }
        catch (Exception e) {
            Report.warning(this.ctx, "Failed to export application_id = " + this.name + " due to " + e.getMessage());
        }
    }

    String getContext() {
        String query = "select * from dba_context where namespace = '" + this.name + "'";
        String template = "create or replace context " + this.name + " using $schema.$package $type;";
        return this.makeDDL(template, query, new String[]{"type", "schema", "package"});
    }

    String getDirectory() {
        String query = "select * from all_directories  where owner = '" + this.owner + "'  and directory_name = '" + this.name + "'";
        String template = "create or replace directory " + this.name + " as '$directory_path';";
        return this.makeDDL(template, query, new String[]{"directory_path"});
    }

    String getEdition() {
        String query = "select 'AS CHILD OF '|| parent_edition_name asOfParentEditionName  from all_editions  where edition_name = '" + this.name + "'";
        String template = "create edition " + this.name + " $asChildOf_ParentName;";
        return this.makeDDL(template, query, new String[]{"asChildOf_ParentName"});
    }

    String makeDDL(String template, String query, String[] columns) {
        query = this.dictViews.translate(query);
        try (Statement stmt = this.conn.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            rs.next();
            for (String col : columns) {
                template = DbmsMetadata.editTemplate(template, col, rs);
            }
        }
        catch (Throwable e) {
            this.processException(e);
            this.export.cancelExport();
        }
        return template;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    boolean isDisabled(String owner, String name) {
        Object query = "select status from all_triggers where owner='" + owner + "' and trigger_name = '" + name + "'";
        query = this.dictViews.translate((String)query);
        try (Statement stmt = this.conn.createStatement();){
            boolean bl;
            block14: {
                ResultSet rs = stmt.executeQuery((String)query);
                try {
                    rs.next();
                    bl = "DISABLED".equals(rs.getString("STATUS"));
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (Throwable e) {
            this.processException(e);
            this.export.cancelExport();
            return false;
        }
    }

    private void processException(Throwable t) {
        Report.processException(this.ctx, t, this.type, this.name);
        String typ = this.type;
        if (typ == null) {
            typ = "null";
        }
        this.export.report.errors.put(new DbObj(this.owner, this.name, typ), t.getMessage());
    }

    void error(ScriptRunnerContext ctx, String msg) {
        Report.error(ctx, msg);
    }
}

