/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.export;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import oracle.dbtools.extension.apex.command.ApexOptions;
import oracle.dbtools.extension.apex.command.MutableCommand;
import oracle.dbtools.extension.apex.core.APEXExport;
import oracle.dbtools.extension.apex.exceptions.InvalidApexExportException;
import oracle.dbtools.extension.apex.exceptions.OutputBufferNotInitialized;
import oracle.dbtools.extension.project.commands.export.Report;
import oracle.dbtools.extension.project.core.exceptions.ProjectNotIdentifiedException;
import oracle.dbtools.extension.project.core.exceptions.ProjectSettingsException;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.extension.project.core.settings.SettingTypes;
import oracle.dbtools.extension.project.core.settings.Settings;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;

public class ApexExportWrapper {
    public static void main(String[] args) throws Exception {
        String driver = "oracle.dbtools.jdbc.Driver";
        String DB_URL = "jdbc:oracle:thin:skutz/oracle@miniwin.local:1522/orcl21pdb";
        Connection conn = DriverManager.getConnection(DB_URL);
        ScriptRunnerContext ctx = new ScriptRunnerContext();
        ctx.setCurrentConnection(conn);
        ctx.setOutputStreamWrapper(new BufferedOutputStream(System.out));
        ApexExportWrapper.ExportApplication("100", ctx, ctx.getBaseConnection());
    }

    public static LinkedHashMap<String, APEXExport.RowDetails> ExportApplication(String api, ScriptRunnerContext ctx, Connection conn) throws SQLException, InvalidApexExportException, OutputBufferNotInitialized, IOException, ProjectNotIdentifiedException, ProjectSettingsException {
        Object ret = null;
        BigDecimal value = BigDecimal.valueOf(Long.valueOf(api));
        final HashMap<String, Object> flags = new HashMap<String, Object>();
        MutableCommand command = new MutableCommand(null){

            public boolean isFlagSet(Id flagId) {
                Boolean ret = (Boolean)flags.get(flagId.getName().toUpperCase());
                if (ret != null) {
                    return ret;
                }
                return false;
            }
        };
        command.setOptionValue((Id)ApexOptions.Symbol.APPLICATIONID, (Object)value);
        command.setOptionValue((Id)ApexOptions.Symbol.SPLIT, ApexOptions.SPLIT_O.getDefaultValue());
        String apexOptionsPath = "export.apex";
        Settings apex = ProjectSettings.getSettingsNode("export.apex");
        for (Settings settings : apex.getChildren()) {
            Object val;
            if ("N".equals(settings.getPub()) || "path".equals(settings.getName()) || "expPkgAppMapping".equalsIgnoreCase(settings.getName()) || "expsubscriptions".equalsIgnoreCase(settings.getName())) continue;
            if (settings.getType() == SettingTypes.BOOLEAN) {
                val = ProjectSettings.getSettingAsBoolean("export.apex." + settings.getName());
                Report.debug(ctx, settings.getName() + "=" + (Boolean)val);
                flags.put(settings.getName().toUpperCase(), val);
                command.setOptionValue((Id)ApexExportWrapper.match(settings.getName(), ctx), val);
                continue;
            }
            if (settings.getType() == SettingTypes.ARRAY) {
                val = ProjectSettings.getSettingAsList("export.apex." + settings.getName());
                Report.debug(ctx, settings.getName() + "=" + String.valueOf(val));
                command.setOptionValue((Id)ApexExportWrapper.match(settings.getName(), ctx), val);
                continue;
            }
            if (settings.getType() != SettingTypes.STRING) continue;
            val = ProjectSettings.getSettingAsString("export.apex." + settings.getName());
            Report.debug(ctx, settings.getName() + "=" + (String)val);
            command.setOptionValue((Id)ApexExportWrapper.match(settings.getName(), ctx), val);
        }
        boolean withSubscriptions = ProjectSettings.getSettingAsBoolean("export.apex.expSubscriptions");
        command.setOptionValue((Id)ApexOptions.Symbol.EXPNOSUBSCRIPTIONS, (Object)(!withSubscriptions ? 1 : 0));
        APEXExport exp = new APEXExport(command, true);
        exp.setOutStream((OutputStream)ctx.getOutputStream());
        exp.setConnection(conn);
        exp.ExportApplication(false);
        return exp.getResults();
    }

    static ApexOptions.Symbol match(String name, ScriptRunnerContext ctx) {
        for (ApexOptions.Symbol obj : ApexOptions.Symbol.values()) {
            if (!obj.toString().equalsIgnoreCase(name)) continue;
            return obj;
        }
        Report.error(ctx, "Error: " + name + " has no matches");
        return null;
    }
}

