/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc.util;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;

public class DateTimestampsUtil {
    public Timestamp getTimestamp(String tsStr, String timeZoneID) {
        Instant instant = Instant.parse(tsStr);
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.of(timeZoneID));
        return Timestamp.valueOf(localDateTime);
    }

    public Date getDate(String tsStr, String timeZoneID) {
        Timestamp timestamp = this.getTimestamp(tsStr, timeZoneID);
        return new Date(timestamp.getTime());
    }

    public Date getDate(String tsStr) throws SQLException {
        return Date.valueOf(tsStr);
    }

    public String setTimeStamp(Timestamp ts, String timeZoneID, Calendar cal) {
        ZoneId ordsZoneId = ZoneId.of(timeZoneID);
        Instant instant = ts.toLocalDateTime().atZone(ordsZoneId).toInstant();
        ZonedDateTime ordsZonedDateTime = instant.atZone(ordsZoneId);
        LocalDateTime localDateTime = ordsZonedDateTime.toLocalDateTime();
        DateTimeFormatter isoFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        return localDateTime.format(isoFormatter);
    }

    public String setDate(Date date, String timeZoneID, Calendar cal) {
        Timestamp ts = new Timestamp(date.getTime());
        return this.setTimeStamp(ts, timeZoneID, cal);
    }

    public String setTime(Time time, String timeZoneID, Calendar cal) {
        Timestamp ts = new Timestamp(time.getTime());
        return this.setTimeStamp(ts, timeZoneID, cal);
    }

    protected String getTimestampStr(Calendar cal, boolean sendToAdhoc) {
        StringBuilder sb = new StringBuilder();
        sb.append(cal.get(1));
        sb.append('-');
        if (cal.get(2) < 9) {
            sb.append('0');
        }
        sb.append(cal.get(2) + 1);
        sb.append('-');
        if (cal.get(5) < 10) {
            sb.append('0');
        }
        sb.append(cal.get(5));
        if (sendToAdhoc) {
            sb.append('T');
        } else {
            sb.append(' ');
        }
        if (cal.get(11) < 10) {
            sb.append('0');
        }
        sb.append(cal.get(11));
        sb.append(':');
        if (cal.get(12) < 10) {
            sb.append('0');
        }
        sb.append(cal.get(12));
        sb.append(':');
        if (cal.get(13) < 10) {
            sb.append('0');
        }
        sb.append(cal.get(13));
        sb.append('.');
        int millis = cal.get(14);
        if (millis < 10) {
            sb.append("00");
        } else if (millis < 100) {
            sb.append('0');
        }
        sb.append(millis);
        if (sendToAdhoc) {
            sb.append('Z');
        }
        return sb.toString();
    }

    public Timestamp getTimestamp(String tsStr, String timeZoneID, Calendar cal) {
        Timestamp rsTimestamp = this.getTimestamp(tsStr, timeZoneID);
        Instant instant = rsTimestamp.toInstant();
        ZoneId defaultZoneId = ZoneId.systemDefault();
        ZonedDateTime localZonedDateTime = instant.atZone(defaultZoneId);
        cal.set(1, localZonedDateTime.getYear());
        cal.set(2, localZonedDateTime.getMonthValue() - 1);
        cal.set(5, localZonedDateTime.getDayOfMonth());
        cal.set(11, localZonedDateTime.getHour());
        cal.set(12, localZonedDateTime.getMinute());
        cal.set(13, localZonedDateTime.getSecond());
        cal.set(14, localZonedDateTime.getNano() / 1000000);
        Timestamp sqlTimestamp = new Timestamp(cal.getTimeInMillis());
        sqlTimestamp.setNanos(localZonedDateTime.getNano());
        return sqlTimestamp;
    }

    public Date getDate(String tsStr, String timeZoneID, Calendar cal) {
        Timestamp timestamp = this.getTimestamp(tsStr, timeZoneID, cal);
        return new Date(timestamp.getTime());
    }

    public Time getTime(String tsStr) {
        return Time.valueOf(tsStr);
    }

    public Time getTime(String tsStr, String timeZoneID, Calendar cal) {
        Timestamp rsTimestamp = this.getTimestamp(tsStr, timeZoneID);
        ZonedDateTime localZonedDateTime = rsTimestamp.toInstant().atZone(ZoneId.systemDefault());
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, localZonedDateTime.getHour());
        cal.set(12, localZonedDateTime.getMinute());
        cal.set(13, localZonedDateTime.getSecond());
        cal.set(14, localZonedDateTime.getNano() / 1000000);
        return new Time(cal.getTimeInMillis());
    }
}

