/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.jdbc;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.stree.JacksonJrsTreeCodec;
import com.fasterxml.jackson.jr.stree.JrsNumber;
import com.fasterxml.jackson.jr.stree.JrsString;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.http.Client;
import oracle.dbtools.http.Session;
import oracle.dbtools.http.SessionCreator;
import oracle.dbtools.http.SessionException;
import oracle.dbtools.http.SessionInfo;
import oracle.dbtools.jdbc.BLOB;
import oracle.dbtools.jdbc.CLOB;
import oracle.dbtools.jdbc.CallableStatement;
import oracle.dbtools.jdbc.DatabaseMetaData;
import oracle.dbtools.jdbc.PreparedStatement;
import oracle.dbtools.jdbc.ResultSet;
import oracle.dbtools.jdbc.Statement;
import oracle.dbtools.jdbc.util.ExceptionUtil;
import oracle.dbtools.jdbc.util.JDBCClient;
import oracle.dbtools.jdbc.util.JDBCSessionType;
import oracle.dbtools.jdbc.util.LogUtil;
import oracle.dbtools.jdbc.util.RestJdbcNotImplementedException;
import oracle.dbtools.jdbc.util.RestjdbcResources;
import oracle.dbtools.jdbc.util.RestjdbcSqlWarnings;
import oracle.dbtools.jdbc.util.SQLStateMapping;
import oracle.dbtools.oci.OCIProfiles;
import oracle.dbtools.oci.OCIRESTClient;
import oracle.dbtools.oci.OCIRequest;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class Connection
implements java.sql.Connection {
    private static String DRIVER_NAME = "Oracle REST JDBC driver";
    Logger logger;
    private String db_url;
    private String full_url;
    private Properties info;
    private Session jdbcSession;
    private OCIRESTClient ociRESTClient;
    private java.sql.DatabaseMetaData databaseMetaData;
    public boolean debug;
    private String token;
    private SQLWarning sqlWarn;
    private boolean muteWarnings;
    private static final String ADHOC_ENDPOINT = "_/sql";
    private boolean isClosed;
    protected static boolean basic_auth = false;
    private static boolean isOCIConnection = false;
    private boolean readOnly;

    public Connection(String url, Properties info) throws SQLException {
        block16: {
            this.logger = Logger.getLogger(Connection.class.getName());
            this.db_url = null;
            this.full_url = null;
            this.info = null;
            this.jdbcSession = null;
            this.ociRESTClient = null;
            this.databaseMetaData = null;
            this.debug = false;
            this.token = null;
            this.sqlWarn = null;
            this.muteWarnings = false;
            this.isClosed = false;
            this.readOnly = false;
            this.info = info;
            this.full_url = url;
            url = LogUtil.getUrlProperties(url, this.info);
            try {
                String user = null;
                char[] pwd = new char[]{};
                String oci_config_filepath = "oci_config_filepath";
                String oci_profile = "oci_profile";
                String region = "region";
                if (info.containsKey("user") && info.get("user") != null) {
                    user = (String)info.get("user");
                    basic_auth = true;
                } else if (info.containsKey(oci_profile)) {
                    basic_auth = false;
                } else {
                    throw new SQLException(RestjdbcResources.getString("RESTJDBC_001"));
                }
                if (basic_auth) {
                    if (!info.containsKey("password") || info.get("password") == null) {
                        throw new SQLException(RestjdbcResources.getString("RESTJDBC_002"));
                    }
                    String password = (String)info.get("password");
                    pwd = password.toCharArray();
                    this.db_url = url;
                    URI root = URI.create(this.db_url);
                    JDBCSessionType jdbcSessionType = new JDBCSessionType();
                    JDBCClient client = new JDBCClient(jdbcSessionType);
                    String sessionInfo_name = "jdbc_session";
                    SessionInfo jdbc_sessionInfo = new SessionInfo(sessionInfo_name, root, null, user, pwd);
                    SessionCreator sessionCreator = SessionCreator.createSessionCreator((Client)client);
                    this.jdbcSession = sessionCreator.createSession(jdbc_sessionInfo);
                    break block16;
                }
                String oci_profile_name = null;
                String oci_config_file_path = "~/.oci/config";
                String region_value = null;
                if (info.containsKey(oci_profile)) {
                    oci_profile_name = info.getProperty("oci_profile");
                    if (info.containsKey(oci_config_filepath)) {
                        oci_config_file_path = info.getProperty("oci_config_filepath");
                    }
                    if (info.getProperty("region") != null) {
                        region_value = info.getProperty("region");
                    }
                }
                OCIProfiles profiles = new OCIProfiles();
                Properties pProps = profiles.getProperties();
                region_value = pProps.getProperty(oci_profile_name + "/region");
                this.db_url = this.generateOCIurl(region_value, this.full_url);
                URI root = URI.create(this.db_url);
                try {
                    this.ociRESTClient = new OCIProfiles().getOciClient(oci_profile_name);
                    isOCIConnection = this.isOCIConnect();
                    if (!isOCIConnection) {
                        throw new SQLException("Connection Failed! \n");
                    }
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new SQLException(e);
                }
            }
            catch (IOException | SessionException e) {
                if (this.debug) {
                    e.printStackTrace();
                }
                if (!url.startsWith("jdbc:oraclerest")) {
                    throw new SQLException(RestjdbcResources.get("RESTJDBC_008"), e);
                }
                throw new SQLException(RestjdbcResources.get("RESTJDBC_009"), e);
            }
        }
    }

    protected String generateOCIurl(String region, String ocid) {
        if (!((String)ocid).endsWith("/")) {
            ocid = (String)ocid + "/";
        }
        Object url = "https://";
        url = region.contains("r1") ? (String)url + "test-04." : (String)url + "sql.dbtools.";
        url = region.contains(".") ? (String)url + region + "/20201005/ords/" + (String)ocid : (String)url + region + ".oci.oraclecloud.com/20201005/ords/" + (String)ocid;
        return url;
    }

    protected boolean isOCIConnect() throws IOException, SQLException, UnknownHostException, GeneralSecurityException {
        String sql = "select 1 from dual";
        StringBuilder uri = new StringBuilder();
        uri.append(this.db_url);
        uri.append(ADHOC_ENDPOINT);
        URI root = URI.create(uri.toString());
        Writer postWriter = this.generatePost(sql);
        OCIRESTClient client = this.getOCIRESTClient();
        OCIRequest request = new OCIRequest.Builder().host(root.getHost()).method("post").body(postWriter.toString()).target(root.getPath()).contentType("application/json").build();
        CloseableHttpResponse response = client.getResponse(request);
        if (response.getCode() == 404) {
            throw new SQLException(RestjdbcResources.format("OCI_RESOURCE_NOT_FOUND", new Object[0]));
        }
        return response.getCode() == 200;
    }

    protected String getTimeZoneID() throws SQLException {
        String timeZoneID = null;
        try {
            String sql = "select 1 from dual";
            StringBuilder uri = new StringBuilder();
            uri.append(this.db_url);
            uri.append(ADHOC_ENDPOINT);
            URI root = URI.create(uri.toString());
            CloseableHttpResponse response = null;
            Writer postWriter = this.generatePost(sql);
            if (basic_auth) {
                Session session = this.jdbcSession;
                HttpPost post = session.createPost(root);
                post.addHeader("Content-Type", (Object)"application/json");
                post.setEntity((HttpEntity)new StringEntity(postWriter.toString()));
                response = session.executeRequest((HttpUriRequest)post);
                if (response == null) {
                    throw new SQLException(RestjdbcResources.get("RESTJDBC_025"));
                }
            } else {
                OCIRequest request;
                OCIRESTClient client = this.getOCIRESTClient();
                response = client.getResponse(request = new OCIRequest.Builder().host(root.getHost()).method("post").body(postWriter.toString()).target(root.getPath()).contentType("application/json").build());
                if (response == null) {
                    throw new SQLException(RestjdbcResources.get("RESTJDBC_026"));
                }
            }
            TreeNode node = this.createJsonNode(response);
            this.handleErrors(node);
            JrsString s = (JrsString)node.get("env").get("defaultTimeZone");
            timeZoneID = s.getValue();
        }
        catch (IOException | IllegalStateException | GeneralSecurityException | SessionException e) {
            this.logger.log(Level.SEVERE, e.getMessage());
        }
        return timeZoneID;
    }

    public String getDriverName() {
        return DRIVER_NAME;
    }

    private Writer generatePost(String sql) throws SQLException, IOException {
        JsonFactory f = new JsonFactory();
        StringWriter writer = new StringWriter();
        JsonGenerator g = f.createGenerator((Writer)writer);
        g.writeStartObject();
        g.writeStringField("statementText", sql);
        g.writeNumberField("offset", 0);
        g.writeNumberField("limit", 25);
        g.writeEndObject();
        g.close();
        return writer;
    }

    protected void handleErrors(TreeNode node) throws SQLException {
        if (node.get("errorCode") != null) {
            JrsNumber n = (JrsNumber)node.get("errorCode");
            int errorCode = n.getValue().intValue();
            JrsString s = (JrsString)node.get("errorDetails");
            String error_details = s.getValue();
            throw new SQLException(error_details, SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        if (node.get("error") != null) {
            JrsString s = (JrsString)node.get("error");
            throw new SQLException(s.getValue());
        }
    }

    protected TreeNode createJsonNode(CloseableHttpResponse response) throws SQLException {
        HttpEntity entity = response.getEntity();
        JSON json = JSON.builder().treeCodec((TreeCodec)new JacksonJrsTreeCodec()).build();
        TreeNode node = null;
        try {
            InputStream is = entity.getContent();
            node = json.treeFrom((Object)is);
        }
        catch (Exception e) {
            this.logger.severe(e.getMessage());
            int errorCode = 17001;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
        return node;
    }

    @Override
    public java.sql.Statement createStatement() throws SQLException {
        this.ensureOpen();
        return new Statement(this);
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql) throws SQLException {
        return new PreparedStatement(this, sql);
    }

    public Connection getConnection() {
        if (isOCIConnection) {
            return this;
        }
        return null;
    }

    protected Session getSession() {
        return this.jdbcSession;
    }

    protected OCIRESTClient getOCIRESTClient() {
        return this.ociRESTClient;
    }

    public String getUri() {
        return this.db_url;
    }

    protected String getOauth2Token() {
        return this.token;
    }

    @Override
    public void close() throws SQLException {
        if (basic_auth) {
            this.jdbcSession.close();
        }
        this.info = null;
        this.isClosed = true;
    }

    private void ensureOpen() throws SQLException {
        if (this.isClosed) {
            int errorCode = 17008;
            throw new SQLException(ExceptionUtil.getErrorMessage(errorCode), SQLStateMapping.getSQLState(errorCode), errorCode);
        }
    }

    @Override
    public java.sql.CallableStatement prepareCall(String sql) throws SQLException {
        this.ensureOpen();
        return new CallableStatement(this, sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", "nativeSQL(String sql)", this.getClass().getSimpleName()));
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.ensureOpen();
        return true;
    }

    @Override
    public void commit() throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void rollback() throws SQLException {
        this.ensureOpen();
        LogUtil.logOrException(this, null, "Rollback not supported (REST connection autocommits) - likely to be an error", null);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public java.sql.DatabaseMetaData getMetaData() throws SQLException {
        this.ensureOpen();
        if (this.databaseMetaData == null) {
            this.databaseMetaData = new DatabaseMetaData(this);
        }
        return this.databaseMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        SQLWarning retVal = null;
        if (!this.muteWarnings) {
            if (this.sqlWarn != null) {
                retVal = this.sqlWarn;
            } else {
                java.sql.Statement st = null;
                java.sql.ResultSet rs = null;
                try {
                    st = this.createStatement();
                    rs = st.executeQuery("select account_status, case when expiry_date is null then 1 else 0 end ifnull,  case when expiry_date is null then null else TO_CHAR(ROUND(expiry_date - sysdate)) end daysleft from user_users where username=user");
                    if (rs.next()) {
                        String status = rs.getString(1);
                        int wasNull = rs.getInt(2);
                        String howLong = rs.getString(3);
                        if (status.trim().equals("EXPIRED(GRACE)")) {
                            if (wasNull == 1) {
                                this.sqlWarn = new SQLWarning(RestjdbcSqlWarnings.getString("WARN_28011"), "99999", 28011);
                            } else {
                                if (howLong.equals("0")) {
                                    howLong = "1";
                                }
                                this.sqlWarn = new SQLWarning(RestjdbcSqlWarnings.format("WARN_28002", howLong), "99999", 28002);
                            }
                            retVal = this.sqlWarn;
                        } else {
                            this.muteWarnings = true;
                        }
                    } else {
                        this.muteWarnings = true;
                    }
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e) {
                            this.logger.log(Level.INFO, e.getCause().toString());
                        }
                    }
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (SQLException e) {
                            this.logger.log(Level.INFO, e.getCause().toString());
                        }
                    }
                }
            }
        }
        return retVal;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureOpen();
        this.muteWarnings = true;
    }

    @Override
    public Clob createClob() throws SQLException {
        this.ensureOpen();
        return new CLOB();
    }

    @Override
    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.ensureOpen();
        LogUtil.logOrException(this, Level.INFO, this.exceptionLogMessage(true, "createStatement(int resultSetType, int resultSetConcurrency)"), new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "createStatement(int resultSetType, int resultSetConcurrency)", this.getClass().getSimpleName())));
        return null;
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.ensureOpen();
        if (resultSetType == 1003 && resultSetConcurrency == 1007) {
            return new PreparedStatement(this, sql);
        }
        throw new SQLFeatureNotSupportedException("The REST JDBC driver only supports a FORWARD_ONLY and READ_ONLY ResultSet");
    }

    @Override
    public java.sql.CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.ensureOpen();
        LogUtil.logOrException(this, Level.INFO, this.exceptionLogMessage(true, "prepareCall(String sql, int resultSetType, int resultSetConcurrency)"), new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "prepareCall(String sql, int resultSetType, int resultSetConcurrency)", this.getClass().getSimpleName())));
        return null;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.ensureOpen();
        this.logger.info(RestjdbcResources.get("RESTJDBC_024"));
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "setHoldability(int holdability)", this.getClass().getSimpleName()));
    }

    @Override
    public int getHoldability() throws SQLException {
        this.ensureOpen();
        this.logger.info(RestjdbcResources.get("RESTJDBC_023"));
        this.logger.info(RestjdbcResources.get("RESTJDBC_024"));
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getHoldability()", this.getClass().getSimpleName()));
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.ensureOpen();
        this.logger.info(RestjdbcResources.get("RESTJDBC_022"));
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "setSavepoint()", this.getClass().getSimpleName()));
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.ensureOpen();
        this.logger.info(RestjdbcResources.get("RESTJDBC_022"));
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "setSavepoint(String name)", this.getClass().getSimpleName()));
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.ensureOpen();
        this.logger.info(RestjdbcResources.get("RESTJDBC_021"));
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "releaseSavepoint(Savepoint savepoint)", this.getClass().getSimpleName()));
    }

    @Override
    public java.sql.Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability)", this.getClass().getSimpleName()));
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability)", this.getClass().getSimpleName()));
    }

    @Override
    public java.sql.CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "prepareCall(String sql, int resultSetType,int resultSetConcurrency, int resultSetHoldability)", this.getClass().getSimpleName()));
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "prepareStatement(String sql, int autoGeneratedKeys)", this.getClass().getSimpleName()));
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "prepareStatement(String sql, int[] columnIndexes)", this.getClass().getSimpleName()));
    }

    @Override
    public java.sql.PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "prepareStatement(String sql, String[] columnNames)", this.getClass().getSimpleName()));
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getTypeMap()", this.getClass().getSimpleName()));
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "setTypeMap(Map<String, Class<?>> map)", this.getClass().getSimpleName()));
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.ensureOpen();
        return new BLOB();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "createNClob()", this.getClass().getSimpleName()));
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "createSQLXML()", this.getClass().getSimpleName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.ensureOpen();
        long start = Calendar.getInstance().getTimeInMillis();
        Long end = null;
        if (timeout < 0) {
            throw new SQLException("timeout is negative");
        }
        if (this.isClosed()) {
            return false;
        }
        java.sql.Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.createStatement();
            rs = (ResultSet)stmt.executeQuery("select 1 from dual");
            if (rs.next()) {
                end = Calendar.getInstance().getTimeInMillis();
            }
        }
        catch (SQLException e) {
            this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    this.logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
            if (timeout == 0 && end != null) {
                return true;
            }
            if (end != null && timeout != 0 && (long)(timeout * 1000) > end - start) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "setClientInfo(String name, String value)", this.getClass().getSimpleName()));
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.info = properties;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getClientInfo(String name)", this.getClass().getSimpleName()));
    }

    public Properties getInfo() {
        return this.info;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.ensureOpen();
        return this.info;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "createArrayOf(String typeName, Object[] elements)", this.getClass().getSimpleName()));
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "createStruct(String typeName, Object[] attributes)", this.getClass().getSimpleName()));
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "abort(Executor executor)", this.getClass().getSimpleName()));
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "setNetworkTimeout(Executor executor, int milliseconds)", this.getClass().getSimpleName()));
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getNetworkTimeout()", this.getClass().getSimpleName()));
    }

    public void setURL(String inURL) {
        this.full_url = inURL;
    }

    public String getURL() throws SQLException {
        return this.full_url;
    }

    @Override
    public String getSchema() throws SQLException {
        this.ensureOpen();
        try (java.sql.Statement s = this.createStatement();){
            String string;
            block12: {
                java.sql.ResultSet rs = s.executeQuery("select user from DUAL");
                try {
                    String string2 = string = rs.next() ? rs.getString(1) : null;
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return string;
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "setSchema(String schema)", this.getClass().getSimpleName()));
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "unwrap(Class<T> iface)", this.getClass().getSimpleName()));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "isWrapperFor(Class<T> iface)", this.getClass().getSimpleName()));
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.ensureOpen();
        this.readOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.ensureOpen();
        return this.readOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "setCatalog(String catalog)", this.getClass().getSimpleName()));
    }

    @Override
    public String getCatalog() throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getCatalog()", this.getClass().getSimpleName()));
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "setTransactionIsolation(int level)", this.getClass().getSimpleName()));
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.ensureOpen();
        throw new RestJdbcNotImplementedException(RestjdbcResources.format("RESTJDBC_UNSUPPORTED", "getTransactionIsolation()", this.getClass().getSimpleName()));
    }

    protected String exceptionLogMessage(boolean unsupport, String methodName) {
        if (unsupport) {
            return RestjdbcResources.format("RESTJDBC_UNSUPPORTED", methodName, this.getClass().getSimpleName());
        }
        return RestjdbcResources.format("RESTJDBC_NOTIMPLEMENTED", methodName, this.getClass().getSimpleName());
    }
}

