/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListRecommendedScheduledActionsRequest
extends BmcRequest<Void> {
    private String schedulingPolicyId;
    private String schedulingPolicyTargetResourceId;
    private PlanIntent planIntent;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getSchedulingPolicyId() {
        return this.schedulingPolicyId;
    }

    public String getSchedulingPolicyTargetResourceId() {
        return this.schedulingPolicyTargetResourceId;
    }

    public PlanIntent getPlanIntent() {
        return this.planIntent;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().schedulingPolicyId(this.schedulingPolicyId).schedulingPolicyTargetResourceId(this.schedulingPolicyTargetResourceId).planIntent(this.planIntent).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",schedulingPolicyId=").append(String.valueOf(this.schedulingPolicyId));
        sb.append(",schedulingPolicyTargetResourceId=").append(String.valueOf(this.schedulingPolicyTargetResourceId));
        sb.append(",planIntent=").append(String.valueOf((Object)this.planIntent));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListRecommendedScheduledActionsRequest)) {
            return false;
        }
        ListRecommendedScheduledActionsRequest other = (ListRecommendedScheduledActionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.schedulingPolicyId, other.schedulingPolicyId) && Objects.equals(this.schedulingPolicyTargetResourceId, other.schedulingPolicyTargetResourceId) && Objects.equals((Object)this.planIntent, (Object)other.planIntent) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.schedulingPolicyId == null ? 43 : this.schedulingPolicyId.hashCode());
        result = result * 59 + (this.schedulingPolicyTargetResourceId == null ? 43 : this.schedulingPolicyTargetResourceId.hashCode());
        result = result * 59 + (this.planIntent == null ? 43 : this.planIntent.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListRecommendedScheduledActionsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String schedulingPolicyId = null;
        private String schedulingPolicyTargetResourceId = null;
        private PlanIntent planIntent = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder schedulingPolicyId(String schedulingPolicyId) {
            this.schedulingPolicyId = schedulingPolicyId;
            return this;
        }

        public Builder schedulingPolicyTargetResourceId(String schedulingPolicyTargetResourceId) {
            this.schedulingPolicyTargetResourceId = schedulingPolicyTargetResourceId;
            return this;
        }

        public Builder planIntent(PlanIntent planIntent) {
            this.planIntent = planIntent;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListRecommendedScheduledActionsRequest o) {
            this.schedulingPolicyId(o.getSchedulingPolicyId());
            this.schedulingPolicyTargetResourceId(o.getSchedulingPolicyTargetResourceId());
            this.planIntent(o.getPlanIntent());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListRecommendedScheduledActionsRequest build() {
            ListRecommendedScheduledActionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListRecommendedScheduledActionsRequest buildWithoutInvocationCallback() {
            ListRecommendedScheduledActionsRequest request = new ListRecommendedScheduledActionsRequest();
            request.schedulingPolicyId = this.schedulingPolicyId;
            request.schedulingPolicyTargetResourceId = this.schedulingPolicyTargetResourceId;
            request.planIntent = this.planIntent;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum PlanIntent implements BmcEnum
    {
        ExadataInfrastructureFullSoftwareUpdate("EXADATA_INFRASTRUCTURE_FULL_SOFTWARE_UPDATE");

        private final String value;
        private static Map<String, PlanIntent> map;

        private PlanIntent(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PlanIntent create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid PlanIntent: " + key);
        }

        static {
            map = new HashMap<String, PlanIntent>();
            for (PlanIntent v : PlanIntent.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

