/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.PluggableDatabaseConnectionStrings;
import com.oracle.bmc.database.model.PluggableDatabaseManagementConfig;
import com.oracle.bmc.database.model.PluggableDatabaseNodeLevelDetails;
import com.oracle.bmc.database.model.PluggableDatabaseRefreshableCloneConfig;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PluggableDatabase
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="containerDatabaseId")
    private final String containerDatabaseId;
    @JsonProperty(value="pdbName")
    private final String pdbName;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="connectionStrings")
    private final PluggableDatabaseConnectionStrings connectionStrings;
    @JsonProperty(value="openMode")
    private final OpenMode openMode;
    @JsonProperty(value="isRestricted")
    private final Boolean isRestricted;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="pluggableDatabaseManagementConfig")
    private final PluggableDatabaseManagementConfig pluggableDatabaseManagementConfig;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="kmsKeyVersionId")
    private final String kmsKeyVersionId;
    @JsonProperty(value="refreshableCloneConfig")
    private final PluggableDatabaseRefreshableCloneConfig refreshableCloneConfig;
    @JsonProperty(value="pdbNodeLevelDetails")
    private final List<PluggableDatabaseNodeLevelDetails> pdbNodeLevelDetails;

    @Deprecated
    @ConstructorProperties(value={"id", "containerDatabaseId", "pdbName", "lifecycleState", "lifecycleDetails", "timeCreated", "connectionStrings", "openMode", "isRestricted", "compartmentId", "freeformTags", "definedTags", "pluggableDatabaseManagementConfig", "kmsKeyId", "kmsKeyVersionId", "refreshableCloneConfig", "pdbNodeLevelDetails"})
    public PluggableDatabase(String id, String containerDatabaseId, String pdbName, LifecycleState lifecycleState, String lifecycleDetails, Date timeCreated, PluggableDatabaseConnectionStrings connectionStrings, OpenMode openMode, Boolean isRestricted, String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, PluggableDatabaseManagementConfig pluggableDatabaseManagementConfig, String kmsKeyId, String kmsKeyVersionId, PluggableDatabaseRefreshableCloneConfig refreshableCloneConfig, List<PluggableDatabaseNodeLevelDetails> pdbNodeLevelDetails) {
        this.id = id;
        this.containerDatabaseId = containerDatabaseId;
        this.pdbName = pdbName;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.timeCreated = timeCreated;
        this.connectionStrings = connectionStrings;
        this.openMode = openMode;
        this.isRestricted = isRestricted;
        this.compartmentId = compartmentId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.pluggableDatabaseManagementConfig = pluggableDatabaseManagementConfig;
        this.kmsKeyId = kmsKeyId;
        this.kmsKeyVersionId = kmsKeyVersionId;
        this.refreshableCloneConfig = refreshableCloneConfig;
        this.pdbNodeLevelDetails = pdbNodeLevelDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getContainerDatabaseId() {
        return this.containerDatabaseId;
    }

    public String getPdbName() {
        return this.pdbName;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public PluggableDatabaseConnectionStrings getConnectionStrings() {
        return this.connectionStrings;
    }

    public OpenMode getOpenMode() {
        return this.openMode;
    }

    public Boolean getIsRestricted() {
        return this.isRestricted;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public PluggableDatabaseManagementConfig getPluggableDatabaseManagementConfig() {
        return this.pluggableDatabaseManagementConfig;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public String getKmsKeyVersionId() {
        return this.kmsKeyVersionId;
    }

    public PluggableDatabaseRefreshableCloneConfig getRefreshableCloneConfig() {
        return this.refreshableCloneConfig;
    }

    public List<PluggableDatabaseNodeLevelDetails> getPdbNodeLevelDetails() {
        return this.pdbNodeLevelDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PluggableDatabase(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", containerDatabaseId=").append(String.valueOf(this.containerDatabaseId));
        sb.append(", pdbName=").append(String.valueOf(this.pdbName));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", connectionStrings=").append(String.valueOf((Object)this.connectionStrings));
        sb.append(", openMode=").append(String.valueOf((Object)this.openMode));
        sb.append(", isRestricted=").append(String.valueOf(this.isRestricted));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", pluggableDatabaseManagementConfig=").append(String.valueOf((Object)this.pluggableDatabaseManagementConfig));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", kmsKeyVersionId=").append(String.valueOf(this.kmsKeyVersionId));
        sb.append(", refreshableCloneConfig=").append(String.valueOf((Object)this.refreshableCloneConfig));
        sb.append(", pdbNodeLevelDetails=").append(String.valueOf(this.pdbNodeLevelDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluggableDatabase)) {
            return false;
        }
        PluggableDatabase other = (PluggableDatabase)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.containerDatabaseId, other.containerDatabaseId) && Objects.equals(this.pdbName, other.pdbName) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.connectionStrings, (Object)other.connectionStrings) && Objects.equals((Object)this.openMode, (Object)other.openMode) && Objects.equals(this.isRestricted, other.isRestricted) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals((Object)this.pluggableDatabaseManagementConfig, (Object)other.pluggableDatabaseManagementConfig) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals(this.kmsKeyVersionId, other.kmsKeyVersionId) && Objects.equals((Object)this.refreshableCloneConfig, (Object)other.refreshableCloneConfig) && Objects.equals(this.pdbNodeLevelDetails, other.pdbNodeLevelDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.containerDatabaseId == null ? 43 : this.containerDatabaseId.hashCode());
        result = result * 59 + (this.pdbName == null ? 43 : this.pdbName.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.connectionStrings == null ? 43 : this.connectionStrings.hashCode());
        result = result * 59 + (this.openMode == null ? 43 : this.openMode.hashCode());
        result = result * 59 + (this.isRestricted == null ? 43 : this.isRestricted.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.pluggableDatabaseManagementConfig == null ? 43 : this.pluggableDatabaseManagementConfig.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.kmsKeyVersionId == null ? 43 : this.kmsKeyVersionId.hashCode());
        result = result * 59 + (this.refreshableCloneConfig == null ? 43 : this.refreshableCloneConfig.hashCode());
        result = result * 59 + (this.pdbNodeLevelDetails == null ? 43 : this.pdbNodeLevelDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum OpenMode implements BmcEnum
    {
        ReadOnly("READ_ONLY"),
        ReadWrite("READ_WRITE"),
        Mounted("MOUNTED"),
        Migrate("MIGRATE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OpenMode> map;

        private OpenMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OpenMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OpenMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OpenMode.class);
            map = new HashMap<String, OpenMode>();
            for (OpenMode v : OpenMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Available("AVAILABLE"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Updating("UPDATING"),
        Failed("FAILED"),
        Relocating("RELOCATING"),
        Relocated("RELOCATED"),
        Refreshing("REFRESHING"),
        RestoreInProgress("RESTORE_IN_PROGRESS"),
        RestoreFailed("RESTORE_FAILED"),
        BackupInProgress("BACKUP_IN_PROGRESS"),
        Disabled("DISABLED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="containerDatabaseId")
        private String containerDatabaseId;
        @JsonProperty(value="pdbName")
        private String pdbName;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="connectionStrings")
        private PluggableDatabaseConnectionStrings connectionStrings;
        @JsonProperty(value="openMode")
        private OpenMode openMode;
        @JsonProperty(value="isRestricted")
        private Boolean isRestricted;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="pluggableDatabaseManagementConfig")
        private PluggableDatabaseManagementConfig pluggableDatabaseManagementConfig;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="kmsKeyVersionId")
        private String kmsKeyVersionId;
        @JsonProperty(value="refreshableCloneConfig")
        private PluggableDatabaseRefreshableCloneConfig refreshableCloneConfig;
        @JsonProperty(value="pdbNodeLevelDetails")
        private List<PluggableDatabaseNodeLevelDetails> pdbNodeLevelDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder containerDatabaseId(String containerDatabaseId) {
            this.containerDatabaseId = containerDatabaseId;
            this.__explicitlySet__.add("containerDatabaseId");
            return this;
        }

        public Builder pdbName(String pdbName) {
            this.pdbName = pdbName;
            this.__explicitlySet__.add("pdbName");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder connectionStrings(PluggableDatabaseConnectionStrings connectionStrings) {
            this.connectionStrings = connectionStrings;
            this.__explicitlySet__.add("connectionStrings");
            return this;
        }

        public Builder openMode(OpenMode openMode) {
            this.openMode = openMode;
            this.__explicitlySet__.add("openMode");
            return this;
        }

        public Builder isRestricted(Boolean isRestricted) {
            this.isRestricted = isRestricted;
            this.__explicitlySet__.add("isRestricted");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder pluggableDatabaseManagementConfig(PluggableDatabaseManagementConfig pluggableDatabaseManagementConfig) {
            this.pluggableDatabaseManagementConfig = pluggableDatabaseManagementConfig;
            this.__explicitlySet__.add("pluggableDatabaseManagementConfig");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder kmsKeyVersionId(String kmsKeyVersionId) {
            this.kmsKeyVersionId = kmsKeyVersionId;
            this.__explicitlySet__.add("kmsKeyVersionId");
            return this;
        }

        public Builder refreshableCloneConfig(PluggableDatabaseRefreshableCloneConfig refreshableCloneConfig) {
            this.refreshableCloneConfig = refreshableCloneConfig;
            this.__explicitlySet__.add("refreshableCloneConfig");
            return this;
        }

        public Builder pdbNodeLevelDetails(List<PluggableDatabaseNodeLevelDetails> pdbNodeLevelDetails) {
            this.pdbNodeLevelDetails = pdbNodeLevelDetails;
            this.__explicitlySet__.add("pdbNodeLevelDetails");
            return this;
        }

        public PluggableDatabase build() {
            PluggableDatabase model = new PluggableDatabase(this.id, this.containerDatabaseId, this.pdbName, this.lifecycleState, this.lifecycleDetails, this.timeCreated, this.connectionStrings, this.openMode, this.isRestricted, this.compartmentId, this.freeformTags, this.definedTags, this.pluggableDatabaseManagementConfig, this.kmsKeyId, this.kmsKeyVersionId, this.refreshableCloneConfig, this.pdbNodeLevelDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PluggableDatabase model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("containerDatabaseId")) {
                this.containerDatabaseId(model.getContainerDatabaseId());
            }
            if (model.wasPropertyExplicitlySet("pdbName")) {
                this.pdbName(model.getPdbName());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("connectionStrings")) {
                this.connectionStrings(model.getConnectionStrings());
            }
            if (model.wasPropertyExplicitlySet("openMode")) {
                this.openMode(model.getOpenMode());
            }
            if (model.wasPropertyExplicitlySet("isRestricted")) {
                this.isRestricted(model.getIsRestricted());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("pluggableDatabaseManagementConfig")) {
                this.pluggableDatabaseManagementConfig(model.getPluggableDatabaseManagementConfig());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyVersionId")) {
                this.kmsKeyVersionId(model.getKmsKeyVersionId());
            }
            if (model.wasPropertyExplicitlySet("refreshableCloneConfig")) {
                this.refreshableCloneConfig(model.getRefreshableCloneConfig());
            }
            if (model.wasPropertyExplicitlySet("pdbNodeLevelDetails")) {
                this.pdbNodeLevelDetails(model.getPdbNodeLevelDetails());
            }
            return this;
        }
    }
}

