/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.database.model.DbServerPatchingDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DbServer
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="exadataInfrastructureId")
    private final String exadataInfrastructureId;
    @JsonProperty(value="cpuCoreCount")
    private final Integer cpuCoreCount;
    @JsonProperty(value="memorySizeInGBs")
    private final Integer memorySizeInGBs;
    @JsonProperty(value="dbNodeStorageSizeInGBs")
    private final Integer dbNodeStorageSizeInGBs;
    @JsonProperty(value="vmClusterIds")
    private final List<String> vmClusterIds;
    @JsonProperty(value="autonomousVmClusterIds")
    private final List<String> autonomousVmClusterIds;
    @JsonProperty(value="autonomousVirtualMachineIds")
    private final List<String> autonomousVirtualMachineIds;
    @JsonProperty(value="dbNodeIds")
    private final List<String> dbNodeIds;
    @JsonProperty(value="shape")
    private final String shape;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="maxCpuCount")
    private final Integer maxCpuCount;
    @JsonProperty(value="maxMemoryInGBs")
    private final Integer maxMemoryInGBs;
    @JsonProperty(value="maxDbNodeStorageInGBs")
    private final Integer maxDbNodeStorageInGBs;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="dbServerPatchingDetails")
    private final DbServerPatchingDetails dbServerPatchingDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="computeModel")
    private final ComputeModel computeModel;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "compartmentId", "exadataInfrastructureId", "cpuCoreCount", "memorySizeInGBs", "dbNodeStorageSizeInGBs", "vmClusterIds", "autonomousVmClusterIds", "autonomousVirtualMachineIds", "dbNodeIds", "shape", "lifecycleState", "lifecycleDetails", "maxCpuCount", "maxMemoryInGBs", "maxDbNodeStorageInGBs", "timeCreated", "dbServerPatchingDetails", "freeformTags", "definedTags", "computeModel"})
    public DbServer(String id, String displayName, String compartmentId, String exadataInfrastructureId, Integer cpuCoreCount, Integer memorySizeInGBs, Integer dbNodeStorageSizeInGBs, List<String> vmClusterIds, List<String> autonomousVmClusterIds, List<String> autonomousVirtualMachineIds, List<String> dbNodeIds, String shape, LifecycleState lifecycleState, String lifecycleDetails, Integer maxCpuCount, Integer maxMemoryInGBs, Integer maxDbNodeStorageInGBs, Date timeCreated, DbServerPatchingDetails dbServerPatchingDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, ComputeModel computeModel) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.exadataInfrastructureId = exadataInfrastructureId;
        this.cpuCoreCount = cpuCoreCount;
        this.memorySizeInGBs = memorySizeInGBs;
        this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        this.vmClusterIds = vmClusterIds;
        this.autonomousVmClusterIds = autonomousVmClusterIds;
        this.autonomousVirtualMachineIds = autonomousVirtualMachineIds;
        this.dbNodeIds = dbNodeIds;
        this.shape = shape;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.maxCpuCount = maxCpuCount;
        this.maxMemoryInGBs = maxMemoryInGBs;
        this.maxDbNodeStorageInGBs = maxDbNodeStorageInGBs;
        this.timeCreated = timeCreated;
        this.dbServerPatchingDetails = dbServerPatchingDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.computeModel = computeModel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getExadataInfrastructureId() {
        return this.exadataInfrastructureId;
    }

    public Integer getCpuCoreCount() {
        return this.cpuCoreCount;
    }

    public Integer getMemorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public Integer getDbNodeStorageSizeInGBs() {
        return this.dbNodeStorageSizeInGBs;
    }

    public List<String> getVmClusterIds() {
        return this.vmClusterIds;
    }

    public List<String> getAutonomousVmClusterIds() {
        return this.autonomousVmClusterIds;
    }

    public List<String> getAutonomousVirtualMachineIds() {
        return this.autonomousVirtualMachineIds;
    }

    public List<String> getDbNodeIds() {
        return this.dbNodeIds;
    }

    public String getShape() {
        return this.shape;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Integer getMaxCpuCount() {
        return this.maxCpuCount;
    }

    public Integer getMaxMemoryInGBs() {
        return this.maxMemoryInGBs;
    }

    public Integer getMaxDbNodeStorageInGBs() {
        return this.maxDbNodeStorageInGBs;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public DbServerPatchingDetails getDbServerPatchingDetails() {
        return this.dbServerPatchingDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public ComputeModel getComputeModel() {
        return this.computeModel;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DbServer(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", exadataInfrastructureId=").append(String.valueOf(this.exadataInfrastructureId));
        sb.append(", cpuCoreCount=").append(String.valueOf(this.cpuCoreCount));
        sb.append(", memorySizeInGBs=").append(String.valueOf(this.memorySizeInGBs));
        sb.append(", dbNodeStorageSizeInGBs=").append(String.valueOf(this.dbNodeStorageSizeInGBs));
        sb.append(", vmClusterIds=").append(String.valueOf(this.vmClusterIds));
        sb.append(", autonomousVmClusterIds=").append(String.valueOf(this.autonomousVmClusterIds));
        sb.append(", autonomousVirtualMachineIds=").append(String.valueOf(this.autonomousVirtualMachineIds));
        sb.append(", dbNodeIds=").append(String.valueOf(this.dbNodeIds));
        sb.append(", shape=").append(String.valueOf(this.shape));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", maxCpuCount=").append(String.valueOf(this.maxCpuCount));
        sb.append(", maxMemoryInGBs=").append(String.valueOf(this.maxMemoryInGBs));
        sb.append(", maxDbNodeStorageInGBs=").append(String.valueOf(this.maxDbNodeStorageInGBs));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", dbServerPatchingDetails=").append(String.valueOf((Object)this.dbServerPatchingDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", computeModel=").append(String.valueOf((Object)this.computeModel));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DbServer)) {
            return false;
        }
        DbServer other = (DbServer)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.exadataInfrastructureId, other.exadataInfrastructureId) && Objects.equals(this.cpuCoreCount, other.cpuCoreCount) && Objects.equals(this.memorySizeInGBs, other.memorySizeInGBs) && Objects.equals(this.dbNodeStorageSizeInGBs, other.dbNodeStorageSizeInGBs) && Objects.equals(this.vmClusterIds, other.vmClusterIds) && Objects.equals(this.autonomousVmClusterIds, other.autonomousVmClusterIds) && Objects.equals(this.autonomousVirtualMachineIds, other.autonomousVirtualMachineIds) && Objects.equals(this.dbNodeIds, other.dbNodeIds) && Objects.equals(this.shape, other.shape) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.maxCpuCount, other.maxCpuCount) && Objects.equals(this.maxMemoryInGBs, other.maxMemoryInGBs) && Objects.equals(this.maxDbNodeStorageInGBs, other.maxDbNodeStorageInGBs) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.dbServerPatchingDetails, (Object)other.dbServerPatchingDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals((Object)this.computeModel, (Object)other.computeModel) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.exadataInfrastructureId == null ? 43 : this.exadataInfrastructureId.hashCode());
        result = result * 59 + (this.cpuCoreCount == null ? 43 : this.cpuCoreCount.hashCode());
        result = result * 59 + (this.memorySizeInGBs == null ? 43 : this.memorySizeInGBs.hashCode());
        result = result * 59 + (this.dbNodeStorageSizeInGBs == null ? 43 : this.dbNodeStorageSizeInGBs.hashCode());
        result = result * 59 + (this.vmClusterIds == null ? 43 : this.vmClusterIds.hashCode());
        result = result * 59 + (this.autonomousVmClusterIds == null ? 43 : this.autonomousVmClusterIds.hashCode());
        result = result * 59 + (this.autonomousVirtualMachineIds == null ? 43 : this.autonomousVirtualMachineIds.hashCode());
        result = result * 59 + (this.dbNodeIds == null ? 43 : this.dbNodeIds.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.maxCpuCount == null ? 43 : this.maxCpuCount.hashCode());
        result = result * 59 + (this.maxMemoryInGBs == null ? 43 : this.maxMemoryInGBs.hashCode());
        result = result * 59 + (this.maxDbNodeStorageInGBs == null ? 43 : this.maxDbNodeStorageInGBs.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.dbServerPatchingDetails == null ? 43 : this.dbServerPatchingDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.computeModel == null ? 43 : this.computeModel.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ComputeModel implements BmcEnum
    {
        Ecpu("ECPU"),
        Ocpu("OCPU"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ComputeModel> map;

        private ComputeModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ComputeModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ComputeModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ComputeModel.class);
            map = new HashMap<String, ComputeModel>();
            for (ComputeModel v : ComputeModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Available("AVAILABLE"),
        Unavailable("UNAVAILABLE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        MaintenanceInProgress("MAINTENANCE_IN_PROGRESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="exadataInfrastructureId")
        private String exadataInfrastructureId;
        @JsonProperty(value="cpuCoreCount")
        private Integer cpuCoreCount;
        @JsonProperty(value="memorySizeInGBs")
        private Integer memorySizeInGBs;
        @JsonProperty(value="dbNodeStorageSizeInGBs")
        private Integer dbNodeStorageSizeInGBs;
        @JsonProperty(value="vmClusterIds")
        private List<String> vmClusterIds;
        @JsonProperty(value="autonomousVmClusterIds")
        private List<String> autonomousVmClusterIds;
        @JsonProperty(value="autonomousVirtualMachineIds")
        private List<String> autonomousVirtualMachineIds;
        @JsonProperty(value="dbNodeIds")
        private List<String> dbNodeIds;
        @JsonProperty(value="shape")
        private String shape;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="maxCpuCount")
        private Integer maxCpuCount;
        @JsonProperty(value="maxMemoryInGBs")
        private Integer maxMemoryInGBs;
        @JsonProperty(value="maxDbNodeStorageInGBs")
        private Integer maxDbNodeStorageInGBs;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="dbServerPatchingDetails")
        private DbServerPatchingDetails dbServerPatchingDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="computeModel")
        private ComputeModel computeModel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder exadataInfrastructureId(String exadataInfrastructureId) {
            this.exadataInfrastructureId = exadataInfrastructureId;
            this.__explicitlySet__.add("exadataInfrastructureId");
            return this;
        }

        public Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            this.__explicitlySet__.add("cpuCoreCount");
            return this;
        }

        public Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            this.__explicitlySet__.add("memorySizeInGBs");
            return this;
        }

        public Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            this.__explicitlySet__.add("dbNodeStorageSizeInGBs");
            return this;
        }

        public Builder vmClusterIds(List<String> vmClusterIds) {
            this.vmClusterIds = vmClusterIds;
            this.__explicitlySet__.add("vmClusterIds");
            return this;
        }

        public Builder autonomousVmClusterIds(List<String> autonomousVmClusterIds) {
            this.autonomousVmClusterIds = autonomousVmClusterIds;
            this.__explicitlySet__.add("autonomousVmClusterIds");
            return this;
        }

        public Builder autonomousVirtualMachineIds(List<String> autonomousVirtualMachineIds) {
            this.autonomousVirtualMachineIds = autonomousVirtualMachineIds;
            this.__explicitlySet__.add("autonomousVirtualMachineIds");
            return this;
        }

        public Builder dbNodeIds(List<String> dbNodeIds) {
            this.dbNodeIds = dbNodeIds;
            this.__explicitlySet__.add("dbNodeIds");
            return this;
        }

        public Builder shape(String shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder maxCpuCount(Integer maxCpuCount) {
            this.maxCpuCount = maxCpuCount;
            this.__explicitlySet__.add("maxCpuCount");
            return this;
        }

        public Builder maxMemoryInGBs(Integer maxMemoryInGBs) {
            this.maxMemoryInGBs = maxMemoryInGBs;
            this.__explicitlySet__.add("maxMemoryInGBs");
            return this;
        }

        public Builder maxDbNodeStorageInGBs(Integer maxDbNodeStorageInGBs) {
            this.maxDbNodeStorageInGBs = maxDbNodeStorageInGBs;
            this.__explicitlySet__.add("maxDbNodeStorageInGBs");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder dbServerPatchingDetails(DbServerPatchingDetails dbServerPatchingDetails) {
            this.dbServerPatchingDetails = dbServerPatchingDetails;
            this.__explicitlySet__.add("dbServerPatchingDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder computeModel(ComputeModel computeModel) {
            this.computeModel = computeModel;
            this.__explicitlySet__.add("computeModel");
            return this;
        }

        public DbServer build() {
            DbServer model = new DbServer(this.id, this.displayName, this.compartmentId, this.exadataInfrastructureId, this.cpuCoreCount, this.memorySizeInGBs, this.dbNodeStorageSizeInGBs, this.vmClusterIds, this.autonomousVmClusterIds, this.autonomousVirtualMachineIds, this.dbNodeIds, this.shape, this.lifecycleState, this.lifecycleDetails, this.maxCpuCount, this.maxMemoryInGBs, this.maxDbNodeStorageInGBs, this.timeCreated, this.dbServerPatchingDetails, this.freeformTags, this.definedTags, this.computeModel);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DbServer model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("exadataInfrastructureId")) {
                this.exadataInfrastructureId(model.getExadataInfrastructureId());
            }
            if (model.wasPropertyExplicitlySet("cpuCoreCount")) {
                this.cpuCoreCount(model.getCpuCoreCount());
            }
            if (model.wasPropertyExplicitlySet("memorySizeInGBs")) {
                this.memorySizeInGBs(model.getMemorySizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("dbNodeStorageSizeInGBs")) {
                this.dbNodeStorageSizeInGBs(model.getDbNodeStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("vmClusterIds")) {
                this.vmClusterIds(model.getVmClusterIds());
            }
            if (model.wasPropertyExplicitlySet("autonomousVmClusterIds")) {
                this.autonomousVmClusterIds(model.getAutonomousVmClusterIds());
            }
            if (model.wasPropertyExplicitlySet("autonomousVirtualMachineIds")) {
                this.autonomousVirtualMachineIds(model.getAutonomousVirtualMachineIds());
            }
            if (model.wasPropertyExplicitlySet("dbNodeIds")) {
                this.dbNodeIds(model.getDbNodeIds());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("maxCpuCount")) {
                this.maxCpuCount(model.getMaxCpuCount());
            }
            if (model.wasPropertyExplicitlySet("maxMemoryInGBs")) {
                this.maxMemoryInGBs(model.getMaxMemoryInGBs());
            }
            if (model.wasPropertyExplicitlySet("maxDbNodeStorageInGBs")) {
                this.maxDbNodeStorageInGBs(model.getMaxDbNodeStorageInGBs());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("dbServerPatchingDetails")) {
                this.dbServerPatchingDetails(model.getDbServerPatchingDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("computeModel")) {
                this.computeModel(model.getComputeModel());
            }
            return this;
        }
    }
}

