/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateDatabaseSoftwareImageDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="databaseVersion")
    private final String databaseVersion;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="imageShapeFamily")
    private final ImageShapeFamily imageShapeFamily;
    @JsonProperty(value="imageType")
    private final ImageType imageType;
    @JsonProperty(value="patchSet")
    private final String patchSet;
    @JsonProperty(value="databaseSoftwareImageOneOffPatches")
    private final List<String> databaseSoftwareImageOneOffPatches;
    @JsonProperty(value="lsInventory")
    private final String lsInventory;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="sourceDbHomeId")
    private final String sourceDbHomeId;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "databaseVersion", "displayName", "imageShapeFamily", "imageType", "patchSet", "databaseSoftwareImageOneOffPatches", "lsInventory", "freeformTags", "definedTags", "sourceDbHomeId"})
    public CreateDatabaseSoftwareImageDetails(String compartmentId, String databaseVersion, String displayName, ImageShapeFamily imageShapeFamily, ImageType imageType, String patchSet, List<String> databaseSoftwareImageOneOffPatches, String lsInventory, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String sourceDbHomeId) {
        this.compartmentId = compartmentId;
        this.databaseVersion = databaseVersion;
        this.displayName = displayName;
        this.imageShapeFamily = imageShapeFamily;
        this.imageType = imageType;
        this.patchSet = patchSet;
        this.databaseSoftwareImageOneOffPatches = databaseSoftwareImageOneOffPatches;
        this.lsInventory = lsInventory;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.sourceDbHomeId = sourceDbHomeId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDatabaseVersion() {
        return this.databaseVersion;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ImageShapeFamily getImageShapeFamily() {
        return this.imageShapeFamily;
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    public String getPatchSet() {
        return this.patchSet;
    }

    public List<String> getDatabaseSoftwareImageOneOffPatches() {
        return this.databaseSoftwareImageOneOffPatches;
    }

    public String getLsInventory() {
        return this.lsInventory;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getSourceDbHomeId() {
        return this.sourceDbHomeId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateDatabaseSoftwareImageDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", databaseVersion=").append(String.valueOf(this.databaseVersion));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", imageShapeFamily=").append(String.valueOf((Object)this.imageShapeFamily));
        sb.append(", imageType=").append(String.valueOf((Object)this.imageType));
        sb.append(", patchSet=").append(String.valueOf(this.patchSet));
        sb.append(", databaseSoftwareImageOneOffPatches=").append(String.valueOf(this.databaseSoftwareImageOneOffPatches));
        sb.append(", lsInventory=").append(String.valueOf(this.lsInventory));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", sourceDbHomeId=").append(String.valueOf(this.sourceDbHomeId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDatabaseSoftwareImageDetails)) {
            return false;
        }
        CreateDatabaseSoftwareImageDetails other = (CreateDatabaseSoftwareImageDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.databaseVersion, other.databaseVersion) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.imageShapeFamily, (Object)other.imageShapeFamily) && Objects.equals((Object)this.imageType, (Object)other.imageType) && Objects.equals(this.patchSet, other.patchSet) && Objects.equals(this.databaseSoftwareImageOneOffPatches, other.databaseSoftwareImageOneOffPatches) && Objects.equals(this.lsInventory, other.lsInventory) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.sourceDbHomeId, other.sourceDbHomeId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.databaseVersion == null ? 43 : this.databaseVersion.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.imageShapeFamily == null ? 43 : this.imageShapeFamily.hashCode());
        result = result * 59 + (this.imageType == null ? 43 : this.imageType.hashCode());
        result = result * 59 + (this.patchSet == null ? 43 : this.patchSet.hashCode());
        result = result * 59 + (this.databaseSoftwareImageOneOffPatches == null ? 43 : this.databaseSoftwareImageOneOffPatches.hashCode());
        result = result * 59 + (this.lsInventory == null ? 43 : this.lsInventory.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.sourceDbHomeId == null ? 43 : this.sourceDbHomeId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ImageType implements BmcEnum
    {
        GridImage("GRID_IMAGE"),
        DatabaseImage("DATABASE_IMAGE");

        private final String value;
        private static Map<String, ImageType> map;

        private ImageType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ImageType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ImageType: " + key);
        }

        static {
            map = new HashMap<String, ImageType>();
            for (ImageType v : ImageType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ImageShapeFamily implements BmcEnum
    {
        VmBmShape("VM_BM_SHAPE"),
        ExadataShape("EXADATA_SHAPE"),
        ExaccShape("EXACC_SHAPE"),
        ExadbxsShape("EXADBXS_SHAPE");

        private final String value;
        private static Map<String, ImageShapeFamily> map;

        private ImageShapeFamily(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ImageShapeFamily create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ImageShapeFamily: " + key);
        }

        static {
            map = new HashMap<String, ImageShapeFamily>();
            for (ImageShapeFamily v : ImageShapeFamily.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="databaseVersion")
        private String databaseVersion;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="imageShapeFamily")
        private ImageShapeFamily imageShapeFamily;
        @JsonProperty(value="imageType")
        private ImageType imageType;
        @JsonProperty(value="patchSet")
        private String patchSet;
        @JsonProperty(value="databaseSoftwareImageOneOffPatches")
        private List<String> databaseSoftwareImageOneOffPatches;
        @JsonProperty(value="lsInventory")
        private String lsInventory;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="sourceDbHomeId")
        private String sourceDbHomeId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder databaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
            this.__explicitlySet__.add("databaseVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder imageShapeFamily(ImageShapeFamily imageShapeFamily) {
            this.imageShapeFamily = imageShapeFamily;
            this.__explicitlySet__.add("imageShapeFamily");
            return this;
        }

        public Builder imageType(ImageType imageType) {
            this.imageType = imageType;
            this.__explicitlySet__.add("imageType");
            return this;
        }

        public Builder patchSet(String patchSet) {
            this.patchSet = patchSet;
            this.__explicitlySet__.add("patchSet");
            return this;
        }

        public Builder databaseSoftwareImageOneOffPatches(List<String> databaseSoftwareImageOneOffPatches) {
            this.databaseSoftwareImageOneOffPatches = databaseSoftwareImageOneOffPatches;
            this.__explicitlySet__.add("databaseSoftwareImageOneOffPatches");
            return this;
        }

        public Builder lsInventory(String lsInventory) {
            this.lsInventory = lsInventory;
            this.__explicitlySet__.add("lsInventory");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder sourceDbHomeId(String sourceDbHomeId) {
            this.sourceDbHomeId = sourceDbHomeId;
            this.__explicitlySet__.add("sourceDbHomeId");
            return this;
        }

        public CreateDatabaseSoftwareImageDetails build() {
            CreateDatabaseSoftwareImageDetails model = new CreateDatabaseSoftwareImageDetails(this.compartmentId, this.databaseVersion, this.displayName, this.imageShapeFamily, this.imageType, this.patchSet, this.databaseSoftwareImageOneOffPatches, this.lsInventory, this.freeformTags, this.definedTags, this.sourceDbHomeId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateDatabaseSoftwareImageDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("databaseVersion")) {
                this.databaseVersion(model.getDatabaseVersion());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("imageShapeFamily")) {
                this.imageShapeFamily(model.getImageShapeFamily());
            }
            if (model.wasPropertyExplicitlySet("imageType")) {
                this.imageType(model.getImageType());
            }
            if (model.wasPropertyExplicitlySet("patchSet")) {
                this.patchSet(model.getPatchSet());
            }
            if (model.wasPropertyExplicitlySet("databaseSoftwareImageOneOffPatches")) {
                this.databaseSoftwareImageOneOffPatches(model.getDatabaseSoftwareImageOneOffPatches());
            }
            if (model.wasPropertyExplicitlySet("lsInventory")) {
                this.lsInventory(model.getLsInventory());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("sourceDbHomeId")) {
                this.sourceDbHomeId(model.getSourceDbHomeId());
            }
            return this;
        }
    }
}

