/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ActionParamValuesSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="parameterName")
    private final String parameterName;
    @JsonProperty(value="parameterType")
    private final ParameterType parameterType;
    @JsonProperty(value="parameterValues")
    private final List<String> parameterValues;
    @JsonProperty(value="defaultValue")
    private final String defaultValue;
    @JsonProperty(value="isRequired")
    private final Boolean isRequired;

    @Deprecated
    @ConstructorProperties(value={"parameterName", "parameterType", "parameterValues", "defaultValue", "isRequired"})
    public ActionParamValuesSummary(String parameterName, ParameterType parameterType, List<String> parameterValues, String defaultValue, Boolean isRequired) {
        this.parameterName = parameterName;
        this.parameterType = parameterType;
        this.parameterValues = parameterValues;
        this.defaultValue = defaultValue;
        this.isRequired = isRequired;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public ParameterType getParameterType() {
        return this.parameterType;
    }

    public List<String> getParameterValues() {
        return this.parameterValues;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Boolean getIsRequired() {
        return this.isRequired;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ActionParamValuesSummary(");
        sb.append("super=").append(super.toString());
        sb.append("parameterName=").append(String.valueOf(this.parameterName));
        sb.append(", parameterType=").append(String.valueOf((Object)this.parameterType));
        sb.append(", parameterValues=").append(String.valueOf(this.parameterValues));
        sb.append(", defaultValue=").append(String.valueOf(this.defaultValue));
        sb.append(", isRequired=").append(String.valueOf(this.isRequired));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActionParamValuesSummary)) {
            return false;
        }
        ActionParamValuesSummary other = (ActionParamValuesSummary)((Object)o);
        return Objects.equals(this.parameterName, other.parameterName) && Objects.equals((Object)this.parameterType, (Object)other.parameterType) && Objects.equals(this.parameterValues, other.parameterValues) && Objects.equals(this.defaultValue, other.defaultValue) && Objects.equals(this.isRequired, other.isRequired) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.parameterName == null ? 43 : this.parameterName.hashCode());
        result = result * 59 + (this.parameterType == null ? 43 : this.parameterType.hashCode());
        result = result * 59 + (this.parameterValues == null ? 43 : this.parameterValues.hashCode());
        result = result * 59 + (this.defaultValue == null ? 43 : this.defaultValue.hashCode());
        result = result * 59 + (this.isRequired == null ? 43 : this.isRequired.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ParameterType implements BmcEnum
    {
        Boolean("BOOLEAN"),
        String("STRING"),
        Integer("INTEGER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ParameterType> map;

        private ParameterType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ParameterType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ParameterType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ParameterType.class);
            map = new HashMap<String, ParameterType>();
            for (ParameterType v : ParameterType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="parameterName")
        private String parameterName;
        @JsonProperty(value="parameterType")
        private ParameterType parameterType;
        @JsonProperty(value="parameterValues")
        private List<String> parameterValues;
        @JsonProperty(value="defaultValue")
        private String defaultValue;
        @JsonProperty(value="isRequired")
        private Boolean isRequired;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            this.__explicitlySet__.add("parameterName");
            return this;
        }

        public Builder parameterType(ParameterType parameterType) {
            this.parameterType = parameterType;
            this.__explicitlySet__.add("parameterType");
            return this;
        }

        public Builder parameterValues(List<String> parameterValues) {
            this.parameterValues = parameterValues;
            this.__explicitlySet__.add("parameterValues");
            return this;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            this.__explicitlySet__.add("defaultValue");
            return this;
        }

        public Builder isRequired(Boolean isRequired) {
            this.isRequired = isRequired;
            this.__explicitlySet__.add("isRequired");
            return this;
        }

        public ActionParamValuesSummary build() {
            ActionParamValuesSummary model = new ActionParamValuesSummary(this.parameterName, this.parameterType, this.parameterValues, this.defaultValue, this.isRequired);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ActionParamValuesSummary model) {
            if (model.wasPropertyExplicitlySet("parameterName")) {
                this.parameterName(model.getParameterName());
            }
            if (model.wasPropertyExplicitlySet("parameterType")) {
                this.parameterType(model.getParameterType());
            }
            if (model.wasPropertyExplicitlySet("parameterValues")) {
                this.parameterValues(model.getParameterValues());
            }
            if (model.wasPropertyExplicitlySet("defaultValue")) {
                this.defaultValue(model.getDefaultValue());
            }
            if (model.wasPropertyExplicitlySet("isRequired")) {
                this.isRequired(model.getIsRequired());
            }
            return this;
        }
    }
}

