/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.utility;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.apex.command.ApexOptions;
import oracle.dbtools.extension.apex.command.MutableCommand;
import oracle.dbtools.extension.apex.exceptions.AppNotInstalledException;
import oracle.dbtools.extension.apex.exceptions.InvalidApexExportException;
import oracle.dbtools.raptor.query.QueryXMLSupport;

public class QueryUtils {
    public static String _version = "";
    static QueryXMLSupport s_xml = null;

    public static synchronized QueryXMLSupport getXMLQueries() {
        if (s_xml == null) {
            s_xml = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(QueryUtils.class.getClassLoader(), "oracle/dbtools/extension/apex/xml/ApexCommandQueries.xml"));
        }
        return s_xml;
    }

    public static void loadAppDetail(Connection conn, MutableCommand command, BigDecimal appId) throws SQLException, InvalidApexExportException {
        if (appId == null) {
            throw new InvalidApexExportException();
        }
        PreparedStatement stmt = conn.prepareStatement(QueryUtils.getXMLQueries().getQuery("getAppDetails", conn).getSql());
        stmt.setBigDecimal(1, appId);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            command.setOptionValue(ApexOptions.Symbol.WORKSPACEID, result.getBigDecimal(1));
            if (command.getOptionValue(ApexOptions.Symbol.WORKSPACENAME) == null || command.getOptionValue(ApexOptions.Symbol.WORKSPACENAME).toString().length() <= 0) {
                command.setOptionValue(ApexOptions.Symbol.WORKSPACENAME, result.getString(2));
            }
            command.setOptionValue(ApexOptions.Symbol.APPLICATIONNAME, result.getString(3));
        }
        result.close();
        stmt.close();
    }

    public static boolean newApexVersion(Connection conn) throws AppNotInstalledException {
        String cleanversion;
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String version = dbUtil.executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("apex.version", conn).getSql());
        if (version == null || version.isEmpty()) {
            throw new AppNotInstalledException();
        }
        _version = cleanversion = version.replaceAll("-", "");
        Version source = new Version(cleanversion);
        return source.compareTo(new Version("19.2")) > 0;
    }
}

