/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.tns;

import oracle.dbtools.core.collections.Slice;
import oracle.dbtools.core.text.CharSequenceTrait;
import oracle.dbtools.core.tns.Token;

class TokenStream
extends Slice.Base<Token>
implements CharSequenceTrait {
    private static final TokenStream EMPTY = new TokenStream(Slice.empty());
    private final Slice.Immutable<Token> tokens;
    private transient String text;

    private TokenStream(Slice.Immutable<Token> tokens) {
        this.tokens = tokens;
    }

    static TokenStream of(Slice<? extends Token> tokens) {
        if (tokens instanceof TokenStream) {
            return (TokenStream)tokens;
        }
        if (tokens.isEmpty()) {
            return EMPTY;
        }
        return new TokenStream(Slice.Immutable.copyOf(tokens));
    }

    private static boolean isTrimmable(Token token) {
        return token.type == Token.Type.WHITESPACE || token.type == Token.Type.EOL;
    }

    @Override
    public Token get(int index) throws IndexOutOfBoundsException {
        return (Token)this.tokens.get(index);
    }

    @Override
    public int size() {
        return this.tokens.size();
    }

    public TokenStream slice() {
        return this;
    }

    public TokenStream slice(int offset, int length) {
        return TokenStream.of(this.tokens.slice(offset, length));
    }

    public TokenStream slice(int offset) {
        return this.slice(offset, this.tokens.size() - offset);
    }

    @Override
    public String toString() {
        if (this.text == null) {
            this.text = this.join();
        }
        return this.text;
    }

    public TokenStream trim() {
        int start;
        int length = this.size();
        for (start = 0; start < length && TokenStream.isTrimmable(this.get(start)); ++start) {
        }
        while (start < length && TokenStream.isTrimmable(this.get(length - 1))) {
            --length;
        }
        TokenStream trimmed = start > 0 || length < this.size() ? this.slice(start, length - start) : this;
        return trimmed;
    }
}

