/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.tns;

import java.util.Objects;
import oracle.dbtools.core.text.CharSequenceTrait;
import oracle.dbtools.core.tns.CodePointValidator;
import oracle.dbtools.core.tns.OracleConfiguration;

class Token
implements CharSequenceTrait {
    private static final String EOL = "\n";
    private static final String START_LIST = "(";
    private static final String END_LIST = ")";
    static final String EQ = "=";
    private static final String SEPARATOR = ",";
    final Type type;
    final OracleConfiguration.Position start;
    final String text;
    final transient String rendered;

    private Token(Builder builder) {
        this.type = builder.type;
        this.text = builder.text == null ? null : builder.text.toString();
        this.rendered = Token.render(builder.type, builder.text);
        this.start = builder.position;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static String escape(CharSequence text, int charToEscape) {
        StringBuilder buffer = new StringBuilder(text.length() + 8);
        text.codePoints().forEach(c -> {
            if (charToEscape == c) {
                buffer.appendCodePoint(92);
            } else if (92 == c) {
                buffer.appendCodePoint(92);
            }
            buffer.appendCodePoint(c);
        });
        return buffer.toString();
    }

    static String unescape(CharSequence text, int charToUnescape) {
        StringBuilder buffer = new StringBuilder(text.length());
        char[] chars = text.toString().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char next;
            char c = chars[i];
            boolean append = true;
            if ('\\' == c && ('\\' == (next = chars[i + 1]) || charToUnescape == next)) {
                append = false;
            }
            if (!append) continue;
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static String render(Type type, CharSequence text) {
        switch (type.ordinal()) {
            case 6: {
                return "#" + String.valueOf(text);
            }
            case 7: {
                return "'" + Token.escape(text, 39) + "'";
            }
            case 8: {
                return "\"" + Token.escape(text, 34) + "\"";
            }
            case 0: {
                return START_LIST;
            }
            case 1: {
                return END_LIST;
            }
            case 2: {
                return EQ;
            }
            case 4: {
                return SEPARATOR;
            }
            case 3: {
                return EOL;
            }
        }
        return text == null ? "" : text.toString();
    }

    boolean isValue() {
        return this.type.isValue();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        return this.type == token.type && Objects.equals(this.start, token.start) && Objects.equals(this.text, token.text);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.start, this.text});
    }

    @Override
    public String toString() {
        return this.rendered;
    }

    static final class Builder {
        private OracleConfiguration.Position position = OracleConfiguration.Position.of(0, 0);
        private Type type;
        private CharSequence text;

        private Builder() {
        }

        Builder position(OracleConfiguration.Position position) {
            Objects.requireNonNull(position);
            this.position = position;
            return this;
        }

        Builder type(Type type) {
            Objects.requireNonNull(type);
            this.type = type;
            return this;
        }

        Builder text(CharSequence text) {
            this.text = text;
            return this;
        }

        Token build() {
            return new Token(this);
        }
    }

    static enum Type {
        BEGIN_PAIR,
        END_PAIR,
        EQ,
        EOL,
        SEPARATOR,
        WHITESPACE(CodePointValidator.WHITESPACE),
        COMMENT(c -> c != 35),
        SINGLE_QUOTED_ATOM(CodePointValidator.NO_LINE_BREAKS),
        DOUBLE_QUOTED_ATOM(CodePointValidator.NO_LINE_BREAKS),
        UNQUOTED_ATOM(CodePointValidator.UNQUOTED);

        final CodePointValidator validator;

        private Type() {
            this(CodePointValidator.NO_VALUE);
        }

        private Type(CodePointValidator validator) {
            this.validator = validator;
        }

        boolean isValue() {
            return this == SINGLE_QUOTED_ATOM || this == DOUBLE_QUOTED_ATOM || this == UNQUOTED_ATOM;
        }
    }
}

