/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.tns;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import oracle.dbtools.core.io.Printable;
import oracle.dbtools.core.tns.OracleConfiguration;

public class TnsValidate {
    private final Printable output;
    private final Printable error;
    private int entryCount;
    private int errorCount;

    private TnsValidate(Builder builder) {
        this.error = builder.error;
        this.output = builder.output;
    }

    public static TnsValidate of(Appendable output, Appendable error) {
        return TnsValidate.builder().output(output).error(error).build();
    }

    public static void main(String ... args) throws Exception {
        Path path = Paths.get(args[0], new String[0]);
        TnsValidate validator = TnsValidate.of(System.out, System.err);
        validator.validate(path);
    }

    public static Builder builder() {
        return new Builder();
    }

    public void validate(Path path) throws IOException {
        try (BufferedReader content = Files.newBufferedReader(path);){
            this.validate(content);
        }
    }

    public void validate(Readable content) {
        Stream<OracleConfiguration.Entry> entries = OracleConfiguration.read(content);
        entries.forEach(entry -> {
            ++this.entryCount;
            if (entry.isValid()) {
                this.summarize((OracleConfiguration.Entry)entry);
            } else {
                this.report((OracleConfiguration.Entry)entry);
            }
        });
        this.summary();
    }

    private void summary() {
        this.output.format("Validated %d entries, finding %d errors", this.entryCount, this.errorCount);
    }

    private void report(OracleConfiguration.Entry entry) {
        OracleConfiguration.SyntaxError error = entry.error().error();
        String errorLine = entry.line(error.position());
        OracleConfiguration.Position position = error.position().plus(1, 1);
        CharSequence message = error.message();
        this.error.println(String.valueOf(position) + " " + String.valueOf(message));
        this.error.indent(2);
        this.error.println(errorLine);
        this.error.indent(2);
        this.error.indent(position.column() - 1);
        this.error.println("^");
        ++this.errorCount;
    }

    private void summarize(OracleConfiguration.Entry entry) {
    }

    public static final class Builder {
        private Printable error;
        private Printable output;

        private Builder() {
        }

        public Builder error(Appendable error) {
            this.error = Printable.of(error);
            return this;
        }

        public Builder output(Appendable output) {
            this.output = Printable.of(output);
            return this;
        }

        public TnsValidate build() {
            return new TnsValidate(this);
        }
    }
}

