/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.tns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.dbtools.core.collections.Slice;
import oracle.dbtools.core.io.InputOutputStreams;
import oracle.dbtools.core.text.CharSequenceTrait;
import oracle.dbtools.core.tns.EntryParser;
import oracle.dbtools.core.tns.Lexer;
import oracle.dbtools.core.tns.SyntaxErrors;
import oracle.dbtools.core.tns.Token;
import oracle.dbtools.core.tns.TokenStream;
import oracle.dbtools.core.util.Throwables;

public class OracleConfiguration {
    private final List<OracleConfiguration> elements;
    private final Name name;
    private final String value;

    private OracleConfiguration(Name name, String value, List<OracleConfiguration> elements) {
        this.name = name;
        this.value = value;
        this.elements = elements;
    }

    private OracleConfiguration(Builder builder) {
        this(builder.name, builder.value.length() == 0 ? null : builder.value.toString(), List.copyOf(builder.elements));
    }

    public static OracleConfiguration of(CharSequence content) {
        Builder builder = OracleConfiguration.builder();
        Stream<Entry> entries = OracleConfiguration.read(InputOutputStreams.instance().asReadable(content));
        entries.forEach(entry -> entry.add(builder));
        return builder.build();
    }

    public static Stream<Entry> read(Readable content) {
        return Entry.parser().parse(InputOutputStreams.instance().asReader(content));
    }

    private static void render(StringBuilder text, OracleConfiguration node, RenderMode renderMode) {
        ValueType valueType;
        boolean isRoot;
        Name name = node.name();
        boolean bl = isRoot = name == null;
        if (RenderMode.REGULAR == renderMode && !isRoot) {
            text.append('(');
        }
        if (!isRoot) {
            text.append(name);
            text.append('=');
        }
        if (ValueType.ATOM == (valueType = node.valueType())) {
            String value = node.value().strip();
            boolean requiresQuoting = OracleConfiguration.requiresQuoting(value);
            if (requiresQuoting) {
                text.append("\"");
                text.append(value);
                text.append("\"");
            } else {
                text.append(value);
            }
        } else {
            for (OracleConfiguration element : node.elements()) {
                RenderMode childRenderMode = RenderMode.FILE == renderMode && isRoot ? RenderMode.TOP_LEVEL : RenderMode.REGULAR;
                OracleConfiguration.render(text, element, childRenderMode);
            }
        }
        if (RenderMode.REGULAR == renderMode && !isRoot) {
            text.append(')');
        } else if (RenderMode.TOP_LEVEL == renderMode && !isRoot) {
            text.append('\n');
        }
    }

    private static String render(OracleConfiguration element, RenderMode renderMode) {
        StringBuilder b = new StringBuilder();
        OracleConfiguration.render(b, element, renderMode);
        return b.toString();
    }

    private static boolean requiresQuoting(String text) {
        return !text.matches("\\S+") && (!text.startsWith("\"") || !text.endsWith("\""));
    }

    static OracleConfiguration of(Stream<Token> tokens) {
        Stream<Token> normalized = tokens.filter(OracleConfiguration::normalize);
        return normalized.collect(OracleConfiguration.toConfiguration());
    }

    static Collector<Token, Parser, OracleConfiguration> toConfiguration() {
        return new Collector<Token, Parser, OracleConfiguration>(){

            @Override
            public Supplier<Parser> supplier() {
                return Parser::new;
            }

            @Override
            public BiConsumer<Parser, Token> accumulator() {
                return Parser::accept;
            }

            @Override
            public BinaryOperator<Parser> combiner() {
                return (first, second) -> {
                    throw new UnsupportedOperationException();
                };
            }

            @Override
            public Function<Parser, OracleConfiguration> finisher() {
                return Parser::configuration;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return Set.of(Collector.Characteristics.UNORDERED);
            }
        };
    }

    private static boolean normalize(Token token) {
        switch (token.type) {
            case COMMENT: 
            case EOL: 
            case WHITESPACE: {
                return false;
            }
        }
        return true;
    }

    public static Builder builder() {
        return new Builder(null);
    }

    OracleConfiguration withName(CharSequence name) {
        return new OracleConfiguration(Name.of(name), this.value, this.elements);
    }

    public int size() {
        if (ValueType.ATOM == this.valueType()) {
            return -1;
        }
        return this.elements().size();
    }

    public OracleConfiguration get(int index) {
        if (ValueType.ATOM == this.valueType()) {
            throw new IndexOutOfBoundsException(index);
        }
        return this.elements().get(index);
    }

    public List<OracleConfiguration> elements() {
        return this.elements;
    }

    public Name name() {
        return this.name;
    }

    public String toString() {
        return this.toString(RenderMode.FILE);
    }

    public String toString(RenderMode renderMode) {
        return OracleConfiguration.render(this, renderMode);
    }

    public String value() {
        return this.value;
    }

    public String valueToString() {
        switch (this.valueType().ordinal()) {
            case 0: {
                return this.value();
            }
        }
        StringBuilder text = new StringBuilder();
        this.elements().forEach(e -> OracleConfiguration.render(text, e, RenderMode.REGULAR));
        return text.toString();
    }

    public ValueType valueType() {
        return this.value == null ? ValueType.LIST : ValueType.ATOM;
    }

    public void write(Appendable output) throws IOException {
        output.append(this.toString());
    }

    public static class Name
    implements CharSequenceTrait {
        private final String name;
        private final transient String normalized;

        private Name(String name) {
            this.name = name;
            this.normalized = name.toUpperCase(Locale.ROOT);
        }

        public static Name of(CharSequence name) {
            if (name == null) {
                return null;
            }
            if (name instanceof Name) {
                return (Name)name;
            }
            return new Name(name.toString());
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Name name = (Name)o;
            return Objects.equals(this.normalized, name.normalized);
        }

        public int hashCode() {
            return Objects.hashCode(this.normalized);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }

    public static class Builder {
        private final Function<OracleConfiguration, Builder> endListAction;
        private final List<OracleConfiguration> elements;
        private final StringBuilder value;
        private Name name;

        private Builder(Function<OracleConfiguration, Builder> endListAction) {
            this.endListAction = endListAction;
            this.value = new StringBuilder();
            this.elements = new ArrayList<OracleConfiguration>();
        }

        public Builder name(CharSequence name) {
            this.name = Name.of(name);
            return this;
        }

        public Builder value(CharSequence value) {
            if (value == null) {
                this.value.setLength(0);
            } else {
                this.elements.clear();
                this.value.append(value);
            }
            return this;
        }

        public Builder element(OracleConfiguration element) {
            this.value.setLength(0);
            this.elements.add(element);
            return this;
        }

        public Builder beginPair() {
            return new Builder(this::element);
        }

        public Builder endPair() {
            if (this.endListAction == null) {
                throw new IllegalStateException();
            }
            OracleConfiguration self = this.build();
            return this.endListAction.apply(self);
        }

        public Builder atom(CharSequence name, CharSequence value) {
            return this.element(OracleConfiguration.builder().name(name).value(value).build());
        }

        public OracleConfiguration build() {
            return new OracleConfiguration(this);
        }

        public String toString() {
            return this.build().toString();
        }
    }

    public static class Entry {
        private static final EntryParser ENTRY_PARSER = EntryParser.of(new Lexer());
        private final TokenStream lhs;
        private final TokenStream rhs;
        private transient SyntaxException error;
        private transient OracleConfiguration valueAsConfiguration;

        private Entry(TokenStream lhs, TokenStream rhs) {
            this.lhs = lhs.trim();
            this.rhs = rhs.trim();
        }

        static Entry of(Slice<Token> lhs, Slice<Token> rhs) {
            return new Entry(TokenStream.of(lhs), TokenStream.of(rhs));
        }

        static Entry of(Slice<Token> tokens) {
            int eq = -1;
            for (int i = 0; i < tokens.size(); ++i) {
                Token token = tokens.get(i);
                if (Token.Type.EQ != token.type) continue;
                eq = i;
                break;
            }
            if (eq == -1) {
                if (tokens.size() == 1 && tokens.first().isValue()) {
                    return Entry.of(tokens, tokens);
                }
                throw new IllegalArgumentException(tokens.toString());
            }
            Slice<Token> lhs = tokens.slice(0, eq);
            Slice<Token> rhs = tokens.slice(eq + 1);
            return Entry.of(lhs, rhs);
        }

        static EntryParser parser() {
            return ENTRY_PARSER;
        }

        public Set<String> names() {
            return this.lhs.stream().filter(Token::isValue).map(token -> token.text).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        public String name() {
            return (String)this.names().stream().findFirst().orElseThrow();
        }

        public String valueAsString() {
            return this.rhs.toString();
        }

        void add(Builder builder) {
            OracleConfiguration configuration = this.valueAsConfiguration();
            for (String name : this.names()) {
                builder.element(configuration.withName(name));
            }
        }

        public OracleConfiguration valueAsConfiguration() {
            this.load();
            if (this.valueAsConfiguration == null) {
                throw this.error;
            }
            return this.valueAsConfiguration;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            boolean equal = Objects.equals(this.lhs, entry.lhs) && Objects.equals(this.rhs, entry.rhs);
            return equal;
        }

        public int hashCode() {
            return Objects.hash(this.lhs, this.rhs);
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            if (!this.lhs.isEmpty()) {
                text.append(this.lhs);
                text.append("=");
            }
            if (!this.rhs.isEmpty()) {
                text.append(this.rhs);
            }
            return text.toString();
        }

        public String line(Position position) {
            return this.line(position.line());
        }

        public String line(int line) {
            int firstLine = -1;
            firstLine = !this.lhs.isEmpty() ? this.lhs.get((int)0).start.line() : (!this.rhs.isEmpty() ? this.rhs.get((int)0).start.line() : 0);
            int offset = line - firstLine;
            if (offset < 0) {
                throw new IndexOutOfBoundsException(line);
            }
            List lines = this.toString().lines().collect(Collectors.toList());
            return (String)lines.get(offset);
        }

        public boolean isValid() {
            return this.error() == null;
        }

        public SyntaxException error() {
            this.load();
            return this.error;
        }

        private void load() {
            if (this.error == null && this.valueAsConfiguration == null) {
                try {
                    this.valueAsConfiguration = OracleConfiguration.of(this.rhs.stream());
                }
                catch (SyntaxException e) {
                    this.error = e;
                }
            }
        }
    }

    public static enum RenderMode {
        FILE,
        REGULAR,
        TOP_LEVEL;

    }

    public static enum ValueType {
        ATOM,
        LIST;

    }

    public static class Position {
        int line;
        int column;

        private Position(Builder builder) {
            this.column = builder.column;
            this.line = builder.line;
        }

        static Builder builder() {
            return new Builder();
        }

        static Position of(int line, int column) {
            return Position.builder().line(line).column(column).build();
        }

        public int column() {
            return this.column;
        }

        public int line() {
            return this.line;
        }

        Position plus(int line, int column) {
            return Position.builder().line(this.line + line).column(this.column + column).build();
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Position position = (Position)o;
            return this.line == position.line && this.column == position.column;
        }

        public int hashCode() {
            return Objects.hash(this.line, this.column);
        }

        public String toString() {
            return "[" + this.line + ":" + this.column + "]";
        }

        static final class Builder {
            private int column;
            private int line;

            private Builder() {
            }

            Builder column(int column) {
                this.column = column;
                return this;
            }

            Builder line(int line) {
                this.line = line;
                return this;
            }

            Position build() {
                return new Position(this);
            }
        }
    }

    public static class SyntaxException
    extends IllegalStateException {
        private final SyntaxError error;

        private SyntaxException(SyntaxError error, Throwable cause) {
            super(SyntaxException.message(error, cause), cause);
            this.error = error;
        }

        static SyntaxException of(SyntaxError error) {
            return SyntaxException.of(error, null);
        }

        static SyntaxException of(SyntaxError error, Throwable cause) {
            return new SyntaxException(error, cause);
        }

        static SyntaxException of(String source, Throwable cause) {
            String error = Throwables.message(cause);
            String message = "TNS Configuration has a syntax error. The following error occurred when parsing: {0}, error: {1}. Ensure the TNS configuration resource is well-formed";
            SyntaxError hack = SyntaxError.of(Position.of(0, 0), "TNS Configuration has a syntax error. The following error occurred when parsing: {0}, error: {1}. Ensure the TNS configuration resource is well-formed");
            return new SyntaxException(hack, cause);
        }

        private static String message(SyntaxError error, Throwable cause) {
            return "Syntax error: " + String.valueOf(error.message());
        }

        public SyntaxError error() {
            return this.error;
        }
    }

    public static class SyntaxError {
        private final Position position;
        private final CharSequence message;

        private SyntaxError(Builder builder) {
            this.position = builder.position;
            this.message = builder.message;
        }

        static Builder builder() {
            return new Builder();
        }

        static SyntaxError of(Position position, String message) {
            return SyntaxError.builder().position(position).message(message).build();
        }

        public CharSequence message() {
            return this.message;
        }

        public Position position() {
            return this.position;
        }

        static final class Builder {
            private Position position;
            private CharSequence message;

            private Builder() {
            }

            Builder position(Position position) {
                this.position = position;
                return this;
            }

            Builder message(CharSequence message) {
                this.message = message;
                return this;
            }

            SyntaxError build() {
                return new SyntaxError(this);
            }
        }
    }

    private static class Parser
    implements Consumer<Token> {
        private final Builder root;
        private Token previousToken;
        private Builder builder;
        private boolean rhs;

        private Parser(Builder root) {
            this.root = root;
            this.builder = root;
            this.rhs = true;
        }

        Parser() {
            this(OracleConfiguration.builder());
        }

        OracleConfiguration configuration() {
            return this.root.build();
        }

        private void allowAtomOrStartList(Token token) {
            SyntaxErrors.allow(token, Token.Type.SINGLE_QUOTED_ATOM, Token.Type.DOUBLE_QUOTED_ATOM, Token.Type.UNQUOTED_ATOM, Token.Type.BEGIN_PAIR);
        }

        private void allowAtomOrStartListOrEndList(Token token) {
            SyntaxErrors.allow(token, Token.Type.SINGLE_QUOTED_ATOM, Token.Type.DOUBLE_QUOTED_ATOM, Token.Type.UNQUOTED_ATOM, Token.Type.BEGIN_PAIR, Token.Type.END_PAIR);
        }

        private void allowAtom(Token token) {
            SyntaxErrors.allow(token, Token.Type.SINGLE_QUOTED_ATOM, Token.Type.DOUBLE_QUOTED_ATOM, Token.Type.UNQUOTED_ATOM);
        }

        private void allowEquals(Token token) {
            SyntaxErrors.allow(token, Token.Type.EQ);
        }

        private void allowSeparatorOrEndList(Token token) {
            SyntaxErrors.allow(token, Token.Type.SEPARATOR, Token.Type.END_PAIR);
        }

        private void allowEndList(Token token) {
            SyntaxErrors.allow(token, Token.Type.END_PAIR);
        }

        private void allowEndListOrStartList(Token token) {
            SyntaxErrors.allow(token, Token.Type.END_PAIR, Token.Type.BEGIN_PAIR);
        }

        private void allowUnquotedAtom(Token token) {
            SyntaxErrors.allow(token, Token.Type.UNQUOTED_ATOM);
        }

        @Override
        public void accept(Token token) {
            if (this.previousToken == null) {
                this.allowAtomOrStartList(token);
            } else {
                switch (this.previousToken.type) {
                    case SINGLE_QUOTED_ATOM: 
                    case DOUBLE_QUOTED_ATOM: {
                        if (this.rhs) {
                            this.allowEndList(token);
                            break;
                        }
                        this.allowEquals(token);
                        break;
                    }
                    case UNQUOTED_ATOM: {
                        if (this.rhs) {
                            this.allowSeparatorOrEndList(token);
                            break;
                        }
                        this.allowEquals(token);
                        break;
                    }
                    case SEPARATOR: {
                        this.allowUnquotedAtom(token);
                        break;
                    }
                    case EQ: {
                        this.allowAtomOrStartListOrEndList(token);
                        break;
                    }
                    case BEGIN_PAIR: {
                        this.rhs = false;
                        this.allowAtom(token);
                        break;
                    }
                    case END_PAIR: {
                        this.allowEndListOrStartList(token);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected previous token: " + String.valueOf((Object)this.previousToken.type));
                    }
                }
            }
            switch (token.type) {
                case EQ: {
                    this.rhs = true;
                    break;
                }
                case SINGLE_QUOTED_ATOM: 
                case DOUBLE_QUOTED_ATOM: 
                case UNQUOTED_ATOM: {
                    if (this.rhs) {
                        this.builder.value(token.text);
                        break;
                    }
                    this.builder.name(token.text);
                    break;
                }
                case SEPARATOR: {
                    this.builder.value(",");
                    break;
                }
                case BEGIN_PAIR: {
                    this.builder = this.builder.beginPair();
                    break;
                }
                case END_PAIR: {
                    this.builder = this.builder.endPair();
                    break;
                }
                default: {
                    throw SyntaxErrors.expected(token, Token.Type.EQ, Token.Type.SINGLE_QUOTED_ATOM, Token.Type.DOUBLE_QUOTED_ATOM, Token.Type.UNQUOTED_ATOM, Token.Type.BEGIN_PAIR, Token.Type.END_PAIR);
                }
            }
            this.previousToken = token;
        }

        public String toString() {
            return this.root.toString();
        }
    }
}

