/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.tns;

import java.io.Reader;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.stream.Stream;
import oracle.dbtools.core.collections.Slice;
import oracle.dbtools.core.tns.Lexer;
import oracle.dbtools.core.tns.OracleConfiguration;
import oracle.dbtools.core.tns.SyntaxErrors;
import oracle.dbtools.core.tns.Token;
import oracle.dbtools.core.tns.TokenBuffer;

class EntryParser {
    private final Lexer lexer;

    private EntryParser(Lexer lexer) {
        this.lexer = lexer;
    }

    static EntryParser of(Lexer lexer) {
        return new EntryParser(lexer);
    }

    Stream<OracleConfiguration.Entry> parse(Stream<Token> content) {
        EntryGatherer gatherer = new EntryGatherer();
        Stream entries = content.flatMap(gatherer::parseNextEntry);
        Stream<OracleConfiguration.Entry> lastEntry = Stream.generate(gatherer::lastEntry).takeWhile(Objects::nonNull);
        return Stream.concat(entries, lastEntry);
    }

    public Stream<OracleConfiguration.Entry> parse(Reader content) {
        Stream<Token> tokens = this.lexer.parse(content);
        return this.parse(tokens);
    }

    public Stream<OracleConfiguration.Entry> parse(CharSequence content) {
        Stream<Token> tokens = this.lexer.parse(content);
        return this.parse(tokens);
    }

    private static class EntryGatherer {
        private final TokenBuffer lhs = new TokenBuffer();
        private final TokenBuffer rhs = new TokenBuffer();
        private State state = State.LHS;

        EntryGatherer() {
        }

        static Token previousToken(Slice<Token> lhs) {
            Slice.Immutable semanticTokens = lhs.stream().filter(token -> Token.Type.COMMENT != token.type && Token.Type.EOL != token.type && Token.Type.WHITESPACE != token.type).collect(Slice.toSlice());
            return semanticTokens.isEmpty() ? null : (Token)semanticTokens.last();
        }

        private void allow(Token token, Token.Type ... allowed) {
            SyntaxErrors.allow(token, allowed);
        }

        private State parseLhs(Token token, TokenBuffer lhs) {
            Token previousToken = EntryGatherer.previousToken(lhs);
            if (Token.Type.EQ == token.type) {
                if (previousToken != null && previousToken.isValue()) {
                    return State.EQ;
                }
                this.allow(token, Token.Type.SINGLE_QUOTED_ATOM, Token.Type.DOUBLE_QUOTED_ATOM, Token.Type.UNQUOTED_ATOM);
            } else {
                if (previousToken == null) {
                    this.allow(token, Token.Type.COMMENT, Token.Type.EOL, Token.Type.WHITESPACE, Token.Type.SINGLE_QUOTED_ATOM, Token.Type.DOUBLE_QUOTED_ATOM, Token.Type.UNQUOTED_ATOM);
                } else {
                    switch (previousToken.type) {
                        case COMMENT: {
                            this.allow(token, Token.Type.EOL);
                            break;
                        }
                        case WHITESPACE: {
                            this.allow(token, Token.Type.SEPARATOR, Token.Type.SINGLE_QUOTED_ATOM, Token.Type.DOUBLE_QUOTED_ATOM, Token.Type.UNQUOTED_ATOM);
                            break;
                        }
                        case SEPARATOR: {
                            this.allow(token, Token.Type.WHITESPACE, Token.Type.SINGLE_QUOTED_ATOM, Token.Type.DOUBLE_QUOTED_ATOM, Token.Type.UNQUOTED_ATOM);
                            break;
                        }
                        case SINGLE_QUOTED_ATOM: 
                        case DOUBLE_QUOTED_ATOM: 
                        case UNQUOTED_ATOM: {
                            this.allow(token, Token.Type.WHITESPACE, Token.Type.SEPARATOR, Token.Type.EQ);
                        }
                    }
                }
                this.validate(token);
                lhs.add(token);
            }
            return State.LHS;
        }

        private void validate(final Token token) {
            String text = token.text;
            if (text != null) {
                IntConsumer validator = new IntConsumer(){
                    private int column;
                    {
                        this.column = token.start.column();
                    }

                    @Override
                    public void accept(int c) {
                        if (token.type.validator.test(c)) {
                            ++this.column;
                        } else {
                            OracleConfiguration.Position errorPosition = OracleConfiguration.Position.of(token.start.line(), this.column);
                            String pattern = "Character: {0} is not permitted in token of type: {1}";
                            String message = MessageFormat.format("Character: {0} is not permitted in token of type: {1}", Character.toString(c), token.type.name());
                            OracleConfiguration.SyntaxError error = OracleConfiguration.SyntaxError.of(errorPosition, message);
                            throw OracleConfiguration.SyntaxException.of(error);
                        }
                    }
                };
                text.codePoints().forEach(validator);
            }
        }

        Stream<OracleConfiguration.Entry> parseNextEntry(Token token) {
            block0 : switch (this.state.ordinal()) {
                case 0: {
                    this.state = this.parseLhs(token, this.lhs);
                    break;
                }
                case 1: {
                    this.state = State.RHS;
                    this.rhs.add(token);
                    break;
                }
                case 3: {
                    if (Token.Type.EOL == token.type) {
                        this.state = State.RHS_EOL;
                    }
                    this.rhs.add(token);
                    break;
                }
                case 2: {
                    switch (token.type) {
                        case COMMENT: 
                        case WHITESPACE: 
                        case BEGIN_PAIR: 
                        case END_PAIR: {
                            this.state = State.RHS;
                            this.rhs.add(token);
                            break block0;
                        }
                    }
                    OracleConfiguration.Entry entry = this.emitEntry();
                    this.state = this.parseLhs(token, this.lhs);
                    return Stream.of(entry);
                }
            }
            return Stream.empty();
        }

        private OracleConfiguration.Entry emitEntry() {
            OracleConfiguration.Entry entry = OracleConfiguration.Entry.of(this.lhs.slice(), this.rhs.slice());
            this.lhs.clear();
            this.rhs.clear();
            this.state = State.LHS;
            return entry;
        }

        OracleConfiguration.Entry lastEntry() {
            if (!(this.state != State.RHS && this.state != State.RHS_EOL || this.rhs.isEmpty())) {
                return this.emitEntry();
            }
            if (this.state == State.LHS && this.rhs.isEmpty() && !this.lhs.isEmpty()) {
                this.rhs.add(this.lhs);
                return this.emitEntry();
            }
            return null;
        }
    }

    private static enum State {
        LHS,
        EQ,
        RHS_EOL,
        RHS;

    }
}

