/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.jdbc.configurators;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.core.connections.ConnectionsResources;
import oracle.dbtools.core.jdbc.DataSourceBuilder;
import oracle.dbtools.core.jdbc.configurators.ConfigurationException;
import oracle.dbtools.core.jdbc.configurators.ConnectionTypeConfigurator;

public class BasicConfiguration
implements ConnectionTypeConfigurator {
    private static final String ORACLE_THIN_JDBC_PREFIX = "jdbc:oracle:thin:@";
    private static final String ORACLE_OCI_JDBC_PREFIX = "jdbc:oracle:oci:@";
    private final transient String url;

    public static String constructURL(Properties props) throws ConfigurationException {
        String url = props.getProperty("customUrl");
        if (url == null) {
            url = BasicConfiguration.constructURL(props.getProperty("oraDriverType"), props.getProperty("hostname"), props.getProperty("port"), props.getProperty("sid"), props.getProperty("serviceName"));
        }
        return url;
    }

    public static String constructURL(String driverType, String hostname, String port, String sid, String servicename) throws ConfigurationException {
        StringBuilder url = new StringBuilder();
        if (sid == null && servicename == null) {
            throw new ConfigurationException(ConnectionsResources.getString("ERROR_SID_SERVICE_NAME"));
        }
        if ("thin".equals(driverType)) {
            url.append(ORACLE_THIN_JDBC_PREFIX);
            if (sid != null) {
                url.append(hostname).append(":").append(port).append(":").append(sid);
            } else if (servicename != null) {
                url.append("//").append(hostname).append(":").append(port).append("/").append(servicename);
            }
        } else if ("oci".equals(driverType)) {
            url.append(ORACLE_OCI_JDBC_PREFIX);
            url.append("(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=");
            url.append(hostname);
            url.append(")(PORT=");
            url.append(port);
            url.append("))(CONNECT_DATA=(");
            if (sid != null) {
                url.append("SID=").append(sid);
            } else if (servicename != null) {
                url.append("SERVICE_NAME=").append(servicename);
            }
        }
        return url.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Properties props) {
        return new Builder().properties(props);
    }

    private BasicConfiguration(String url) {
        this.url = url;
    }

    public String url() {
        return this.url;
    }

    @Override
    public void configure(DataSourceBuilder<?> dataSourceBuilder) throws SQLException, IOException {
        dataSourceBuilder.url(this.url);
    }

    @Override
    public String connectionURL() {
        return this.url;
    }

    public static final class Builder
    implements ConnectionTypeConfigurator.ConnectionTypeBuilder<BasicConfiguration> {
        private String hostname = "localhost";
        private String port = "1521";
        private String sid;
        private String servicename;
        private String driverType = "thin";
        private String customURL;

        private Builder() {
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder port(String port) {
            this.port = port;
            return this;
        }

        public Builder sid(String sid) {
            if (sid != null) {
                this.servicename(null);
            }
            this.sid = sid;
            return this;
        }

        public Builder servicename(String servicename) {
            if (servicename != null) {
                this.sid(null);
            }
            this.servicename = servicename;
            return this;
        }

        public Builder driverType(String driverType) {
            this.driverType = "oci8".equals(driverType) ? "oci" : driverType;
            return this;
        }

        public Builder customURL(String url) {
            this.customURL = url;
            return this;
        }

        public Builder properties(Properties properties) {
            String customURL = properties.getProperty("customUrl");
            if (ConnectionTypeConfigurator.hasLength(customURL)) {
                this.customURL(customURL);
            } else {
                this.hostname(properties.getProperty("hostname"));
                this.port(properties.getProperty("port"));
                this.sid(properties.getProperty("sid"));
                this.servicename(properties.getProperty("serviceName"));
                this.driverType(properties.getProperty("oraDriverType"));
            }
            return this;
        }

        @Override
        public BasicConfiguration build() throws ConfigurationException {
            return this.customURL != null ? new BasicConfiguration(this.customURL) : new BasicConfiguration(BasicConfiguration.constructURL(this.driverType, this.hostname, this.port, this.sid, this.servicename));
        }
    }
}

