/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.jdbc;

import java.net.URI;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.sql.DataSource;
import oracle.dbtools.core.jdbc.DataSourceBuilder;

public abstract class DataSourceBuilderBase<T extends DataSource>
implements DataSourceBuilder<T> {
    private final Properties connectionProperties = new Properties();
    private DataSourceBuilder.HostnameResolver hostnameResolver;
    private String password;
    private SSLContext sslContext;
    private String url;
    private String user;
    private Boolean fastConnectionFailover = null;
    private String onsConfiguration;
    private String serviceAlias;
    private URI httpsProxy;
    private Boolean createConnectionInBorrowThread = true;
    private static final String USER = "user";
    private static final String PASSWORD = "password";

    protected DataSourceBuilderBase() {
    }

    @Override
    public T build() throws SQLException {
        T ds = this.createDataSource();
        return this.configure(ds);
    }

    @Override
    public T configure(T dataSource) throws SQLException {
        this.syncCredentials();
        this.configure(dataSource, this.url, this.user, this.password, this.connectionProperties, this.sslContext, this.fastConnectionFailover, this.onsConfiguration, this.createConnectionInBorrowThread);
        this.configureHostNameResolver(dataSource, this.hostnameResolver);
        return dataSource;
    }

    protected abstract void configure(T var1, String var2, String var3, String var4, Properties var5, SSLContext var6, Boolean var7, String var8, Boolean var9) throws SQLException;

    protected void configureHostNameResolver(T ds, DataSourceBuilder.HostnameResolver hostnameResolver) {
    }

    @Override
    public DataSourceBuilderBase<T> connectionProperties(Properties connectionProperties) {
        this.connectionProperties.putAll((Map<?, ?>)connectionProperties);
        return this;
    }

    @Override
    public DataSourceBuilderBase<T> createConnectionInBorrowThread(Boolean createConnectionInBorrowThread) {
        this.createConnectionInBorrowThread = createConnectionInBorrowThread;
        return this;
    }

    protected abstract T createDataSource() throws SQLException;

    @Override
    public DataSourceBuilderBase<T> hostnameResolver(DataSourceBuilder.HostnameResolver hostnameResolver) {
        this.hostnameResolver = hostnameResolver;
        return this;
    }

    @Override
    public DataSourceBuilderBase<T> fastConnectionFailover(Boolean enabled) {
        this.fastConnectionFailover = enabled;
        return this;
    }

    @Override
    public boolean hasCredentials() {
        return this.user != null || this.password != null;
    }

    @Override
    public boolean hasUrl() {
        return this.url != null;
    }

    @Override
    public DataSourceBuilderBase<T> httpsProxy(URI httpsProxy) {
        this.httpsProxy = httpsProxy;
        return this;
    }

    @Override
    public final URI httpsProxy() {
        return this.httpsProxy;
    }

    @Override
    public DataSourceBuilderBase<T> onsConfiguration(String onsConfig) {
        this.onsConfiguration = onsConfig;
        return this;
    }

    @Override
    public DataSourceBuilderBase<T> password(String password) {
        this.password = password;
        return this;
    }

    @Override
    public DataSourceBuilderBase<T> serviceAlias(String serviceAlias) {
        this.serviceAlias = serviceAlias;
        return this;
    }

    @Override
    public final String serviceAlias() {
        return this.serviceAlias;
    }

    @Override
    public DataSourceBuilderBase<T> sslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    boolean syncCredentials() {
        if (this.hasCredentials()) {
            if (this.user != null) {
                if (!this.user.equals(this.connectionProperties.getProperty(USER))) {
                    this.connectionProperties.setProperty(USER, this.user);
                }
            } else {
                this.connectionProperties.remove(USER);
            }
            if (this.password != null) {
                if (!this.password.equals(this.connectionProperties.getProperty(PASSWORD))) {
                    this.connectionProperties.setProperty(PASSWORD, this.password);
                }
            } else {
                this.connectionProperties.remove(PASSWORD);
            }
        } else {
            this.user = this.connectionProperties.getProperty(USER);
            this.password = this.connectionProperties.getProperty(PASSWORD);
        }
        return this.hasCredentials();
    }

    @Override
    public DataSourceBuilderBase<T> url(String url) {
        this.url = url;
        return this;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public DataSourceBuilderBase<T> user(String user) {
        this.user = user;
        return this;
    }
}

