/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.jdbc;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.sql.DataSource;

public interface DataSourceBuilder<T extends DataSource> {
    public T build() throws SQLException;

    public T configure(T var1) throws SQLException;

    public DataSourceBuilder<T> connectionProperties(Properties var1);

    public DataSourceBuilder<T> createConnectionInBorrowThread(Boolean var1);

    public boolean hasCredentials();

    public boolean hasUrl();

    public DataSourceBuilder<T> hostnameResolver(HostnameResolver var1);

    public DataSourceBuilder<T> httpsProxy(URI var1);

    public URI httpsProxy();

    public DataSourceBuilder<T> fastConnectionFailover(Boolean var1);

    public DataSourceBuilder<T> onsConfiguration(String var1);

    public DataSourceBuilder<T> password(String var1);

    public DataSourceBuilder<T> serviceAlias(String var1);

    public String serviceAlias();

    public DataSourceBuilder<T> sslContext(SSLContext var1);

    default public DataSourceBuilder<T> url(CharSequence url) {
        if (url == null) {
            return this;
        }
        return this.url(url.toString());
    }

    public DataSourceBuilder<T> url(String var1);

    public String url();

    public DataSourceBuilder<T> user(String var1);

    @FunctionalInterface
    public static interface HostnameResolver {
        public InetAddress[] getAllByName(String var1) throws UnknownHostException;
    }
}

