/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;

public final class InputOutputStreams {
    private static final int BUFFER_SIZE = 65536;
    private static final EmptyStream EMPTY_STREAM = new EmptyStream();
    private static final InputOutputStreams INSTANCE = new InputOutputStreams();
    private static final NullOutputStream NULL_OUTPUT_STREAM = new NullOutputStream();
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public static InputOutputStreams instance() {
        return INSTANCE;
    }

    public byte[] asByteArray(InputStream is) throws IOException {
        ReadableByteChannel source = Channels.newChannel(is);
        return this.asByteArray(source);
    }

    public byte[] asByteArray(ReadableByteChannel source) throws IOException {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            WritableByteChannel destination = Channels.newChannel(os);
            this.copy(source, destination);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    public InputStream asInputStream(byte[] bytes) {
        if (bytes.length == 0) {
            return EMPTY_STREAM;
        }
        return new ByteArrayInputStream(bytes);
    }

    public InputStream asInputStream(CharSequence text) throws IOException {
        if (null == text) {
            return EMPTY_STREAM;
        }
        return this.asInputStream(text.toString().getBytes(UTF_8));
    }

    public Readable asReadable(CharSequence content) {
        return new CharSequenceReadable(content);
    }

    public Reader asReader(CharSequence content) {
        return this.asReader(this.asReadable(content));
    }

    public Reader asReader(Readable content) {
        if (content instanceof Reader) {
            return (Reader)content;
        }
        return new ReadableReader(content);
    }

    public long copy(InputStream is, OutputStream os) throws IOException {
        if (is != null && os != null) {
            ReadableByteChannel source = Channels.newChannel(is);
            WritableByteChannel destination = Channels.newChannel(os);
            return this.copy(source, destination);
        }
        return -1L;
    }

    public long copy(Readable source, Appendable destination) throws IOException {
        long length = 0L;
        CharBuffer buffer = CharBuffer.allocate(65536);
        while (source.read(buffer) != -1) {
            buffer.flip();
            destination.append(buffer, 0, buffer.limit());
            length += (long)buffer.limit();
            buffer.clear();
        }
        return length;
    }

    public long copy(ReadableByteChannel source, WritableByteChannel destination) throws IOException {
        long length = 0L;
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        while (source.read(buffer) != -1) {
            buffer.flip();
            while (buffer.hasRemaining()) {
                length += (long)destination.write(buffer);
            }
            buffer.clear();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            destination.write(buffer);
        }
        return length;
    }

    public OutputStream nullOutputStream() {
        return NULL_OUTPUT_STREAM;
    }

    public Reader reader(InputStream content) {
        return new InputStreamReader(content, UTF_8);
    }

    public Reader uncloseable(Reader stream) {
        if (stream instanceof UncloseableReader) {
            return stream;
        }
        return new UncloseableReader(stream);
    }

    public InputStream uncloseable(InputStream stream) {
        if (stream instanceof UncloseableInputStream) {
            return stream;
        }
        return new UncloseableInputStream(stream);
    }

    public Writer writer(OutputStream out) {
        return new OutputStreamWriter(out, UTF_8);
    }

    private static void close(Object target) throws IOException {
        if (target instanceof AutoCloseable) {
            try {
                ((AutoCloseable)target).close();
            }
            catch (IOException | RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    private static final class EmptyStream
    extends InputStream {
        private EmptyStream() {
        }

        @Override
        public int read() throws IOException {
            return -1;
        }
    }

    private static class CharSequenceReadable
    implements Readable,
    AutoCloseable {
        private final CharSequence content;
        private final transient int start = 0;
        private final transient CharBuffer source;

        CharSequenceReadable(CharSequence content) {
            this.content = content;
            this.source = CharBuffer.wrap(content);
        }

        @Override
        public void close() throws IOException {
            InputOutputStreams.close(this.content);
        }

        public String toString() {
            return this.content.toString();
        }

        @Override
        public int read(CharBuffer buffer) throws IOException {
            int length = buffer.remaining();
            if (length > 0) {
                int available = this.source.remaining();
                if (available <= 0) {
                    return -1;
                }
                int size = Math.min(length, available);
                CharBuffer slice = this.source.slice().limit(size);
                buffer.put(slice);
                this.source.position(this.source.position() + size);
                return size;
            }
            return 0;
        }
    }

    private static final class ReadableReader
    extends Reader {
        private final Readable target;

        private ReadableReader(Readable target) {
            this.target = target;
        }

        @Override
        public int read(char[] buffer, int offset, int length) throws IOException {
            CharBuffer buf = CharBuffer.wrap(buffer, offset, length);
            int count = this.target.read(buf);
            return count;
        }

        @Override
        public void close() throws IOException {
            InputOutputStreams.close(this.target);
        }
    }

    private static final class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }

    private static class UncloseableReader
    extends FilterReader {
        UncloseableReader(Reader in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }

    private static final class UncloseableInputStream
    extends FilterInputStream {
        UncloseableInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }
}

