/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.io;

import java.util.Formatter;
import java.util.Locale;

class FormattedString {
    private final Object[] args;
    private final String fmt;
    private final Locale locale;

    private FormattedString(Locale locale, String fmt, Object[] args) {
        this.fmt = fmt;
        this.args = args;
        this.locale = locale;
    }

    static FormattedString of(String fmt, Object ... args) {
        return FormattedString.of(Locale.getDefault(), fmt, args);
    }

    static FormattedString of(Locale locale, String fmt, Object ... args) {
        return new FormattedString(locale, fmt, args);
    }

    String localized(Locale locale) {
        return new Formatter(locale).format(this.fmt, this.args).toString();
    }

    public String toString() {
        return new Formatter(this.locale).format(this.fmt, this.args).toString();
    }
}

