/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.storage;

import oracle.dbtools.core.secrets.Secrets;
import oracle.dbtools.core.secrets.TextSecret;
import oracle.dbtools.core.text.Text;
import oracle.dbtools.core.util.Eraser;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;

public class UnicodeSafeWalletSecrets {
    private final OracleSecretStore secretStore;

    private UnicodeSafeWalletSecrets(OracleSecretStore secretStore) {
        this.secretStore = secretStore;
    }

    public static UnicodeSafeWalletSecrets of(OracleSecretStore secretStore) {
        return new UnicodeSafeWalletSecrets(secretStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextSecret read(CharSequence name) throws OracleSecretStoreException {
        String alias = name.toString();
        if (this.secretStore.containsAlias(alias)) {
            char[] base64 = this.secretStore.getSecret(alias);
            try {
                TextSecret textSecret;
                byte[] bytes = Text.decodeBase64(base64);
                try {
                    char[] text = Text.decode(bytes);
                    textSecret = Secrets.instance().of(text, true);
                }
                catch (Throwable throwable) {
                    Eraser.erase(bytes);
                    throw throwable;
                }
                Eraser.erase(bytes);
                return textSecret;
            }
            finally {
                Eraser.erase(base64);
            }
        }
        return TextSecret.none();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnicodeSafeWalletSecrets write(CharSequence name, TextSecret secret) throws OracleSecretStoreException {
        String alias = name.toString();
        if (secret.isPresent()) {
            char[] base64 = secret.map(plainText -> Text.encodeBase64(plainText));
            try {
                this.secretStore.setSecret(alias, base64);
            }
            finally {
                Eraser.erase(base64);
            }
        } else if (this.secretStore.containsAlias(alias)) {
            this.secretStore.deleteSecret(alias);
        }
        return this;
    }

    UnicodeSafeWalletSecrets write(CharSequence name, char[] secret) throws OracleSecretStoreException {
        return this.write(name, Secrets.instance().of(secret, false));
    }
}

