/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.folder.utils;

import java.util.Objects;
import java.util.regex.Pattern;

public final class PathsUtils {
    public static final String PATH_SEPARATOR = "/";

    private PathsUtils() {
    }

    public static String getLastElement(String path) {
        Objects.requireNonNull(path, "provided path is null");
        if (PathsUtils.isRoot(path)) {
            return PATH_SEPARATOR;
        }
        String normalizedPath = PathsUtils.normalizePath(path);
        String[] pathSegments = normalizedPath.split(Pattern.quote(PATH_SEPARATOR));
        return pathSegments[pathSegments.length - 1];
    }

    public static String getParentPath(String path) {
        Objects.requireNonNull(path, "provided path is null");
        String normalizedPath = PathsUtils.normalizePath(path);
        String[] pathSegments = normalizedPath.split(Pattern.quote(PATH_SEPARATOR));
        int length = pathSegments.length;
        int beforeLastIndex = 2;
        if (length < 2) {
            return PATH_SEPARATOR;
        }
        return normalizedPath.substring(0, normalizedPath.lastIndexOf(PATH_SEPARATOR));
    }

    public static boolean isRoot(String path) {
        return path == null || path.isBlank() || path.equals(PATH_SEPARATOR);
    }

    public static String[] getPathSegments(String path) {
        if (PathsUtils.isRoot(path)) {
            return new String[]{PATH_SEPARATOR};
        }
        String normalizedPath = PathsUtils.normalizePath(path);
        return normalizedPath.split(Pattern.quote(PATH_SEPARATOR));
    }

    private static String normalizePath(String path) {
        boolean FIRST_SEPARATOR_POSITION = true;
        String normalizedPath = path;
        if (path == null) {
            return normalizedPath;
        }
        if ((normalizedPath = normalizedPath.trim()).startsWith(PATH_SEPARATOR)) {
            normalizedPath = normalizedPath.substring(1);
        }
        if (normalizedPath.endsWith(PATH_SEPARATOR)) {
            normalizedPath = normalizedPath.substring(0, normalizedPath.lastIndexOf(PATH_SEPARATOR));
        }
        return normalizedPath;
    }
}

