/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.connections.folder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import oracle.dbtools.core.connections.api.Connections;

public final class Folder {
    private final String name;
    private final Map<String, Folder> subFolders;
    private final List<Connections.Identifier> connections;

    private Folder(Builder builder) {
        this.name = builder.name;
        this.subFolders = new ConcurrentSkipListMap<String, Folder>(builder.subFolders);
        this.connections = new ArrayList<Connections.Identifier>(builder.connections);
    }

    public String getName() {
        return this.name;
    }

    public List<Connections.Identifier> getConnections() {
        return this.connections;
    }

    public Map<String, Folder> getSubFolders() {
        return this.subFolders;
    }

    public boolean addConnection(Connections.Identifier connection) {
        return this.connections.add(connection);
    }

    public boolean addConnections(List<Connections.Identifier> connection) {
        return this.connections.addAll(connection);
    }

    public boolean deleteConnection(Connections.Identifier connection) {
        return this.connections.remove(connection);
    }

    public Folder addSubFolder(Folder folder) {
        this.subFolders.put(folder.getName(), folder);
        return folder;
    }

    public void addSubFolders(Map<String, Folder> subFolders) {
        this.subFolders.putAll(subFolders);
    }

    public void deleteSubFolder(Folder folder) {
        if (folder != null) {
            this.subFolders.remove(folder.getName());
        }
    }

    public Optional<Connections.Identifier> getConnection(Connections.Identifier connId) {
        if (this.connections.isEmpty()) {
            return Optional.empty();
        }
        return this.connections.stream().filter(c -> Objects.equals(c, connId)).findFirst();
    }

    public Set<String> getAllNestedConnections() {
        TreeSet<String> conns = new TreeSet<String>();
        if (!this.connections.isEmpty()) {
            conns.addAll(this.connections.stream().map(Object::toString).collect(Collectors.toUnmodifiableList()));
        }
        for (Folder subFolder : this.subFolders.values()) {
            conns.addAll(subFolder.getAllNestedConnections());
        }
        return conns;
    }

    public Folder getSubFolder(String name) {
        return this.subFolders.get(name);
    }

    public void deleteSubFolder(String name) {
        if (!name.isBlank()) {
            this.subFolders.remove(name);
        }
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static final class Builder {
        private final String name;
        private final Map<String, Folder> subFolders;
        private final List<Connections.Identifier> connections;

        private Builder(String name) {
            this.name = name;
            this.subFolders = new ConcurrentSkipListMap<String, Folder>();
            this.connections = new ArrayList<Connections.Identifier>();
        }

        public Builder subFolder(Folder folder) {
            this.subFolders.put(folder.getName(), folder);
            return this;
        }

        public Builder subFolders(Map<String, Folder> subFolders) {
            this.subFolders.putAll(subFolders);
            return this;
        }

        public Builder connection(Connections.Identifier connectionId) {
            this.connections.add(connectionId);
            return this;
        }

        public Builder connections(List<Connections.Identifier> connectionIds) {
            this.connections.addAll(connectionIds);
            return this;
        }

        public Folder build() {
            return new Folder(this);
        }
    }
}

