/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci;

import com.oracle.bmc.ConfigFileReader;
import com.oracle.bmc.auth.AuthenticationDetailsProvider;
import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.auth.SessionTokenAuthenticationDetailsProvider;
import java.io.IOException;
import java.nio.file.Path;
import oracle.dbtools.core.oci.Messages;
import oracle.dbtools.core.oci.OCIUtils;

public final class OCIProfile {
    private final String profileName;
    private final ConfigFileReader.ConfigFile configFile;
    private final AuthenticationDetailsProvider provider;

    public static Builder builder() {
        return new Builder();
    }

    private OCIProfile(Builder builder) throws IOException {
        this.profileName = builder.profileName;
        String configFilePath = builder.configFile.toAbsolutePath().toString();
        try {
            this.configFile = ConfigFileReader.parse((String)configFilePath, (String)this.profileName);
            String key_file = this.configFile.get("key_file");
            this.provider = OCIUtils.isEmpty(key_file) ? new SessionTokenAuthenticationDetailsProvider(this.configFile) : new ConfigFileAuthenticationDetailsProvider(this.configFile);
        }
        catch (IllegalStateException | NullPointerException e) {
            throw new IOException(Messages.format("OCI_INVALID_PROFILE", configFilePath, e.getLocalizedMessage()));
        }
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getProfileValue(String key) {
        return this.configFile.get(key);
    }

    public AuthenticationDetailsProvider getAuthenticationProvider() {
        return this.provider;
    }

    public static final class Builder {
        private String profileName;
        private Path configFile;

        private Builder() {
        }

        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public Builder configFile(Path configFile) {
            this.configFile = configFile;
            return this;
        }

        public OCIProfile build() throws IOException {
            return new OCIProfile(this);
        }
    }
}

