/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci;

import com.oracle.bmc.databasetools.model.DatabaseToolsConnection;
import com.oracle.bmc.databasetools.model.DatabaseToolsConnectionMySql;
import com.oracle.bmc.databasetools.model.DatabaseToolsConnectionOracleDatabase;

public class OCIDBToolsConnection {
    private final String ocid;
    private final DatabaseToolsConnection dbtoolsConnection;
    private final DatabaseType dbType;

    static Builder builder() {
        return new Builder();
    }

    private OCIDBToolsConnection(Builder builder) {
        this.ocid = builder.ocid;
        this.dbtoolsConnection = builder.dbtoolsConnection;
        this.dbType = this.dbtoolsConnection instanceof DatabaseToolsConnectionOracleDatabase ? DatabaseType.ORACLE : (this.dbtoolsConnection instanceof DatabaseToolsConnectionMySql ? DatabaseType.MYSQL : DatabaseType.UNKNOWN);
    }

    public String getOCID() {
        return this.ocid;
    }

    public DatabaseType getDatabaseType() {
        return this.dbType;
    }

    DatabaseToolsConnection getDbtoolsConnection() {
        return this.dbtoolsConnection;
    }

    static class Builder {
        private String ocid;
        private DatabaseToolsConnection dbtoolsConnection;

        private Builder() {
        }

        Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        Builder dbtoolsConnection(DatabaseToolsConnection dbtoolsConnection) {
            this.dbtoolsConnection = dbtoolsConnection;
            return this;
        }

        OCIDBToolsConnection build() {
            return new OCIDBToolsConnection(this);
        }
    }

    public static enum DatabaseType {
        ORACLE,
        MYSQL,
        POSTGRESS,
        UNKNOWN;

    }
}

