/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.responses.BmcResponse;
import java.io.IOException;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.core.oci.RequestException;

public abstract class OCIClient {
    private final OCIProfile profile;
    private final String region;
    private final ClientConfiguration clientConfiguration;

    protected OCIClient(Builder builder) {
        this.profile = builder.profile;
        this.region = builder.region;
        this.clientConfiguration = ClientConfiguration.builder().connectionTimeoutMillis(Integer.valueOf(builder.connectionTimeMillis)).build();
    }

    protected <T extends RegionalClientBuilder> T configureClient(T builderBase) {
        if (this.region != null) {
            builderBase = builderBase.region(this.region);
        }
        return (T)((RegionalClientBuilder)builderBase.configuration(this.clientConfiguration));
    }

    public OCIProfile getProfile() {
        return this.profile;
    }

    protected String getRegion() {
        return this.region;
    }

    protected static <T extends BmcResponse> T executeRequest(Request<T> request) throws IOException {
        try {
            return request.executeRequest();
        }
        catch (BmcException be) {
            Throwable cause = be.getCause();
            if (cause != null) {
                OCIClient.rethrow(cause);
                return null;
            }
            throw new RequestException(be);
        }
    }

    protected static void rethrow(Throwable cause) throws IOException {
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        IOException io = OCIClient.unwrap(cause, IOException.class);
        if (io != null) {
            throw io;
        }
        throw new IOException(cause);
    }

    private static <T extends Exception> T unwrap(Throwable t, Class<T> exceptionClass) {
        Exception result = null;
        if (exceptionClass.isAssignableFrom(t.getClass())) {
            result = (Exception)t;
        } else {
            Throwable cause = t.getCause();
            if (cause != null) {
                result = OCIClient.unwrap((Exception)cause, exceptionClass);
            }
        }
        return (T)result;
    }

    public <T extends Builder, C> C createFrom(T builder) {
        builder.region(this.region);
        return builder.build();
    }

    public static abstract class Builder<T extends Builder, C> {
        private OCIProfile profile;
        private String region;
        private int connectionTimeMillis = 30000;

        protected Builder(OCIProfile profile) {
            this.profile = profile;
        }

        public T region(String region) {
            this.region = region;
            return (T)this;
        }

        public T sessionTimeout(int timeout) {
            this.connectionTimeMillis = timeout;
            return (T)this;
        }

        public abstract C build();
    }

    protected static interface Request<T extends BmcResponse> {
        public T executeRequest();
    }
}

