/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.core.oci;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.bastion.BastionClient;
import com.oracle.bmc.bastion.model.BastionSummary;
import com.oracle.bmc.bastion.model.CreatePortForwardingSessionTargetResourceDetails;
import com.oracle.bmc.bastion.model.CreateSessionDetails;
import com.oracle.bmc.bastion.model.CreateSessionTargetResourceDetails;
import com.oracle.bmc.bastion.model.PublicKeyDetails;
import com.oracle.bmc.bastion.model.Session;
import com.oracle.bmc.bastion.model.SessionLifecycleState;
import com.oracle.bmc.bastion.model.SessionSummary;
import com.oracle.bmc.bastion.model.WorkRequest;
import com.oracle.bmc.bastion.requests.CreateSessionRequest;
import com.oracle.bmc.bastion.requests.GetSessionRequest;
import com.oracle.bmc.bastion.requests.GetWorkRequestRequest;
import com.oracle.bmc.bastion.requests.ListBastionsRequest;
import com.oracle.bmc.bastion.requests.ListSessionsRequest;
import com.oracle.bmc.bastion.responses.CreateSessionResponse;
import com.oracle.bmc.bastion.responses.GetSessionResponse;
import com.oracle.bmc.bastion.responses.GetWorkRequestResponse;
import com.oracle.bmc.bastion.responses.ListBastionsResponse;
import com.oracle.bmc.bastion.responses.ListSessionsResponse;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import oracle.dbtools.core.oci.Messages;
import oracle.dbtools.core.oci.OCIClient;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.core.oci.OCIUtils;
import oracle.dbtools.core.oci.PrivateEndpointConfiguration;
import oracle.dbtools.core.oci.SessionKey;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.core.CoreModuleProperties;

public class OCIBastionClient
extends OCIClient {
    private static final Duration HEARTBEAT_INTERVAL = Duration.ofSeconds(2L);
    private static final int SSH_WAIT_TIME = 15000;
    private static final BuiltinSignatures[] REQUIRED_FACTORIES = new BuiltinSignatures[]{BuiltinSignatures.ed25519, BuiltinSignatures.ed25519_cert, BuiltinSignatures.sk_ssh_ed25519};
    private final BastionClient bastionClient;
    private final SshClient sshClient;
    private static final int SSH_TIMEOUT = 120000;

    public static Builder builder(OCIProfile profile) {
        return new Builder(profile);
    }

    private static List<NamedFactory<Signature>> configureSignatureFactories(List<NamedFactory<Signature>> factories) {
        ArrayList<NamedFactory<Signature>> updatedList = new ArrayList<NamedFactory<Signature>>(factories);
        for (BuiltinSignatures sig : REQUIRED_FACTORIES) {
            if (factories.contains(sig)) continue;
            updatedList.add((NamedFactory<Signature>)sig);
        }
        return updatedList;
    }

    private OCIBastionClient(Builder builder) {
        super(builder);
        BastionClient.Builder clientBuilder = BastionClient.builder();
        this.configureClient(clientBuilder);
        this.bastionClient = clientBuilder.build((AbstractAuthenticationDetailsProvider)this.getProfile().getAuthenticationProvider());
        if (builder.sshCLient != null) {
            this.sshClient = builder.sshCLient;
        } else {
            this.sshClient = SshClient.setUpDefaultClient();
            CoreModuleProperties.HEARTBEAT_INTERVAL.set((PropertyResolver)this.sshClient, (Object)HEARTBEAT_INTERVAL);
            CoreModuleProperties.HEARTBEAT_REPLY_WAIT.set((PropertyResolver)this.sshClient, (Object)Duration.ofMillis(300L));
        }
        this.sshClient.setSignatureFactories(OCIBastionClient.configureSignatureFactories(this.sshClient.getSignatureFactories()));
    }

    public String findBastion(String compartmentID, String subnetID) throws IOException {
        String bastionID = null;
        ListBastionsRequest listBastionsRequest = ListBastionsRequest.builder().compartmentId(compartmentID).build();
        ListBastionsResponse listBastionsResponse = OCIBastionClient.executeRequest(() -> this.bastionClient.listBastions(listBastionsRequest));
        for (BastionSummary summary : listBastionsResponse.getItems()) {
            String targetSubnetID = summary.getTargetSubnetId();
            if (!subnetID.equals(targetSubnetID)) continue;
            bastionID = summary.getId();
            break;
        }
        return bastionID;
    }

    public SessionDetails findOrCreateSession(String bastionID, PrivateEndpointConfiguration endpointConfig) throws GeneralSecurityException, IOException {
        SessionKey key = SessionKey.instance();
        ListSessionsRequest listSessionsRequest = ListSessionsRequest.builder().displayName(key.getID()).sessionLifecycleState(SessionLifecycleState.Active).bastionId(bastionID).build();
        OCIUtils.info("Looking for a session (display name: {0})", key.getID());
        ListSessionsResponse listSessionsResponse = OCIBastionClient.executeRequest(() -> this.bastionClient.listSessions(listSessionsRequest));
        Session session = null;
        for (SessionSummary s : listSessionsResponse.getItems()) {
            session = this.matchSession(key, s);
            if (session == null) continue;
            OCIUtils.info("Found existing session (id: {0})", session.getId());
            break;
        }
        if (session == null) {
            OCIUtils.info("No matching session found, creating one", new Object[0]);
            CreatePortForwardingSessionTargetResourceDetails targetResourceDetails = CreatePortForwardingSessionTargetResourceDetails.builder().targetResourcePort(Integer.valueOf(endpointConfig.getTargetPort())).targetResourcePrivateIpAddress(endpointConfig.getEndpointIP()).build();
            CreateSessionDetails sessionDetails = CreateSessionDetails.builder().bastionId(bastionID).targetResourceDetails((CreateSessionTargetResourceDetails)targetResourceDetails).displayName(key.getID()).keyDetails(PublicKeyDetails.builder().publicKeyContent(key.getOpenSSHPublicKey()).build()).sessionTtlInSeconds(Integer.valueOf(10800)).build();
            CreateSessionResponse sessionResponse = OCIBastionClient.executeRequest(() -> this.bastionClient.createSession(CreateSessionRequest.builder().createSessionDetails(sessionDetails).build()));
            session = sessionResponse.getSession();
            OCIUtils.info("Session creation requested (id: {0}; state: {1})", session.getId(), session.getLifecycleState());
            switch (session.getLifecycleState()) {
                case Active: {
                    break;
                }
                case Creating: {
                    String workID = sessionResponse.getOpcWorkRequestId();
                    this.waitForWork(workID);
                    break;
                }
            }
        }
        return SessionDetails.builder().bastionID(bastionID).sessionID(session.getId()).key(key).build();
    }

    private Session matchSession(SessionKey key, SessionSummary summary) throws IOException {
        PublicKeyDetails keyDetails;
        Session match = null;
        String sessionID = summary.getId();
        int ttl = summary.getSessionTtlInSeconds();
        Date createTime = summary.getTimeCreated();
        long timeAlive = (System.currentTimeMillis() - createTime.getTime()) / 1000L;
        GetSessionRequest getSessionRequest = GetSessionRequest.builder().sessionId(summary.getId()).build();
        GetSessionResponse getSessionResponse = OCIBastionClient.executeRequest(() -> this.bastionClient.getSession(getSessionRequest));
        Session candidate = getSessionResponse.getSession();
        if (Objects.equals(candidate.getDisplayName(), key.getID()) && (keyDetails = candidate.getKeyDetails()) != null && Objects.equals(keyDetails.getPublicKeyContent(), key.getOpenSSHPublicKey())) {
            match = candidate;
        }
        return match;
    }

    public int openTunnel(PrivateEndpointConfiguration endpointConfig, SessionDetails details) throws IOException {
        KeyIdentityProvider kip = KeyIdentityProvider.wrapKeyPairs((KeyPair[])new KeyPair[]{details.key.getKeyPair()});
        OCIUtils.info("Opening tunnel: {0}", details);
        this.sshClient.start();
        String bastionHost = "host.bastion." + this.getRegion() + ".oci.oraclecloud.com";
        ClientSession clientSession = (ClientSession)((ConnectFuture)this.sshClient.connect(details.getSessionID(), bastionHost, 22).verify(120000L)).getSession();
        clientSession.addPublicKeyIdentity(details.getKey().getKeyPair());
        OCIUtils.info("sleeping for {0}ms", 15000);
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException e) {
            OCIUtils.info("woken up from nap", new Object[0]);
        }
        long start = System.currentTimeMillis();
        OCIUtils.info("authenticating ssh session", new Object[0]);
        try {
            clientSession.auth().verify(120000L);
        }
        catch (IOException e) {
            OCIUtils.severe("Error authenticating: {0}", e.getLocalizedMessage());
        }
        OCIUtils.info("authentication took {0}ms", Long.toString(System.currentTimeMillis() - start));
        OCIUtils.info("opening local port forward tunnel", new Object[0]);
        SshdSocketAddress dest = new SshdSocketAddress(endpointConfig.getHost(), endpointConfig.getTargetPort());
        SshdSocketAddress tunnel = clientSession.startLocalPortForwarding(0, dest);
        return tunnel.getPort();
    }

    private void waitForWork(String workID) throws IOException {
        GetWorkRequestRequest workRequestRequest = GetWorkRequestRequest.builder().workRequestId(workID).build();
        block6: while (true) {
            OCIUtils.info("Checking for work request state (id: {0})", workID);
            GetWorkRequestResponse workRequestResponse = OCIBastionClient.executeRequest(() -> this.bastionClient.getWorkRequest(workRequestRequest));
            WorkRequest workRequest = workRequestResponse.getWorkRequest();
            Float retry = workRequestResponse.getRetryAfter();
            if (retry == null) {
                retry = Float.valueOf(5.0f);
            }
            OCIUtils.info("Work request state: {0}", workRequest.getStatus());
            switch (workRequest.getStatus()) {
                case Succeeded: {
                    break block6;
                }
                case Failed: 
                case Canceled: 
                case Canceling: {
                    throw new IOException(Messages.format("BASTION_ERROR_WORK_REQUEST_STATE", workRequest.getStatus(), workRequest.getOperationType()));
                }
                default: {
                    int waittime = Math.round(retry.floatValue() * 1000.0f);
                    try {
                        Thread.sleep(waittime);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue block6;
                }
            }
            break;
        }
    }

    public static final class Builder
    extends OCIClient.Builder<Builder, OCIBastionClient> {
        private SshClient sshCLient;

        private Builder(OCIProfile profile) {
            super(profile);
        }

        public Builder sshClient(SshClient client) {
            this.sshCLient = client;
            return this;
        }

        @Override
        public OCIBastionClient build() {
            return new OCIBastionClient(this);
        }
    }

    static final class SessionDetails {
        private final SessionKey key;
        private final String sessionID;
        private final String bastionID;

        static Builder builder() {
            return new Builder();
        }

        private SessionDetails(Builder builder) {
            this.sessionID = builder.sessionID;
            this.key = builder.key;
            this.bastionID = builder.bastionID;
        }

        String getSessionID() {
            return this.sessionID;
        }

        SessionKey getKey() {
            return this.key;
        }

        String getBastionID() {
            return this.bastionID;
        }

        public String toString() {
            return "SessionDetails{key=" + String.valueOf(this.key) + ", sessionID='" + this.sessionID + "', bastionID='" + this.bastionID + "'}";
        }

        private static final class Builder {
            private SessionKey key;
            private String sessionID;
            private String bastionID;

            private Builder() {
            }

            Builder key(SessionKey key) {
                this.key = key;
                return this;
            }

            Builder sessionID(String sessionID) {
                this.sessionID = sessionID;
                return this;
            }

            Builder bastionID(String bastionID) {
                this.bastionID = bastionID;
                return this;
            }

            SessionDetails build() {
                return new SessionDetails(this);
            }
        }
    }
}

