/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.log;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import net.ucanaccess.log.ILoggerResourceMessage;

public final class Logger {
    private static PrintWriter logPrintWriter;
    private static ResourceBundle messageBundle;

    static {
        messageBundle = ResourceBundle.getBundle("net.ucanaccess.log.logger_messages");
    }

    private Logger() {
    }

    public static void dump() {
        Arrays.stream(Thread.currentThread().getStackTrace()).forEach(Logger::log);
    }

    public static void turnOffJackcessLog() {
        java.util.logging.Logger.getLogger("com.healthmarketscience.jackcess").setLevel(Level.OFF);
    }

    public static PrintWriter getLogPrintWriter() {
        return logPrintWriter;
    }

    public static String getMessage(String _code, Object ... _params) {
        String msg = Optional.ofNullable(_code).map(messageBundle::getString).orElse(_code);
        if (_code != null && _params != null && _params.length > 0) {
            msg = String.format(msg, _params);
        }
        return msg;
    }

    public static String getMessage(ILoggerResourceMessage _code, Object ... _params) {
        return _code == null ? null : Logger.getMessage(_code.name(), _params);
    }

    public static void log(Object _obj) {
        Optional.ofNullable(logPrintWriter).ifPresent(l -> {
            l.println(_obj);
            l.flush();
        });
    }

    public static void logWarning(String _warning) {
        System.err.println("WARNING: " + _warning);
    }

    public static void logWarning(ILoggerResourceMessage _code, String ... _par) {
        Logger.logWarning(Logger.getMessage(_code, (Object[])_par));
    }

    public static void setLogPrintWriter(PrintWriter _logPrintWriter) {
        logPrintWriter = _logPrintWriter;
    }
}

