/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import com.healthmarketscience.jackcess.util.OleBlob;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import net.ucanaccess.jdbc.BlobKey;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import net.ucanaccess.util.Try;

public class UcanaccessBlob
implements Blob {
    private Blob blob;
    private boolean usingBlobKey;
    private UcanaccessConnection conn;

    public UcanaccessBlob(Blob _blob, UcanaccessConnection _conn) throws SQLException {
        this.blob = _blob;
        this.conn = _conn;
        if (_blob.length() != 0L) {
            BlobKey bk = BlobKey.getBlobKey(_blob.getBinaryStream());
            boolean bl = this.usingBlobKey = bk != null;
            if (this.usingBlobKey) {
                this.blob = bk.getOleBlob(this.conn.getDbIO());
            }
        }
    }

    public static Blob createBlob(File fl, UcanaccessConnection _conn) throws UcanaccessSQLException {
        return Try.catching(() -> {
            OleBlob oleBlob = new OleBlob.Builder().setPackagePrettyName(fl.getName()).setSimplePackage(fl).toBlob();
            return new UcanaccessBlob((Blob)oleBlob, _conn);
        }).orThrow(UcanaccessSQLException::new);
    }

    public static Blob createBlob(UcanaccessConnection _conn) throws SQLException {
        return new UcanaccessBlob(_conn.getHSQLDBConnection().createBlob(), _conn);
    }

    @Override
    public void free() throws SQLException {
        try {
            this.blob.free();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        try {
            OleBlob ole;
            if (this.usingBlobKey && (ole = (OleBlob)this.blob).getContent() instanceof OleBlob.EmbeddedContent) {
                return ((OleBlob.EmbeddedContent)ole.getContent()).getStream();
            }
            return this.blob.getBinaryStream();
        }
        catch (IOException | SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        try {
            return this.blob.getBinaryStream(pos, length);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        try {
            return this.blob.getBytes(pos, length);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public long length() throws SQLException {
        try {
            return this.blob.length();
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        try {
            return this.blob.position(pattern, start);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        try {
            return this.blob.position(pattern, start);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        try {
            OleBlob ole;
            OleBlob.Content content;
            if (this.blob instanceof OleBlob && pos == 1L && (content = (ole = (OleBlob)this.blob).getContent()) instanceof OleBlob.EmbeddedContent) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ((OleBlob.SimplePackageContent)content).writeTo((OutputStream)baos);
                return baos;
            }
            return this.blob.setBinaryStream(pos);
        }
        catch (IOException | SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        try {
            return this.blob.setBytes(pos, bytes);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        try {
            return this.blob.setBytes(pos, bytes, offset, len);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void truncate(long len) throws SQLException {
        try {
            this.blob.truncate(len);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }
}

