/*
 * Decompiled with CFR 0.152.
 */
package oracle.soda.rdbms.impl;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import oracle.json.common.LobInputStream;
import oracle.json.common.MetricsCollector;
import oracle.json.logging.OracleLog;
import oracle.json.util.ByteArray;
import oracle.json.util.JsonByteArray;
import oracle.soda.OracleCollection;
import oracle.soda.OracleCursor;
import oracle.soda.OracleDocument;
import oracle.soda.OracleException;
import oracle.soda.rdbms.impl.CollectionDescriptor;
import oracle.soda.rdbms.impl.Operation;
import oracle.soda.rdbms.impl.OracleCollectionImpl;
import oracle.soda.rdbms.impl.OracleDatabaseImpl;
import oracle.soda.rdbms.impl.OracleDocumentImpl;
import oracle.soda.rdbms.impl.SODAMessage;
import oracle.soda.rdbms.impl.SODAUtils;
import oracle.soda.rdbms.impl.TableCollectionImpl;

public class OracleCursorImpl
implements OracleCursor {
    private static final Logger log = Logger.getLogger(OracleCursorImpl.class.getName());
    private Statement stmt;
    private ResultSet resultSet;
    private Operation operation;
    private long cumTime;
    private int rowCount;
    private int maxRowLimit = -1;
    private final CollectionDescriptor desc;
    private final MetricsCollector metrics;
    private final OracleCollection coll;
    private OracleDocument nextDocument;
    boolean closed;
    private boolean projectedContent = false;
    private boolean patchedContent = false;
    private boolean hasDoctype = false;
    private boolean hasMetadata = true;
    private boolean eJSON = false;
    private byte[] sql_query = null;

    OracleCursorImpl(CollectionDescriptor collectionDescriptor, MetricsCollector metricsCollector, Operation operation, ResultSet resultSet) throws OracleException {
        this.desc = collectionDescriptor;
        this.metrics = metricsCollector;
        this.operation = operation;
        this.stmt = operation.getStatement();
        this.coll = operation.getCollection();
        this.resultSet = resultSet;
        this.hasDoctype = collectionDescriptor.doctypeColumnName != null;
        this.closed = false;
    }

    OracleCursorImpl(CollectionDescriptor collectionDescriptor, MetricsCollector metricsCollector, Operation operation, ResultSet resultSet, boolean bl, boolean bl2, boolean bl3) throws OracleException {
        this(collectionDescriptor, metricsCollector, operation, resultSet);
        this.projectedContent = bl;
        this.patchedContent = bl2;
        this.hasMetadata = !bl2;
        this.eJSON = bl3;
    }

    void setElapsedTime(long l) {
        this.cumTime += l;
    }

    public void skipRows(long l) throws OracleException {
        for (long i = 0L; i < l && !this.closed; ++i) {
            this.next();
        }
    }

    public void setLimit(int n) {
        this.maxRowLimit = n;
    }

    @Override
    public boolean hasNext() throws OracleException {
        if (this.closed) {
            return false;
        }
        if (this.nextDocument != null) {
            return true;
        }
        this.nextDocument = this.next();
        return this.nextDocument != null;
    }

    private byte[] getJsonBinaryPayload() throws SQLException, OracleException {
        LobInputStream lobInputStream = null;
        byte[] byArray = null;
        Blob blob = this.resultSet.getBlob(1);
        if (blob != null) {
            long l = blob.length();
            if (l == 0L) {
                blob.free();
                return null;
            }
            InputStream inputStream = blob.getBinaryStream();
            if (inputStream != null) {
                lobInputStream = new LobInputStream(blob, inputStream, l);
                lobInputStream.setMetrics(this.metrics);
            }
        }
        if (lobInputStream != null) {
            try {
                byArray = JsonByteArray.loadStream(lobInputStream).toArray();
            }
            catch (IOException iOException) {
                if (OracleLog.isLoggingEnabled()) {
                    log.severe(iOException.toString());
                }
                throw new OracleException(iOException);
            }
        }
        return byArray;
    }

    private byte[] getPatchedOrProjectedPayload() throws SQLException, OracleException {
        String string = null;
        switch (this.desc.contentDataType) {
            case 5: 
            case 6: {
                Clob clob = this.resultSet.getClob(1);
                if (clob == null) break;
                string = clob.getSubString(1L, (int)clob.length());
                clob.free();
                break;
            }
            case 4: {
                if (this.desc.hasBinaryFormat()) {
                    return this.getJsonBinaryPayload();
                }
            }
            case 2: {
                return this.resultSet.getBytes(1);
            }
            case 7: {
                return OracleDatabaseImpl.getBytesForJson(this.resultSet, 1);
            }
            default: {
                string = this.resultSet.getString(1);
            }
        }
        if (string != null) {
            return string.getBytes(ByteArray.DEFAULT_CHARSET);
        }
        return null;
    }

    @Override
    public OracleDocument next() throws OracleException {
        if (this.closed) {
            throw SODAUtils.makeException(SODAMessage.EX_CANT_CALL_NEXT_ON_CLOSED_CURSOR, new Object[0]);
        }
        OracleDocumentImpl oracleDocumentImpl = null;
        if (this.nextDocument != null) {
            oracleDocumentImpl = (OracleDocumentImpl)this.nextDocument;
            this.nextDocument = null;
            return oracleDocumentImpl;
        }
        LobInputStream lobInputStream = null;
        long l = this.metrics.getTime();
        try {
            int n = 0;
            String string = null;
            byte[] byArray = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            boolean bl = this.resultSet.next();
            if (bl && this.projectedContent) {
                byArray = this.getPatchedOrProjectedPayload();
                while (byArray == null && (bl = this.resultSet.next())) {
                    byArray = this.getPatchedOrProjectedPayload();
                }
                ++n;
            }
            if (bl) {
                Object object;
                boolean bl2 = true;
                boolean bl3 = true;
                boolean bl4 = false;
                if (this.operation != null) {
                    bl2 = !this.operation.headerOnly();
                    bl3 = this.operation.isFilterSpecBased();
                    bl4 = this.operation.isSingleKeyBased();
                }
                if (this.patchedContent) {
                    byArray = this.getPatchedOrProjectedPayload();
                    ++n;
                } else if (!this.projectedContent && bl2) {
                    switch (this.desc.contentDataType) {
                        case 1: 
                        case 5: {
                            object = this.resultSet.getString(++n);
                            if (object == null) break;
                            byArray = ((String)object).getBytes(ByteArray.DEFAULT_CHARSET);
                            break;
                        }
                        case 3: 
                        case 6: {
                            String string6 = this.resultSet.getNString(++n);
                            if (string6 == null) break;
                            byArray = string6.getBytes(ByteArray.DEFAULT_CHARSET);
                            break;
                        }
                        case 4: {
                            boolean bl5;
                            boolean bl6 = bl5 = this.hasDoctype && !bl3;
                            if (bl4) {
                                if (string5 == null) {
                                    bl5 = false;
                                } else if (string5.equalsIgnoreCase("application/json")) {
                                    bl5 = false;
                                }
                            }
                            if (bl5) {
                                Blob blob;
                                if ((blob = this.resultSet.getBlob(++n)) != null) {
                                    long l2 = blob.length();
                                    if (l2 == 0L) {
                                        byArray = OracleCollectionImpl.EMPTY_DATA;
                                        blob.free();
                                    } else {
                                        InputStream inputStream = blob.getBinaryStream();
                                        if (inputStream != null) {
                                            lobInputStream = new LobInputStream(blob, inputStream, l2);
                                            lobInputStream.setMetrics(this.metrics);
                                        }
                                    }
                                }
                                if (lobInputStream != null || byArray != null) break;
                                lobInputStream = new LobInputStream();
                                break;
                            }
                        }
                        case 2: {
                            byArray = this.resultSet.getBytes(++n);
                            break;
                        }
                        case 7: {
                            byArray = this.eJSON ? this.resultSet.getBytes(++n) : OracleDatabaseImpl.getBytesForJson(this.resultSet, ++n);
                        }
                    }
                }
                string = this.resultSet.getString(++n);
                if (this.hasDoctype) {
                    string5 = this.resultSet.getString(++n);
                }
                if (this.hasMetadata) {
                    if (this.desc.timestampColumnName != null) {
                        string2 = OracleDatabaseImpl.getTimestamp(this.resultSet, ++n);
                    }
                    if (this.desc.creationColumnName != null) {
                        string3 = OracleDatabaseImpl.getTimestamp(this.resultSet, ++n);
                    }
                    if (this.desc.versionColumnName != null) {
                        string4 = this.resultSet.getString(++n);
                    }
                }
                oracleDocumentImpl = lobInputStream != null ? new OracleDocumentImpl(string, string4, string2, lobInputStream, string5) : new OracleDocumentImpl(string, string4, string2, byArray);
                if (string3 != null) {
                    oracleDocumentImpl.setCreatedOn(string3);
                }
                object = (TableCollectionImpl)this.coll;
                ((TableCollectionImpl)object).setContentType(string5, oracleDocumentImpl);
                oracleDocumentImpl.setCodec(((OracleCollectionImpl)object).getCodec());
                if (OracleDatabaseImpl.isOracleJsonAvailable()) {
                    oracleDocumentImpl.setJsonFactory(((OracleCollectionImpl)object).getDatabase().getJsonFactory());
                }
                if ((this.desc.hasBinaryFormat() || this.desc.hasJsonType()) && !this.eJSON) {
                    if (!OracleDatabaseImpl.isOracleJsonAvailable()) {
                        try {
                            if (!this.closed) {
                                this.closeInternal();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw SODAUtils.makeException(SODAMessage.EX_JSON_FACTORY_MISSING_IN_JDBC, new Object[0]);
                    }
                    oracleDocumentImpl.setBinary();
                }
                ++this.rowCount;
                this.cumTime += this.metrics.getTimeDiff(l);
            } else {
                this.closeInternal();
            }
            if (this.maxRowLimit > 0) {
                --this.maxRowLimit;
            } else if (this.maxRowLimit == 0) {
                oracleDocumentImpl = null;
                if (!this.closed) {
                    this.closeInternal();
                }
            }
        }
        catch (SQLException sQLException) {
            block52: {
                block51: {
                    if (OracleLog.isLoggingEnabled()) {
                        log.severe(sQLException.toString());
                    }
                    try {
                        if (lobInputStream != null) {
                            lobInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (!OracleLog.isLoggingEnabled()) break block51;
                        log.severe(iOException.toString());
                    }
                }
                try {
                    if (!this.closed) {
                        this.closeInternal();
                    }
                }
                catch (SQLException sQLException2) {
                    if (!OracleLog.isLoggingEnabled()) break block52;
                    log.severe(sQLException2.toString());
                }
            }
            throw new OracleException(sQLException);
        }
        return oracleDocumentImpl;
    }

    public byte[] getQuery() {
        return this.sql_query;
    }

    void setQuery(byte[] byArray) {
        this.sql_query = byArray;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void closeInternal() throws SQLException {
        this.operation = null;
        this.closed = true;
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            this.resultSet = null;
            if (this.stmt != null) {
                this.stmt.close();
            }
            this.stmt = null;
        }
        finally {
            for (String string : SODAUtils.closeCursor(this.stmt, this.resultSet)) {
                if (!OracleLog.isLoggingEnabled()) continue;
                log.severe(string);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.operation = null;
        try {
            this.closeInternal();
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException);
        }
        if (OracleLog.isLoggingEnabled()) {
            log.fine("Cursor read " + this.rowCount + " rows in " + this.metrics.nanosToString(this.cumTime));
        }
        this.metrics.recordCursorReads(this.rowCount, 1000, this.cumTime);
    }
}

