/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import oracle.json.util.ByteArray;

public class ReaderInputStream
extends InputStream {
    private static final int FETCH_SIZE = 4096;
    private final Reader reader;
    private byte[] single = new byte[1];
    protected boolean closed = false;
    private byte[] temp = null;
    private int temploc = 0;
    private int templen = 0;

    public ReaderInputStream(Reader reader) {
        this.reader = reader;
    }

    public ReaderInputStream(InputStream inputStream, Charset charset) {
        this(new BufferedReader(new InputStreamReader(inputStream, charset)));
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int n) {
    }

    @Override
    public void reset() throws IOException {
        super.reset();
    }

    @Override
    public int available() {
        return 0;
    }

    @Override
    public long skip(long l) throws IOException {
        return super.skip(l);
    }

    private int getData(byte[] byArray, int n, int n2) throws IOException {
        if (this.templen == 0) {
            if (this.closed) {
                return -1;
            }
            char[] cArray = new char[4096];
            int n3 = this.reader.read(cArray, 0, cArray.length);
            if (n3 <= 0) {
                this.close();
                return -1;
            }
            String string = new String(cArray, 0, n3);
            this.temp = string.getBytes(ByteArray.DEFAULT_CHARSET);
            this.templen = this.temp.length;
            this.temploc = 0;
        }
        if (n2 > this.templen) {
            n2 = this.templen;
        }
        if (n2 > 0) {
            System.arraycopy(this.temp, this.temploc, byArray, n, n2);
        }
        this.templen -= n2;
        this.temploc += n2;
        return n2;
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.single);
        if (n == 1) {
            return this.single[0] & 0xFF;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (n2 > 0) {
            while (n2 > 0) {
                int n4 = this.getData(byArray, n, n2);
                if (n4 <= 0) {
                    if (n3 != 0) break;
                    n3 = -1;
                    break;
                }
                n2 -= n4;
                n += n4;
                n3 += n4;
            }
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.reader != null) {
                this.reader.close();
            }
            super.close();
        }
    }
}

