/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.util;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream {
    private static final byte[] EMPTY_CONTENT = new byte[0];
    private final long limit;
    private long total = 0L;
    private long markPos = -1L;
    private byte[] single = new byte[1];
    protected boolean closed = false;

    public LimitedInputStream(InputStream inputStream, long l) {
        super(inputStream);
        this.limit = l;
    }

    public LimitedInputStream(InputStream inputStream, int n) {
        this(inputStream, (long)n);
    }

    public LimitedInputStream() {
        this((InputStream)new ByteArrayInputStream(EMPTY_CONTENT), 0);
    }

    public long availableLong() {
        return this.limit - this.total;
    }

    @Override
    public boolean markSupported() {
        return super.markSupported();
    }

    @Override
    public void mark(int n) {
        super.mark(n);
        this.markPos = this.total;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        if (this.markPos >= 0L) {
            this.total = this.markPos;
        }
    }

    @Override
    public int available() {
        long l = this.availableLong();
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2 = this.availableLong();
        if (l2 > l) {
            l2 = l;
        }
        if ((l2 = super.skip(l2)) > 0L) {
            this.total += l2;
        }
        return l2;
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this.single);
        if (n == 1) {
            return this.single[0] & 0xFF;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    protected int timedRead(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = -1;
        if (n2 == 0) {
            n3 = 0;
        } else {
            int n4 = this.available();
            if (n4 > n2) {
                n4 = n2;
            }
            if (n4 > 0) {
                n3 = this.timedRead(byArray, n, n4);
                if (n3 > 0) {
                    this.total += (long)n3;
                } else if (n3 < 0) {
                    this.total = this.limit;
                }
            }
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            super.close();
        }
    }
}

