/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.util;

import java.nio.charset.Charset;
import oracle.json.util.ByteArray;

public final class JsonByteArray
extends ByteArray {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Charset UTF16 = Charset.forName("UTF-16");
    private static final Charset UTF16BE = Charset.forName("UTF-16BE");
    private static final Charset UTF16LE = Charset.forName("UTF-16LE");
    private static final String UTF32 = "UTF-32";
    private static final String UTF32BE = "UTF-32BE";
    private static final String UTF32LE = "UTF-32LE";
    private static byte[] DOUBLE_QUOTE = new byte[]{34};
    private static byte[] OPEN_BRACKET = new byte[]{91};
    private static byte[] CLOSE_BRACKET = new byte[]{93};
    private static byte[] OPEN_BRACE = new byte[]{123};
    private static byte[] CLOSE_BRACE = new byte[]{125};
    private static byte[] COLON = new byte[]{58};
    private static byte[] COMMA = new byte[]{44};
    private static byte[] BACKSLASH = new byte[]{92};
    private static byte[] UNICODE = new byte[]{92, 117};
    private static byte[] NEWLINE = new byte[]{92, 110};
    private static byte[] HORIZONTAL_TAB = new byte[]{92, 116};
    private static byte[] CARRIAGE_RETURN = new byte[]{92, 114};
    private byte[] hextmp = new byte[4];

    public JsonByteArray(int n) {
        super(n);
    }

    public JsonByteArray() {
    }

    public void append(String string) {
        this.append(string.getBytes(DEFAULT_CHARSET));
    }

    public void appendOpenArray() {
        this.append(OPEN_BRACKET);
    }

    public void appendCloseArray() {
        this.append(CLOSE_BRACKET);
    }

    public void appendOpenBrace() {
        this.append(OPEN_BRACE);
    }

    public void appendCloseBrace() {
        this.append(CLOSE_BRACE);
    }

    public void appendColon() {
        this.append(COLON);
    }

    public void appendComma() {
        this.append(COMMA);
    }

    public void appendDoubleQuote() {
        this.append(DOUBLE_QUOTE);
    }

    public void appendValue(String string) {
        this.appendDoubleQuote();
        byte[] byArray = string.getBytes(DEFAULT_CHARSET);
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n2 = byArray[i] & 0xFF;
            if (n2 >= 32 && n2 != 34 && n2 != 92) continue;
            this.append(byArray, n, i - n);
            n = i + 1;
            if (n2 == 10) {
                this.append(NEWLINE);
                continue;
            }
            if (n2 == 9) {
                this.append(HORIZONTAL_TAB);
                continue;
            }
            if (n2 == 13) {
                this.append(CARRIAGE_RETURN);
                continue;
            }
            if (n2 < 32) {
                this.append(UNICODE);
                int n3 = 61440;
                int n4 = 12;
                for (int j = 0; j < 4; ++j) {
                    int n5 = (n2 & n3) >> n4;
                    n5 = n5 < 10 ? (n5 += 48) : n5 - 10 + 65;
                    this.hextmp[j] = (byte)n5;
                    n4 -= 4;
                    n3 >>= 4;
                }
                this.append(this.hextmp);
                continue;
            }
            this.append(BACKSLASH);
            --n;
        }
        this.append(byArray, n, byArray.length - n);
        this.appendDoubleQuote();
    }

    public static Charset getJsonCharset(byte[] byArray) {
        if (byArray.length >= 3 && byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            return UTF8;
        }
        if (byArray.length >= 2) {
            if (byArray[0] == -1 && byArray[1] == -2) {
                if (byArray.length >= 4 && byArray[2] == 0 && byArray[3] == 0) {
                    return Charset.forName(UTF32);
                }
                return UTF16;
            }
            if (byArray[0] == -2 && byArray[1] == -1) {
                return UTF16;
            }
            if (byArray.length >= 4 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
                return Charset.forName(UTF32);
            }
        }
        if (byArray.length >= 4) {
            if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0) {
                return Charset.forName(UTF32BE);
            }
            if (byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0) {
                return Charset.forName(UTF32LE);
            }
        }
        if (byArray.length >= 2) {
            if (byArray[0] == 0) {
                return UTF16BE;
            }
            if (byArray[1] == 0) {
                return UTF16LE;
            }
        }
        return UTF8;
    }
}

