/*
 * Decompiled with CFR 0.152.
 */
package oracle.json.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import oracle.json.common.ArgumentParseException;
import oracle.json.common.CommandArgument;
import oracle.json.common.Configuration;
import oracle.json.common.Message;
import oracle.json.util.JsonByteArray;
import oracle.json.util.MimeTypeLookup;

public class ArgumentList {
    private static final int DEFAULT_NUM_ARGS = 10;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] DASHDASH = new byte[]{45, 45};
    private static final byte[] HEXDIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 97, 98, 99, 100, 101, 102};
    private final ArrayList<CommandArgument> args = new ArrayList(10);
    private HashMap<String, String[]> argsByName = null;
    private final String encoding;
    private final MimeTypeLookup getMimeType;

    public ArgumentList() {
        this("utf-8");
    }

    public ArgumentList(String string) {
        this(string, null);
    }

    public ArgumentList(String string, MimeTypeLookup mimeTypeLookup) {
        this.encoding = string;
        this.getMimeType = mimeTypeLookup;
    }

    public void clear() {
        this.args.clear();
        if (this.argsByName != null) {
            this.argsByName.clear();
        }
    }

    public int getCount() {
        return this.args.size();
    }

    private ArgumentParseException makeError(Message message) {
        return new ArgumentParseException(message.get(new Object[0]));
    }

    private void parseUriArguments(byte[] byArray, int n, boolean bl) throws ArgumentParseException {
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        int n4 = HEXDIGITS.length;
        byte[] byArray2 = byArray;
        try {
            block8: for (n2 = 0; n2 < n; ++n2) {
                byte by = byArray[n2];
                switch (by) {
                    case 37: {
                        int n5;
                        int n6 = 0;
                        if (n - n2 > 2) {
                            for (n5 = 0; n5 < 2; ++n5) {
                                int n7;
                                for (n7 = 0; n7 < n4 && HEXDIGITS[n7] != byArray[n2 + n5 + 1]; ++n7) {
                                }
                                if (n7 >= n4) break;
                                if (n7 >= 16) {
                                    n7 -= 6;
                                }
                                n6 <<= 4;
                                n6 += n7;
                            }
                        }
                        if (n5 == 2) {
                            byArray2[n3++] = (byte)n6;
                            n2 += 2;
                            continue block8;
                        }
                        byArray2[n3++] = by;
                        continue block8;
                    }
                    case 43: {
                        byArray2[n3++] = bl2 ? 32 : 43;
                        continue block8;
                    }
                    case 61: {
                        if (bl2) {
                            byArray2[n3++] = by;
                            continue block8;
                        }
                        if (n3 <= 0) continue block8;
                        string = new String(byArray2, 0, n3, this.encoding);
                        bl2 = true;
                        n3 = 0;
                        continue block8;
                    }
                    case 38: {
                        if (bl2) {
                            string2 = new String(byArray2, 0, n3, this.encoding);
                            this.args.add(new CommandArgument(string, string2, !bl));
                            bl2 = false;
                        } else if (n3 > 0) {
                            string = new String(byArray2, 0, n3, this.encoding);
                            this.args.add(new CommandArgument(string, "", !bl));
                        }
                        n3 = 0;
                        continue block8;
                    }
                    default: {
                        byArray2[n3++] = by;
                    }
                }
            }
            if (n3 > 0 || bl2) {
                if (bl2) {
                    string2 = new String(byArray2, 0, n3, this.encoding);
                } else {
                    string = new String(byArray2, 0, n3, this.encoding);
                    string2 = "";
                }
                this.args.add(new CommandArgument(string, string2, !bl));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ArgumentParseException(unsupportedEncodingException);
        }
    }

    public void parseUrl(String string) throws ArgumentParseException {
        try {
            byte[] byArray = string.getBytes(this.encoding);
            this.parseUriArguments(byArray, byArray.length, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw this.makeError(Message.EX_QUERY_STR_CONVERSION);
        }
    }

    public void parsePost(byte[] byArray, int n) throws ArgumentParseException {
        this.parseUriArguments(byArray, n, false);
    }

    public void parseMultipart(String string, InputStream inputStream) throws IOException {
        JsonByteArray jsonByteArray = new JsonByteArray(inputStream.available() + 2);
        jsonByteArray.append(CRLF);
        jsonByteArray.append(inputStream);
        this.parseMultipart(string, jsonByteArray.getArray(), jsonByteArray.getLength());
    }

    public void parseMultipart(String string, byte[] byArray, int n) throws ArgumentParseException {
        int n2 = -1;
        int n3 = 0;
        try {
            byte[] byArray2 = string.getBytes(this.encoding);
            int n4 = byArray2.length;
            while (n3 < n) {
                String string2;
                n2 = ArgumentList.findPattern(byArray, n3, n, byArray2, n4);
                if (n2 != n3) {
                    throw this.makeError(Message.EX_NO_BOUND);
                }
                if (n - (n3 += n4) < 2) {
                    return;
                }
                if (ArgumentList.compareBytes(byArray, n3, 2, DASHDASH, 0, 2) == 0) {
                    return;
                }
                if (ArgumentList.compareBytes(byArray, n3, 2, CRLF, 0, 2) != 0) {
                    throw this.makeError(Message.EX_NO_LINE_BREAK);
                }
                n2 = ArgumentList.findPattern(byArray, n3 += 2, n, CRLF, 2);
                if (n2 < 0) {
                    throw this.makeError(Message.EX_NO_LINE_TERMINATOR);
                }
                byArray[n2++] = 59;
                String string3 = new String(byArray, n3, n2 - n3, this.encoding);
                n3 = ++n2;
                int n5 = string3.indexOf("name=\"");
                if (n5 < 0) {
                    throw this.makeError(Message.EX_FIELD_NAME_NOT_FOUND);
                }
                if ((n5 += 6) == n) {
                    throw this.makeError(Message.EX_FIELD_NAME_NOT_VALID);
                }
                int n6 = string3.indexOf("\"", n5);
                if (n6 < 0) {
                    throw this.makeError(Message.EX_NO_CLOSING_QUOTE);
                }
                String string4 = string3.substring(n5, n6);
                n5 = string3.indexOf("filename=\"", n6);
                if (n5 > n6) {
                    n6 = string3.indexOf("\"", n5 += 10);
                    if (n6 < 0) {
                        throw this.makeError(Message.EX_NO_CLOSING_QUOTE);
                    }
                    string2 = string3.substring(n5, n6);
                } else {
                    string2 = null;
                }
                String string5 = null;
                if (string2 != null && this.getMimeType != null && (string5 = this.getMimeType.getMimeType(string2)) == null) {
                    string5 = "application/octet-stream";
                }
                while (true) {
                    int n7;
                    if ((n2 = ArgumentList.findPattern(byArray, n3, n, CRLF, 2)) < 0) {
                        throw this.makeError(Message.EX_NO_START_OF_FIELD);
                    }
                    if (n2 == n3) break;
                    string3 = new String(byArray, n3, n2 - n3, this.encoding);
                    n3 = n2 + 2;
                    if (!string3.startsWith("Content-Type:")) continue;
                    int n8 = string3.length();
                    for (n7 = 13; n7 < n8 && string3.charAt(n7) <= ' '; ++n7) {
                    }
                    if (n7 >= n8) continue;
                    string5 = string3.substring(n7);
                }
                n2 = ArgumentList.findPattern(byArray, n3 += 2, n, byArray2, n4);
                if (n2 < 0) {
                    throw this.makeError(Message.EX_NO_END_OF_FIELD);
                }
                if (string2 == null) {
                    String string6 = new String(byArray, n3, n2 - n3, this.encoding);
                    this.args.add(new CommandArgument(string4, string6, true));
                } else {
                    byte[] byArray3 = Arrays.copyOfRange(byArray, n3, n2);
                    this.args.add(new CommandArgument(string4, byArray3, this.encoding, string2, string5));
                }
                n3 = n2;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ArgumentParseException(unsupportedEncodingException);
        }
    }

    public void appendArgument(String string, String string2) {
        this.args.add(new CommandArgument(string, string2));
        if (this.argsByName != null) {
            String[] stringArray = this.argsByName.get(string);
            if (stringArray == null) {
                stringArray = new String[]{string2};
            } else {
                int n = stringArray.length;
                stringArray = Arrays.copyOf(stringArray, n + 1);
                stringArray[n] = string2;
            }
            this.argsByName.put(string, stringArray);
        }
    }

    private void createArgMap(int n) {
        if (this.argsByName == null) {
            if (n < 10) {
                n = 10;
            }
            this.argsByName = new HashMap(n);
        }
    }

    private void buildArgsByName() {
        int n;
        String[] stringArray;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = n3 = this.args != null ? this.args.size() : 0;
        if (this.argsByName != null) {
            n4 = this.argsByName.size();
        }
        if (n4 != 0) {
            return;
        }
        Object[] objectArray = new String[n3];
        int[] nArray = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray = this.args.get(n2);
            if (stringArray.m_Svalue == null && (stringArray.m_ContentType == null || stringArray.m_Bvalue == null || !stringArray.m_ContentType.equals("application/json"))) continue;
            int n6 = n = n4 > 0 ? Arrays.binarySearch(objectArray, 0, n4, stringArray.m_Name) : -1;
            if (n < 0) {
                if ((n = -n - 1) < n4) {
                    System.arraycopy(objectArray, n, objectArray, n + 1, n4 - n);
                    System.arraycopy(nArray, n, nArray, n + 1, n4 - n);
                }
                ++n4;
                objectArray[n] = stringArray.m_Name;
                nArray[n] = 0;
            }
            int n7 = n;
            nArray[n7] = nArray[n7] + 1;
        }
        this.createArgMap(n4);
        if (n4 > 0) {
            for (n2 = 0; n2 < n4; ++n2) {
                stringArray = new String[nArray[n2]];
                this.argsByName.put((String)objectArray[n2], stringArray);
                nArray[n2] = 0;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                CommandArgument commandArgument = this.args.get(n2);
                String string = commandArgument.m_Svalue;
                if (string == null) {
                    if (commandArgument.m_ContentType != null && commandArgument.m_Bvalue != null && commandArgument.m_ContentType.equals("application/json")) {
                        string = new String(commandArgument.m_Bvalue, Configuration.DEFAULT_CHARSET);
                    }
                    if (string == null) continue;
                }
                stringArray = this.argsByName.get(commandArgument.m_Name);
                int n8 = n = Arrays.binarySearch(objectArray, 0, n4, commandArgument.m_Name);
                int n9 = nArray[n8];
                nArray[n8] = n9 + 1;
                stringArray[n9] = string;
            }
        }
    }

    public String getParameter(String string) {
        String[] stringArray = this.getParameterValues(string);
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public String[] getParameterValues(String string) {
        this.buildArgsByName();
        if (this.argsByName == null) {
            return null;
        }
        return this.argsByName.get(string);
    }

    public HashMap<String, String[]> getParameterMap() {
        this.buildArgsByName();
        return this.argsByName;
    }

    public String[] getParameterNames() {
        this.buildArgsByName();
        if (this.argsByName == null) {
            return null;
        }
        Set<String> set = this.argsByName.keySet();
        return set.toArray(new String[set.size()]);
    }

    public CommandArgument findParameter(String string) {
        int n = this.args != null ? this.args.size() : 0;
        for (int i = 0; i < n; ++i) {
            CommandArgument commandArgument = this.args.get(i);
            if (!commandArgument.m_Name.equalsIgnoreCase(string)) continue;
            return commandArgument;
        }
        return null;
    }

    public static int compareBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n;
        int n8 = n3;
        int n9 = n6 = n2 > n4 ? n4 : n2;
        if (byArray == null || byArray2 == null) {
            if (byArray != null) {
                return 1;
            }
            if (byArray2 != null) {
                return -1;
            }
            return 0;
        }
        while (n6 > 0) {
            if ((n5 = byArray[n7++] - byArray2[n8++]) != 0) {
                return n5;
            }
            --n6;
        }
        n5 = n2 - n4;
        return n5;
    }

    private static int findPattern(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n3;
        int n5 = n2 - n;
        if (byArray != null && byArray2 != null && n4 > 0) {
            int n6 = n;
            while (n5 >= n4) {
                if (ArgumentList.compareBytes(byArray, n6, n4, byArray2, 0, n4) == 0) {
                    return n6;
                }
                --n5;
                ++n6;
            }
        }
        return -1;
    }
}

