/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.mdb.core;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.extension.mdb.command.Interfaces.CommandInterface;
import oracle.dbtools.extension.mdb.command.MDBSymbols;
import oracle.dbtools.extension.mdb.core.CopyConditionHandler;
import oracle.dbtools.extension.mdb.core.CopyState;
import oracle.dbtools.extension.mdb.exceptions.NoDataAvailableException;
import oracle.dbtools.extension.mdb.service.MDBProvider;
import oracle.dbtools.extension.mdb.service.MDBService;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.bridge.BridgeException;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;

public class MdbCopyCommand
implements CommandInterface {
    private final ParsedCommand parsedCommand;
    private final ScriptRunnerContext context;
    private final Connection connection;
    private MDBProvider mdbService;
    private String mdbFilePath;
    private String prefix;
    private String tableName;

    public MdbCopyCommand(Connection connection, ScriptRunnerContext context, ParsedCommand parsedCommand) {
        this.parsedCommand = parsedCommand;
        this.context = context;
        this.connection = connection;
    }

    @Override
    public void run() {
        this.mdbService = (MDBProvider)this.context.getService(MDBService.class);
        this.mdbService.setParsedCommand(this.parsedCommand);
        this.mdbFilePath = (String)this.parsedCommand.getOptionValue((Id)MDBSymbols.FILE);
        this.prefix = (String)this.parsedCommand.getOptionValue((Id)MDBSymbols.PREFIX);
        this.tableName = (String)this.parsedCommand.getOptionValue((Id)MDBSymbols.TABLE);
        CopyConditionHandler copyConditionHandler = new CopyConditionHandler(this.isFlagSet(MDBSymbols.VIEWS), this.isFlagSet(MDBSymbols.TABLES), this.tableName);
        CopyState copyState = copyConditionHandler.getCopyState();
        try {
            switch (copyState) {
                case TABLES: {
                    this.mdbService.copyTables(this.context, this.connection, this.mdbFilePath, this.prefix);
                    break;
                }
                case VIEWS: {
                    this.handleViews();
                    break;
                }
                case VIEWS_TABLES: 
                case NONE: {
                    this.handleAll();
                    break;
                }
                case TABLE: {
                    this.mdbService.copyTable(this.context, this.connection, this.mdbFilePath, this.tableName, this.prefix);
                }
            }
        }
        catch (IOException | SQLException | NoDataAvailableException | BridgeException e) {
            this.context.writeln(e.getMessage());
        }
    }

    private void handleViews() throws SQLException, IOException, BridgeException {
        this.mdbService.copyViews(this.context, this.connection, this.mdbFilePath, this.prefix);
        if (null != this.tableName) {
            this.mdbService.copyTable(this.context, this.connection, this.mdbFilePath, (String)this.parsedCommand.getOptionValue((Id)MDBSymbols.TABLE), this.prefix);
        }
    }

    private void handleAll() throws BridgeException, SQLException {
        try {
            this.mdbService.copyViews(this.context, this.connection, this.mdbFilePath, this.prefix);
        }
        catch (IOException | SQLException | NoDataAvailableException e) {
            this.context.writeln(e.getMessage());
        }
        this.mdbService.copyTables(this.context, this.connection, this.mdbFilePath, this.prefix);
    }

    private boolean isFlagSet(MDBSymbols symbol) {
        return this.parsedCommand.isFlagSet((Id)symbol);
    }
}

