/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.pushdpopddirs.service;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.function.Function;
import oracle.dbtools.extension.pushdpopddirs.commands.Messages;
import oracle.dbtools.extension.pushdpopddirs.service.DirectoryManager;
import oracle.dbtools.extension.pushdpopddirs.utils.FileUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.container.Lifecycle;

public class DirectoryManagerProvider
implements DirectoryManager,
Lifecycle<DirectoryManager> {
    private final Deque<String> directories = new ArrayDeque<String>();

    DirectoryManagerProvider() {
    }

    @Override
    public Deque<String> getDirectories() {
        return new ArrayDeque<String>(this.directories);
    }

    @Override
    public String getCurrentDirectory() {
        return this.directories.peek();
    }

    @Override
    public void pushDirectory(String directory) {
        this.directories.push(directory);
    }

    @Override
    public void pushInSecondPosition(String directory) {
        String currentDirectory = this.directories.pop();
        this.directories.push(directory);
        this.directories.push(currentDirectory);
    }

    @Override
    public void popDirectory() {
        if (this.directories.isEmpty()) {
            return;
        }
        this.directories.pop();
    }

    @Override
    public String pushPlus(int index) {
        String[] elements = this.directories.toArray(new String[0]);
        if (elements.length > index) {
            String elementToPush = elements[index];
            this.directories.remove(elementToPush);
            this.directories.push(elementToPush);
            return elementToPush;
        }
        String elementToPush = "~" + System.getProperty("user.home");
        this.directories.push(elementToPush);
        return elementToPush;
    }

    @Override
    public String pushMinest(int index) {
        ArrayList<String> stackList = new ArrayList<String>(this.directories);
        Collections.reverse(stackList);
        String elementToPush = (String)stackList.get(index);
        this.directories.remove(elementToPush);
        this.directories.push(elementToPush);
        return elementToPush;
    }

    @Override
    public String popPlus(int index) {
        String[] elements = this.directories.toArray(new String[0]);
        String elementToPop = elements[index];
        this.directories.remove(elementToPop);
        return !this.directories.isEmpty() ? this.directories.getFirst() : elementToPop;
    }

    @Override
    public String popMinest(int index) {
        ArrayList<String> stackList = new ArrayList<String>(this.directories);
        Collections.reverse(stackList);
        String elementToPop = (String)stackList.get(index);
        this.directories.remove(elementToPop);
        return !this.directories.isEmpty() ? this.directories.getFirst() : elementToPop;
    }

    @Override
    public void printDirectories(ScriptRunnerContext ctx, Deque<String> dirs) {
        dirs.forEach(dir -> ctx.write(dir + "\t"));
        ctx.writeln("");
    }

    @Override
    public void navigateStack(ScriptRunnerContext ctx, DirectoryManager directoryManager, String pushdParameter, Function<Integer, String> getPad) {
        Deque<String> directoryStack = directoryManager.getDirectories();
        String indexString = pushdParameter.substring(1);
        int index = Integer.parseInt(indexString);
        try {
            if (!indexString.isEmpty()) {
                if (index < directoryStack.size()) {
                    String cdPath = getPad.apply(index);
                    FileUtils.changeDirectory(ctx, cdPath);
                    this.printDirectories(ctx, directoryManager.getDirectories());
                } else {
                    ctx.writeln(Messages.getString("DIRS_NO_SUCH_ENTRY"));
                }
            }
        }
        catch (Exception e) {
            ctx.writeln(e.getMessage());
        }
    }

    @Override
    public void clearDirectories() {
        this.directories.clear();
    }
}

