/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.pushdpopddirs.commands.dirs;

import java.sql.Connection;
import java.util.Deque;
import java.util.Optional;
import oracle.dbtools.extension.pushdpopddirs.service.DirectoryManager;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPagesBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.CommandPageAssemblers;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Factory;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Parser;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Type;

public class DirsCommand
extends CommandListener
implements IHelp {
    private final String DIRS_CMD = "DIRS";

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!this.matches(cmd.getSql())) {
            return false;
        }
        Type type = this.getParserType();
        Parser parser = new Parser(type, ctx.getEnvironment());
        Optional parsedCommand = parser.parse(cmd.getSql(), arg_0 -> ((ScriptRunnerContext)ctx).writeln(arg_0));
        parsedCommand.ifPresent(command -> this.handelOptions((ParsedCommand)command, ctx));
        return true;
    }

    private void handelOptions(ParsedCommand parsedCommand, ScriptRunnerContext ctx) {
        DirectoryManager directoryManager = (DirectoryManager)ctx.getService(DirectoryManager.class);
        boolean isIndexesMustBePrinted = parsedCommand.isFlagSet((Id)Symbol.V);
        boolean isShouldBeIndifferentLine = parsedCommand.isFlagSet((Id)Symbol.P);
        boolean isStackShouldBeCleaned = parsedCommand.isFlagSet((Id)Symbol.C);
        if (isStackShouldBeCleaned) {
            directoryManager.clearDirectories();
            return;
        }
        Deque<String> directories = directoryManager.getDirectories();
        int dirSize = directories.size();
        if (dirSize == 0) {
            ctx.writeln((String)ctx.getMap().get(ScriptRunnerContext.SqlplusVariable._PWD.toString()));
            return;
        }
        for (int i = 0; i < dirSize; ++i) {
            String currentDir = directories.pop();
            ctx.write((String)(isIndexesMustBePrinted ? i + "\t" : "") + currentDir + (isShouldBeIndifferentLine || isIndexesMustBePrinted ? "\n" : "\t"));
        }
        ctx.write("\n");
    }

    public Type createType() {
        return Factory.type((Id)Symbol.DIRS).add(Factory.option((Id)Symbol.C).name("c").flag().build()).add(Factory.option((Id)Symbol.P).name("p").flag().build()).add(Factory.option((Id)Symbol.V).name("v").flag().build()).build();
    }

    public Type getParserType() {
        return this.createType();
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public String getCommand() {
        return "DIRS";
    }

    public boolean isSqlPlus() {
        return false;
    }

    public Optional<String> getHelp(ScriptRunnerContext ctx, String pagePath) {
        return this.createHelpPages(ctx, this.createType()).get(pagePath);
    }

    private HelpPages createHelpPages(ScriptRunnerContext ctx, Type type) {
        return new HelpPagesBuilder(ctx.getEnvironment()).enableColorCode(ctx.isCommandLine()).addHelpContainerFor((Object)this).addPages((Iterable)new CommandPageAssemblers(type, new Type[0])).build();
    }

    private boolean matches(String line) {
        String trimmed = line.trim();
        if (trimmed.equalsIgnoreCase("DIRS")) {
            return true;
        }
        int firstSpace = trimmed.indexOf(" ");
        if (firstSpace > 0) {
            String firstWord = line.substring(0, firstSpace);
            return firstWord.equalsIgnoreCase("DIRS");
        }
        return false;
    }

    public static enum Symbol implements Id
    {
        DIRS,
        C,
        V,
        P,
        L;

    }
}

